/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.teleportation;

import dev.tauri.jsg.api.stargate.traveler.IStargateTeleporter;
import dev.tauri.jsg.api.stargate.traveler.IStargateTraveler;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.portal.PortalInfo;

public class StargateTeleporter
implements IStargateTeleporter {
    protected IStargateTraveler<?> traveler;
    protected final Consumer<IStargateTraveler<?>> afterPlace;

    public StargateTeleporter(IStargateTraveler<?> traveler, Consumer<IStargateTraveler<?>> afterPlace) {
        this.traveler = traveler;
        this.afterPlace = afterPlace;
    }

    public Entity placeEntity(Entity entity, ServerLevel sourceLevel, ServerLevel targetLevel, float yaw, Function<Boolean, Entity> repositionEntity) {
        Entity e = repositionEntity.apply(false);
        if (e == null) {
            return null;
        }
        this.traveler = this.traveler.getTransmitter().getEventHorizonManager().getTraveler(e, this.traveler);
        this.traveler.getReceiver().getEventHorizonManager().receive(this.traveler);
        this.afterPlace.accept(this.traveler);
        return e;
    }

    public PortalInfo getPortalInfo(Entity entity, ServerLevel targetLevel, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
        return new PortalInfo(this.traveler.getDestinationPos(), this.traveler.getDestinationMotion(), this.traveler.getDestinationYaw(), entity.m_146909_());
    }

    public boolean playTeleportSound(ServerPlayer player, ServerLevel sourceLevel, ServerLevel targetLevel) {
        return false;
    }

    public boolean isVanilla() {
        return false;
    }
}

