/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.teleportation.traveler;

import dev.tauri.jsg.api.config.JSGConfig;
import dev.tauri.jsg.api.stargate.Stargate;
import dev.tauri.jsg.effect.StargateWormholeHandler;
import dev.tauri.jsg.effect.StargateWormholeType;
import dev.tauri.jsg.packet.JSGPacketHandler;
import dev.tauri.jsg.packet.packets.stargate.StargateMotionAndRotationToClient;
import dev.tauri.jsg.packet.packets.stargate.StargatePlayerMotionRequestToClient;
import dev.tauri.jsg.stargate.teleportation.StargateTeleporter;
import dev.tauri.jsg.stargate.teleportation.traveler.LivingTraveler;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.ITeleporter;

public class PlayerTraveler
extends LivingTraveler<ServerPlayer> {
    public PlayerTraveler(ServerPlayer entity, Vec3 destinationPos, Vec3 originalMotion, Vec3 destinationMotion, float destinationYaw, Stargate<?> sourceGate, Stargate<?> receivingGate, boolean isStatic) {
        super(entity, destinationPos, originalMotion, destinationMotion, destinationYaw, sourceGate, receivingGate, isStatic);
    }

    @Override
    public boolean canBeKilledByIris() {
        return !JSGConfig.Stargate.allowCreative.get() || !((ServerPlayer)this.get()).m_7500_();
    }

    @Override
    public void setMotion(Vec3 newMotion) {
        super.setMotion(newMotion);
        ((ServerPlayer)this.entity).f_19864_ = true;
        JSGPacketHandler.sendTo(new StargateMotionAndRotationToClient(newMotion, ((ServerPlayer)this.entity).m_146909_(), this.getDestinationYaw()), (ServerPlayer)this.get());
    }

    @Override
    public boolean canBeSendToTarget() {
        if (this.sourceGate.getStargatePos() == null || this.receivingGate.getStargatePos() == null || this.sourceGate.getStargatePos().dimension == this.receivingGate.getStargatePos().dimension) {
            return true;
        }
        return ForgeHooks.onTravelToDimension((Entity)this.entity, this.receivingGate.getStargatePos().dimension);
    }

    @Override
    public void sendChangeDimension(ServerLevel targetLevel) {
        if (this.isStatic()) {
            ((ServerPlayer)this.get()).changeDimension(targetLevel, (ITeleporter)new StargateTeleporter(this, traveler -> this.setMotion(this.getDestinationMotion())));
            return;
        }
        StargateWormholeHandler.handle((ServerPlayer)this.get(), afterPlace -> ((ServerPlayer)this.get()).changeDimension(targetLevel, (ITeleporter)new StargateTeleporter(this, traveler -> {
            afterPlace.accept((ServerPlayer)traveler.get());
            this.setMotion(this.getDestinationMotion());
        })), StargateWormholeType.fromTileEntity(this.receivingGate), 5);
    }

    @Override
    public void sendSameDimension() {
        if (this.isStatic()) {
            this.receivingGate.getEventHorizonManager().receive(this);
            return;
        }
        StargateWormholeHandler.handle((ServerPlayer)this.get(), afterPlace -> {
            this.receivingGate.getEventHorizonManager().receive(this);
            afterPlace.accept((ServerPlayer)this.get());
        }, StargateWormholeType.fromTileEntity(this.receivingGate), 3);
    }

    @Override
    public void setPos(Vec3 newPos) {
        ((ServerPlayer)this.get()).m_6021_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
    }

    @Override
    public boolean isPlayer() {
        return true;
    }

    @Override
    public void send() {
        JSGPacketHandler.sendTo(new StargatePlayerMotionRequestToClient(this.getTransmitter().blockPosition(), false), (ServerPlayer)this.get());
    }

    @Override
    public void killWrongTravel() {
        JSGPacketHandler.sendTo(new StargatePlayerMotionRequestToClient(this.getTransmitter().blockPosition(), true), (ServerPlayer)this.get());
    }

    public void confirmSend() {
        super.send();
    }

    public void confirmKillWrongTravel() {
        super.killWrongTravel();
    }

    @Override
    public void killIris() {
        ((ServerPlayer)this.get()).m_20331_(false);
        ((ServerPlayer)this.get()).m_6842_(false);
        ((ServerPlayer)this.get()).f_19794_ = false;
        ((ServerPlayer)this.get()).m_150110_().f_35934_ = false;
        ((ServerPlayer)this.get()).m_150110_().f_35938_ = true;
        ((ServerPlayer)this.get()).f_8941_.m_9290_().m_46398_(((ServerPlayer)this.get()).m_150110_());
        ((ServerPlayer)this.get()).m_6885_();
        super.killIris();
    }

    @Override
    public int hashCode() {
        return ((ServerPlayer)this.get()).m_20148_().hashCode();
    }
}

