/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.util;

import dev.tauri.jsg.advancements.JSGAdvancements;
import dev.tauri.jsg.api.stargate.Stargate;
import dev.tauri.jsg.api.util.JSGAxisAlignedBB;
import dev.tauri.jsg.blockentity.stargate.StargateAbstractBaseBE;
import dev.tauri.jsg.blockentity.stargate.StargateClassicBaseBE;
import dev.tauri.jsg.blockentity.stargate.StargateMilkyWayBaseBE;
import dev.tauri.jsg.blockentity.stargate.StargateMovieBaseBE;
import dev.tauri.jsg.blockentity.stargate.StargateOrlinBaseBE;
import dev.tauri.jsg.blockentity.stargate.StargatePegasusBaseBE;
import dev.tauri.jsg.blockentity.stargate.StargateTollanBaseBE;
import dev.tauri.jsg.blockentity.stargate.StargateUniverseBaseBE;
import dev.tauri.jsg.stargate.manager.dialing.StargateAbstractDialingManager;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;

public class JSGAdvancementsUtil {
    public static void tryTriggerRangedAdvancement(BlockEntity tile, EnumAdvancementType advancementType) {
        Level world = tile.m_58904_();
        if (world == null) {
            return;
        }
        BlockPos pos = tile.m_58899_();
        JSGAdvancementsUtil.tryTriggerRangedAdvancement(tile, world, pos, advancementType);
    }

    public static void tryTriggerRangedAdvancement(Stargate<?> tile, EnumAdvancementType advancementType) {
        Level world = tile.getStargateLevel();
        if (world == null) {
            return;
        }
        BlockPos pos = tile.blockPosition();
        JSGAdvancementsUtil.tryTriggerRangedAdvancement(tile, world, pos, advancementType);
    }

    public static void tryTriggerRangedAdvancement(Object tile, Level level, BlockPos pos, EnumAdvancementType advancementType) {
        int radius = 25;
        List players = level.m_45971_(ServerPlayer.class, TargetingConditions.m_148353_(), null, (AABB)new JSGAxisAlignedBB(pos.m_7918_(-radius, -radius, -radius), pos.m_7918_(radius, radius, radius)));
        for (ServerPlayer player : players) {
            switch (advancementType) {
                case GATE_OPEN: {
                    if (tile instanceof StargateOrlinBaseBE) {
                        JSGAdvancements.STATIC_ADDRESS_LOCKED.trigger(player);
                        break;
                    }
                    if (!(tile instanceof StargateClassicBaseBE)) break;
                    StargateClassicBaseBE classicTile = (StargateClassicBaseBE)tile;
                    int dialedSize = ((StargateAbstractDialingManager)classicTile.getDialingManager()).getDialedAddressSize();
                    if (dialedSize == 7) {
                        JSGAdvancements.CHEVRON_SEVEN_LOCKED.trigger(player);
                    }
                    if (dialedSize == 8) {
                        JSGAdvancements.CHEVRON_EIGHT_LOCKED.trigger(player);
                    }
                    if (dialedSize != 9) break;
                    JSGAdvancements.CHEVRON_NINE_LOCKED.trigger(player);
                    break;
                }
                case GATE_MERGE: {
                    if (!(tile instanceof StargateAbstractBaseBE)) break;
                    if (tile instanceof StargateTollanBaseBE) {
                        JSGAdvancements.MERGED_TOLLAN.trigger(player);
                        break;
                    }
                    if (tile instanceof StargateMovieBaseBE) {
                        JSGAdvancements.MERGED_MOVIE.trigger(player);
                        break;
                    }
                    if (tile instanceof StargateOrlinBaseBE) {
                        JSGAdvancements.MERGED_ORLIN.trigger(player);
                    }
                    if (tile instanceof StargateMilkyWayBaseBE) {
                        JSGAdvancements.MERGED_MILKYWAY.trigger(player);
                    }
                    if (tile instanceof StargatePegasusBaseBE) {
                        JSGAdvancements.MERGED_PEGASUS.trigger(player);
                    }
                    if (!(tile instanceof StargateUniverseBaseBE)) break;
                    JSGAdvancements.MERGED_UNIVERSE.trigger(player);
                    break;
                }
                case IRIS_IMPACT: {
                    JSGAdvancements.IRIS_IMPACT.trigger(player);
                    break;
                }
            }
        }
    }

    public static enum EnumAdvancementType {
        GATE_OPEN,
        GATE_MERGE,
        GATE_FLICKER,
        IRIS_IMPACT,
        ZPM_HUB,
        ZPM_SLOT;

    }
}

