/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.worldgen;

import dev.tauri.jsg.JSG;
import dev.tauri.jsg.registry.DimensionRegistry;
import dev.tauri.jsg.screen.provider.SGGeneratorGuiProvider;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.GenericDirtMessageScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.SelectWorldScreen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.ModMismatchEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.versioning.ArtifactVersion;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class AbydosUpdateHandler {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onVersionMismatch(ModMismatchEvent e) {
        ArtifactVersion jsgOldVersion = e.getPreviousVersion("jsg");
        if (jsgOldVersion == null) {
            return;
        }
        String[] splitVersion = jsgOldVersion.getQualifier().split("\\.");
        if (Integer.parseInt(splitVersion[0]) >= 5 && Integer.parseInt(splitVersion[1]) >= 1) {
            return;
        }
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> SGGeneratorGuiProvider.showAbydosWarning(proceed -> {
            if (proceed) {
                File abydosDimFolder = Path.of(e.getLevelDirectory().f_230850_().toString(), "/dimensions/jsg/abydos/").toFile();
                if (abydosDimFolder.exists() && abydosDimFolder.isDirectory()) {
                    Minecraft.m_91087_().m_91346_((Screen)new GenericDirtMessageScreen((Component)Component.m_237113_((String)"joinWorld.jsg.abydos_update.deleting_world")));
                    JSG.logger.warn("Deleting {}", (Object)abydosDimFolder.getAbsolutePath());
                    try {
                        FileUtils.deleteDirectory((File)abydosDimFolder);
                        JSG.logger.info("Deleted {}", (Object)abydosDimFolder.getAbsolutePath());
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                try {
                    JSG.logger.info("Rewriting {}", (Object)Path.of(e.getLevelDirectory().f_230850_().toString(), "/level.dat").toString());
                    CompoundTag levelDat = NbtIo.m_128937_((File)Path.of(e.getLevelDirectory().f_230850_().toString(), "/level.dat").toFile());
                    CompoundTag data = levelDat.m_128469_("Data");
                    CompoundTag wgs = data.m_128469_("WorldGenSettings");
                    CompoundTag dims = wgs.m_128469_("dimensions");
                    dims.m_128473_(DimensionRegistry.ABYDOS.m_135782_().toString());
                    wgs.m_128365_("dimensions", (Tag)dims);
                    data.m_128365_("WorldGenSettings", (Tag)wgs);
                    levelDat.m_128365_("Data", (Tag)data);
                    CompoundTag fml = levelDat.m_128469_("fml");
                    ListTag lml = levelDat.m_128437_("LoadingModList", 10);
                    ListTag newList = new ListTag();
                    for (Tag m : lml) {
                        String id = ((CompoundTag)m).m_128461_("ModId");
                        String version = ((CompoundTag)m).m_128461_("ModVersion");
                        CompoundTag newCompound = new CompoundTag();
                        newCompound.m_128359_("ModId", id);
                        newCompound.m_128359_("ModVersion", version);
                        if (id.equalsIgnoreCase("jsg")) {
                            newCompound.m_128359_("ModVersion", JSG.MOD_VERSION_ONLY);
                        }
                        newList.add((Object)newCompound);
                    }
                    fml.m_128365_("LoadingModList", (Tag)newList);
                    NbtIo.m_128944_((CompoundTag)levelDat, (File)Path.of(e.getLevelDirectory().f_230850_().toString(), "/level.dat").toFile());
                    JSG.logger.info("Rewrite done!");
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
                e.markResolved("jsg");
            }
            Minecraft.m_91087_().m_91346_((Screen)new SelectWorldScreen(null));
        }));
    }
}

