/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.worldgen.generator;

import com.mojang.datafixers.util.Pair;
import dev.tauri.jsg.JSG;
import dev.tauri.jsg.api.chunkloader.ChunkManager;
import dev.tauri.jsg.api.stargate.Stargate;
import dev.tauri.jsg.api.stargate.network.StargatePos;
import dev.tauri.jsg.api.stargate.network.address.StargateAddress;
import dev.tauri.jsg.api.stargate.network.address.symbol.types.AbstractSymbolType;
import dev.tauri.jsg.config.stargate.StargateDimensionConfig;
import dev.tauri.jsg.helpers.LinkingHelper;
import dev.tauri.jsg.registry.DimensionRegistry;
import dev.tauri.jsg.registry.tags.JSGBlockTags;
import dev.tauri.jsg.registry.tags.JSGStructureTags;
import dev.tauri.jsg.screen.provider.SGGeneratorGuiProvider;
import dev.tauri.jsg.stargate.network.StargateNetwork;
import dev.tauri.jsg.stargate.network.StargateReservedAddresses;
import dev.tauri.jsg.worldgen.generator.StargateGeneratorDimStatus;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class DimensionStargateGenerator {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onServerStarted(ServerStartedEvent e) {
        MinecraftServer server = e.getServer();
        long start = System.currentTimeMillis();
        JSG.logger.info("Started generating stargate in dimensions...");
        StargateNetwork network = StargateNetwork.INSTANCE;
        Set levels = server.m_129784_();
        int totalDimensions = levels.size();
        ConcurrentHashMap<String, StargateGeneratorDimStatus> stats = new ConcurrentHashMap<String, StargateGeneratorDimStatus>();
        int totalGenerated = 0;
        AtomicReference<MutableComponent> message = new AtomicReference<MutableComponent>(Component.m_237119_());
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> SGGeneratorGuiProvider.showProgress(() -> totalDimensions, () -> stats, message::get));
        for (ResourceKey dimension : levels) {
            ServerLevel level = server.m_129880_(dimension);
            if (level == null) {
                stats.put(dimension.m_135782_().toString(), StargateGeneratorDimStatus.ERROR);
                continue;
            }
            message.set(Component.m_237110_((String)"createWorld.stargates_generating.trying", (Object[])new Object[]{level.m_46472_().m_135782_()}));
            if (!level.m_215010_().m_220467_()) {
                stats.put(dimension.m_135782_().toString(), StargateGeneratorDimStatus.SKIPPED);
                continue;
            }
            if (!StargateDimensionConfig.INSTANCE.getConfigEntrySafe((ResourceKey<Level>)dimension).map(dimEntry -> dimEntry.hasStargate).orElse(false).booleanValue()) {
                stats.put(dimension.m_135782_().toString(), StargateGeneratorDimStatus.SKIPPED);
                continue;
            }
            Optional<Map.Entry<StargatePos, Map<AbstractSymbolType<?>, StargateAddress>>> sg = network.getStargateByDimension((ResourceKey<Level>)dimension);
            if (sg.isEmpty()) {
                if (DimensionStargateGenerator.findStructureAndGenerate(level, message)) {
                    ++totalGenerated;
                    stats.put(dimension.m_135782_().toString(), StargateGeneratorDimStatus.GENERATED);
                    continue;
                }
                stats.put(dimension.m_135782_().toString(), StargateGeneratorDimStatus.NO_STRUCTURE);
                continue;
            }
            stats.put(dimension.m_135782_().toString(), StargateGeneratorDimStatus.ALREADY_GENERATED);
        }
        message.set(Component.m_237115_((String)"createWorld.stargates_generating.running_sg_regen"));
        JSG.logger.info("Stargates in dimensions generated in {} ms", (Object)(System.currentTimeMillis() - start));
        JSG.logger.info("Total dimensions: {}; Total new gates generated: {}", (Object)totalDimensions, (Object)totalGenerated);
    }

    private static boolean findStructureAndGenerate(ServerLevel level, AtomicReference<Component> message) {
        if (level == null) {
            return false;
        }
        boolean result = false;
        int maxStargates = 1;
        if (level.m_46472_() == Level.f_46430_) {
            maxStargates = 4;
        }
        TagKey<Structure> tag = level.m_46472_() == Level.f_46428_ ? JSGStructureTags.HAS_MILKYWAY_STARGATE : JSGStructureTags.HAS_STARGATE;
        for (int i = 0; i < maxStargates; ++i) {
            int z;
            int x;
            Optional<HolderSet.Named> holderSet = level.m_9598_().m_6632_(tag.f_203867_()).map(r -> r.m_203561_(tag));
            if (holderSet.isEmpty()) {
                return result;
            }
            message.set((Component)Component.m_237110_((String)"createWorld.stargates_generating.searching", (Object[])new Object[]{level.m_46472_().m_135782_()}));
            Pair structureEntry = level.m_7726_().m_8481_().m_223037_(level, (HolderSet)holderSet.get(), new BlockPos(0, 0, 0), 200, true);
            if (structureEntry == null) {
                JSG.logger.warn("No structure to generate for {}", (Object)level.m_46472_().m_135782_().toString());
                return result;
            }
            message.set((Component)Component.m_237110_((String)"createWorld.stargates_generating.generating", (Object[])new Object[]{level.m_46472_().m_135782_()}));
            BlockPos origin = (BlockPos)structureEntry.getFirst();
            if (level.m_46472_() == DimensionRegistry.ABYDOS) {
                origin = new BlockPos(0, origin.m_123342_(), 0);
            }
            int chunksRadius = 2;
            for (x = -chunksRadius; x < chunksRadius; ++x) {
                for (z = -chunksRadius; z < chunksRadius; ++z) {
                    ChunkManager.forceChunk(level, new ChunkPos(origin.m_7918_(x * 16, 0, z * 16)), true);
                }
            }
            DimensionStargateGenerator.setGeneratedStargateAddress(level, origin, i == 0, (Pair<BlockPos, Holder<Structure>>)structureEntry, message);
            for (x = -chunksRadius; x < chunksRadius; ++x) {
                for (z = -chunksRadius; z < chunksRadius; ++z) {
                    ChunkManager.unforceChunk(level, new ChunkPos(origin.m_7918_(x * 16, 0, z * 16)), true);
                }
            }
            result = true;
        }
        return result;
    }

    private static void setGeneratedStargateAddress(ServerLevel level, BlockPos structureOrigin, boolean setAddress, Pair<BlockPos, Holder<Structure>> structureEntry, AtomicReference<Component> message) {
        AtomicReference<Object> box = new AtomicReference<Object>(null);
        Stargate gateBE = null;
        for (int i = 1; i <= 3; ++i) {
            message.set((Component)Component.m_237110_((String)"createWorld.stargates_generating.searching_stargate", (Object[])new Object[]{level.m_46472_().m_135782_(), String.valueOf(i)}));
            gateBE = LinkingHelper.findClosestTile((Level)level, structureOrigin, JSGBlockTags.ALL_STARGATE_BASES, Stargate.class, 80 * i, 80 * i, pos -> {
                if (box.get() == null) {
                    return true;
                }
                return ((BoundingBox)box.get()).m_71051_((Vec3i)pos);
            });
            if (gateBE != null) break;
            JSG.logger.warn("Getting stargate from structure is harder than usually... Maybe it's a big structure? (Attempt #{} failed)", (Object)i);
        }
        if (gateBE == null) {
            JSG.logger.error("No stargate found in stargate structure in dimension {}! (structure {})", (Object)level.m_46472_().m_135782_().toString(), (Object)((Holder)structureEntry.getSecond()).m_203543_().map(ResourceKey::m_135782_).orElse(new ResourceLocation("error")).toString());
            return;
        }
        message.set((Component)Component.m_237115_((String)"createWorld.stargates_generating.running_sg_regen"));
        gateBE.tryRegenerateStargateIfNeeded();
        Optional<StargateReservedAddresses.ReservedStargate> reservedStargate = StargateReservedAddresses.getStargate(level);
        if (reservedStargate.isEmpty()) {
            return;
        }
        if (reservedStargate.get().isGenerated()) {
            return;
        }
        if (setAddress) {
            reservedStargate.get().setAddresses(gateBE);
        }
    }
}

