/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.worldgen.poolinject;

import com.mojang.datafixers.util.Pair;
import dev.tauri.jsg.api.config.JSGConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class TemplatePoolInjector {
    private static final List<Builder> ADDITIONS = new ArrayList<Builder>();

    public static void inject(MinecraftServer server) {
        Registry templatePoolRegistry = (Registry)server.m_206579_().m_6632_(Registries.f_256948_).orElseThrow();
        Registry processorListRegistry = (Registry)server.m_206579_().m_6632_(Registries.f_257011_).orElseThrow();
        for (Builder addition : ADDITIONS) {
            for (ResourceLocation villagePool : addition.poolsIds) {
                StructureTemplatePool pool = (StructureTemplatePool)templatePoolRegistry.m_7745_(villagePool);
                if (pool == null) continue;
                if (addition.clearPool) {
                    pool.f_210560_.clear();
                    pool.f_210559_ = new ArrayList();
                }
                ArrayList<Pair> raw = new ArrayList<Pair>(pool.f_210559_);
                for (Addition structure : addition.additions) {
                    Holder.Reference processorHolder = processorListRegistry.m_246971_(ResourceKey.m_135785_((ResourceKey)Registries.f_257011_, (ResourceLocation)structure.processor));
                    ResourceLocation structurePath = new ResourceLocation(structure.location.replaceAll("\\{stargate_size}", JSGConfig.Stargate.stargateSize.get().structuresPath));
                    SinglePoolElement piece = (SinglePoolElement)SinglePoolElement.m_210531_((String)structurePath.toString(), (Holder)processorHolder).apply(structure.matchTerrain ? StructureTemplatePool.Projection.TERRAIN_MATCHING : StructureTemplatePool.Projection.RIGID);
                    for (int i = 0; i < structure.weight; ++i) {
                        pool.f_210560_.add((Object)piece);
                    }
                    raw.add(new Pair((Object)piece, (Object)structure.weight));
                }
                pool.f_210559_ = raw;
            }
        }
    }

    public static class Builder {
        public final List<ResourceLocation> poolsIds = new ArrayList<ResourceLocation>();
        public final List<Addition> additions = new ArrayList<Addition>();
        public boolean clearPool = false;

        public Builder addPool(ResourceLocation loc) {
            this.poolsIds.add(loc);
            return this;
        }

        public Builder addAddition(String loc, int weight) {
            return this.addAddition(loc, weight, false);
        }

        public Builder addAddition(String loc, int weight, ResourceLocation processor) {
            return this.addAddition(loc, weight, false, processor);
        }

        public Builder addAddition(String loc, int weight, boolean matchTerrain) {
            return this.addAddition(loc, weight, matchTerrain, new ResourceLocation("minecraft", "empty"));
        }

        public Builder addAddition(String loc, int weight, boolean matchTerrain, ResourceLocation processor) {
            this.additions.add(new Addition(loc, weight, matchTerrain, processor));
            return this;
        }

        public Builder setClearPool() {
            this.clearPool = true;
            return this;
        }

        public void submit() {
            ADDITIONS.add(this);
        }
    }

    public record Addition(String location, int weight, boolean matchTerrain, ResourceLocation processor) {
    }
}

