/*
 * Decompiled with CFR 0.152.
 */
package io.urokhtor.minecraft.containertooltips;

import io.urokhtor.minecraft.containertooltips.Container;
import io.urokhtor.minecraft.containertooltips.CurrentContainerContext;
import io.urokhtor.minecraft.containertooltips.InventoryResponsePayload;
import io.urokhtor.minecraft.containertooltips.ScreenEventsKt;
import io.urokhtor.minecraft.containertooltips.configuration.Configuration;
import io.urokhtor.minecraft.containertooltips.rendering.ContainerTooltip;
import io.urokhtor.minecraft.containertooltips.rendering.EmptyContainerTooltip;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElementRegistry;
import net.minecraft.class_1041;
import net.minecraft.class_1269;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_9779;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u000f\u0010\u0006\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0003J\u000f\u0010\u0007\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\u0003J\u000f\u0010\b\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\b\u0010\u0003J\u000f\u0010\t\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\t\u0010\u0003J\u000f\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0015\u001a\u00020\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0018\u001a\u00020\u00178\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001c\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\u00020\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"Lio/urokhtor/minecraft/containertooltips/ContainerTooltipsClient;", "Lnet/fabricmc/api/ClientModInitializer;", "<init>", "()V", "", "onInitializeClient", "registerConfigurationIntegration", "registerMessageListeners", "registerEventListeners", "registerRenderingHook", "", "tooltipIsDisabled", "()Z", "", "keyCode", "keyIsNotPressed", "(I)Z", "Lio/urokhtor/minecraft/containertooltips/rendering/ContainerTooltip;", "containerTooltip", "Lio/urokhtor/minecraft/containertooltips/rendering/ContainerTooltip;", "Lio/urokhtor/minecraft/containertooltips/rendering/EmptyContainerTooltip;", "emptyContainerTooltip", "Lio/urokhtor/minecraft/containertooltips/rendering/EmptyContainerTooltip;", "Lio/urokhtor/minecraft/containertooltips/configuration/Configuration;", "configuration", "Lio/urokhtor/minecraft/containertooltips/configuration/Configuration;", "Lnet/minecraft/class_2960;", "kotlin.jvm.PlatformType", "tooltipIdentifier", "Lnet/minecraft/class_2960;", "screenOpen", "Z", "container-tooltips_client"})
@Environment(value=EnvType.CLIENT)
public final class ContainerTooltipsClient
implements ClientModInitializer {
    @NotNull
    public static final ContainerTooltipsClient INSTANCE = new ContainerTooltipsClient();
    @NotNull
    private static final ContainerTooltip containerTooltip = new ContainerTooltip();
    @NotNull
    private static final EmptyContainerTooltip emptyContainerTooltip = new EmptyContainerTooltip();
    private static Configuration configuration;
    private static final class_2960 tooltipIdentifier;
    private static boolean screenOpen;

    private ContainerTooltipsClient() {
    }

    public void onInitializeClient() {
        this.registerConfigurationIntegration();
        this.registerMessageListeners();
        this.registerEventListeners();
        this.registerRenderingHook();
    }

    private final void registerConfigurationIntegration() {
        AutoConfig.register(Configuration.class, JanksonConfigSerializer::new);
        ConfigHolder configHolder = AutoConfig.getConfigHolder(Configuration.class);
        ConfigData configData = configHolder.getConfig();
        Intrinsics.checkNotNullExpressionValue((Object)configData, (String)"getConfig(...)");
        configuration = (Configuration)configData;
        configHolder.registerSaveListener(ContainerTooltipsClient::registerConfigurationIntegration$lambda$0);
    }

    private final void registerMessageListeners() {
        ClientPlayNetworking.registerGlobalReceiver(InventoryResponsePayload.Companion.getID(), ContainerTooltipsClient::registerMessageListeners$lambda$0);
    }

    private final void registerEventListeners() {
        ScreenEventsKt.getSCREEN_OPENED().register(ContainerTooltipsClient::registerEventListeners$lambda$0);
        ScreenEventsKt.getSCREEN_CLOSED().register(ContainerTooltipsClient::registerEventListeners$lambda$1);
    }

    private final void registerRenderingHook() {
        HudElementRegistry.addLast((class_2960)tooltipIdentifier, ContainerTooltipsClient::registerRenderingHook$lambda$0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean tooltipIsDisabled() {
        Configuration configuration = ContainerTooltipsClient.configuration;
        if (configuration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configuration");
            configuration = null;
        }
        if (configuration.showAutomatically) return false;
        Configuration configuration2 = ContainerTooltipsClient.configuration;
        if (configuration2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configuration");
            configuration2 = null;
        }
        if (!this.keyIsNotPressed(configuration2.showWithKeyCode)) return false;
        return true;
    }

    private final boolean keyIsNotPressed(int keyCode) {
        return !class_3675.method_15987((class_1041)class_310.method_1551().method_22683(), (int)keyCode);
    }

    private static final class_1269 registerConfigurationIntegration$lambda$0(ConfigHolder configHolder, Configuration config) {
        Intrinsics.checkNotNull((Object)config);
        configuration = config;
        return (class_1269)class_1269.field_5811;
    }

    private static final void registerMessageListeners$lambda$0(InventoryResponsePayload payload, ClientPlayNetworking.Context context) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)context, (String)"<unused var>");
        ContainerTooltipsClient $this$registerMessageListeners_u24lambda_u240_u240 = INSTANCE;
        boolean bl = false;
        InventoryResponsePayload it = payload;
        boolean bl2 = false;
        CurrentContainerContext.INSTANCE.set(new Container(it.getName(), it.getItems()));
    }

    private static final void registerEventListeners$lambda$0(class_310 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        screenOpen = true;
    }

    private static final void registerEventListeners$lambda$1(class_310 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        screenOpen = false;
    }

    private static final void registerRenderingHook$lambda$0(class_332 guiGraphics, class_9779 class_97792) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
            Intrinsics.checkNotNullParameter((Object)class_97792, (String)"<unused var>");
            Container container = CurrentContainerContext.INSTANCE.get();
            if (container == null) break block3;
            Container container2 = container;
            boolean bl = false;
            if (!INSTANCE.tooltipIsDisabled() && !screenOpen) {
                class_310 client = class_310.method_1551();
                if (container2.isEmpty()) {
                    class_327 class_3272 = client.field_1772;
                    Intrinsics.checkNotNullExpressionValue((Object)class_3272, (String)"textRenderer");
                    emptyContainerTooltip.render(class_3272, client.method_22683().method_4486() / 2, guiGraphics, container2);
                } else {
                    class_327 class_3273 = client.field_1772;
                    Intrinsics.checkNotNullExpressionValue((Object)class_3273, (String)"textRenderer");
                    containerTooltip.render(class_3273, client.method_22683().method_4486() / 2, guiGraphics, container2);
                }
            }
        }
    }

    static {
        tooltipIdentifier = class_2960.method_60655((String)"container-tooltips", (String)"tooltip");
    }
}

