/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.cavesandcreatures.block;

import net.mcreator.cavesandcreatures.init.CavesAndCreaturesModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SprinklesBlock
extends FlowerBlock {
    public SprinklesBlock(BlockBehaviour.Properties properties) {
        super(MobEffects.GLOWING, 100.0f, properties.mapColor(MapColor.COLOR_MAGENTA).sound(SoundType.GRASS).instabreak().noOcclusion().dynamicShape().offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Vec3 offset = state.getOffset(pos);
        return Shapes.or((VoxelShape)SprinklesBlock.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)1.0, (double)9.0), (VoxelShape[])new VoxelShape[]{SprinklesBlock.box((double)11.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)5.0), SprinklesBlock.box((double)1.0, (double)0.0, (double)6.0, (double)3.0, (double)1.0, (double)8.0), SprinklesBlock.box((double)8.0, (double)0.0, (double)13.0, (double)10.0, (double)1.0, (double)15.0), SprinklesBlock.box((double)12.0, (double)0.0, (double)10.0, (double)14.0, (double)1.0, (double)12.0), SprinklesBlock.box((double)3.0, (double)0.0, (double)11.0, (double)5.0, (double)1.0, (double)13.0), SprinklesBlock.box((double)2.0, (double)0.0, (double)1.0, (double)4.0, (double)1.0, (double)3.0)}).move(offset.x, offset.y, offset.z);
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 100;
    }

    public PathType getBlockPathType(BlockState state, BlockGetter world, BlockPos pos, Mob entity) {
        return PathType.OPEN;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 60;
    }

    public boolean mayPlaceOn(BlockState groundState, BlockGetter worldIn, BlockPos pos) {
        return groundState.is((Block)CavesAndCreaturesModBlocks.SUGAR_SAND.get());
    }

    public boolean canSurvive(BlockState blockstate, LevelReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.below();
        BlockState groundState = worldIn.getBlockState(blockpos);
        return this.mayPlaceOn(groundState, (BlockGetter)worldIn, blockpos);
    }
}

