/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.cavesandcreatures.client.renderer;

import net.mcreator.cavesandcreatures.client.model.ModelAnimalCrackerElephant;
import net.mcreator.cavesandcreatures.client.model.animations.AnimalCrackerElephantAnimation;
import net.mcreator.cavesandcreatures.entity.ElephantAnimalCrackerEntity;
import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class ElephantAnimalCrackerRenderer
extends MobRenderer<ElephantAnimalCrackerEntity, LivingEntityRenderState, ModelAnimalCrackerElephant> {
    private ElephantAnimalCrackerEntity entity = null;

    public ElephantAnimalCrackerRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelAnimalCrackerElephant.LAYER_LOCATION)), 0.5f);
    }

    public LivingEntityRenderState createRenderState() {
        return new LivingEntityRenderState();
    }

    public void extractRenderState(ElephantAnimalCrackerEntity entity, LivingEntityRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, state, partialTicks);
        this.entity = entity;
        if (this.model instanceof AnimatedModel) {
            ((AnimatedModel)this.model).setEntity(entity);
        }
    }

    public ResourceLocation getTextureLocation(LivingEntityRenderState state) {
        return ResourceLocation.parse((String)"caves_and_creatures:textures/entities/animal_cracker_elephant_java.png");
    }

    private static final class AnimatedModel
    extends ModelAnimalCrackerElephant {
        private ElephantAnimalCrackerEntity entity = null;
        private final KeyframeAnimation keyframeAnimation0;
        private final KeyframeAnimation keyframeAnimation1;
        private final KeyframeAnimation keyframeAnimation2;

        public AnimatedModel(ModelPart root) {
            super(root);
            this.keyframeAnimation0 = AnimalCrackerElephantAnimation.idle.bake(root);
            this.keyframeAnimation1 = AnimalCrackerElephantAnimation.walk.bake(root);
            this.keyframeAnimation2 = AnimalCrackerElephantAnimation.idle.bake(root);
        }

        public void setEntity(ElephantAnimalCrackerEntity entity) {
            this.entity = entity;
        }

        @Override
        public void setupAnim(LivingEntityRenderState state) {
            this.root().getAllParts().forEach(ModelPart::resetPose);
            this.keyframeAnimation0.apply(this.entity.animationState0, state.ageInTicks, 1.0f);
            this.keyframeAnimation1.apply(this.entity.animationState1, state.ageInTicks, 1.0f);
            this.keyframeAnimation2.apply(this.entity.animationState2, state.ageInTicks, 1.0f);
            super.setupAnim(state);
        }
    }
}

