/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.cavesandcreatures.client.renderer;

import net.mcreator.cavesandcreatures.client.model.ModelHarleyQuinnSalotl;
import net.mcreator.cavesandcreatures.client.model.animations.HarleyQuinnSalotlAnimation;
import net.mcreator.cavesandcreatures.entity.HarleyQuinnSalotlEntity;
import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class HarleyQuinnSalotlRenderer
extends MobRenderer<HarleyQuinnSalotlEntity, LivingEntityRenderState, ModelHarleyQuinnSalotl> {
    private HarleyQuinnSalotlEntity entity = null;

    public HarleyQuinnSalotlRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelHarleyQuinnSalotl.LAYER_LOCATION)), 0.3f);
    }

    public LivingEntityRenderState createRenderState() {
        return new LivingEntityRenderState();
    }

    public void extractRenderState(HarleyQuinnSalotlEntity entity, LivingEntityRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, state, partialTicks);
        this.entity = entity;
        if (this.model instanceof AnimatedModel) {
            ((AnimatedModel)this.model).setEntity(entity);
        }
    }

    public ResourceLocation getTextureLocation(LivingEntityRenderState state) {
        if (this.entity != null) {
            return ResourceLocation.parse((String)("caves_and_creatures:textures/entities/" + this.entity.getTexture() + ".png"));
        }
        return ResourceLocation.parse((String)"caves_and_creatures:textures/entities/harleyquinnsalotl_java.png");
    }

    private static final class AnimatedModel
    extends ModelHarleyQuinnSalotl {
        private HarleyQuinnSalotlEntity entity = null;
        private final KeyframeAnimation keyframeAnimation0;
        private final KeyframeAnimation keyframeAnimation1;
        private final KeyframeAnimation keyframeAnimation2;
        private final KeyframeAnimation keyframeAnimation3;
        private final KeyframeAnimation keyframeAnimation4;

        public AnimatedModel(ModelPart root) {
            super(root);
            this.keyframeAnimation0 = HarleyQuinnSalotlAnimation.idle.bake(root);
            this.keyframeAnimation1 = HarleyQuinnSalotlAnimation.swim.bake(root);
            this.keyframeAnimation2 = HarleyQuinnSalotlAnimation.walk.bake(root);
            this.keyframeAnimation3 = HarleyQuinnSalotlAnimation.swim.bake(root);
            this.keyframeAnimation4 = HarleyQuinnSalotlAnimation.idle.bake(root);
        }

        public void setEntity(HarleyQuinnSalotlEntity entity) {
            this.entity = entity;
        }

        @Override
        public void setupAnim(LivingEntityRenderState state) {
            this.root().getAllParts().forEach(ModelPart::resetPose);
            this.keyframeAnimation0.apply(this.entity.animationState0, state.ageInTicks, 1.0f);
            this.keyframeAnimation1.apply(this.entity.animationState1, state.ageInTicks, 1.0f);
            this.keyframeAnimation2.apply(this.entity.animationState2, state.ageInTicks, 0.8f);
            this.keyframeAnimation3.apply(this.entity.animationState3, state.ageInTicks, 1.0f);
            this.keyframeAnimation4.apply(this.entity.animationState4, state.ageInTicks, 1.0f);
            super.setupAnim(state);
        }
    }
}

