/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.cavesandcreatures.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mcreator.cavesandcreatures.client.model.Modelspidersnake;
import net.mcreator.cavesandcreatures.client.model.animations.spidersnakeAnimation;
import net.mcreator.cavesandcreatures.entity.SpiderSnakeBlackEntity;
import net.mcreator.cavesandcreatures.procedures.WalkAnimationConditionProcedure;
import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class SpiderSnakeBlackRenderer
extends MobRenderer<SpiderSnakeBlackEntity, LivingEntityRenderState, Modelspidersnake> {
    private SpiderSnakeBlackEntity entity = null;

    public SpiderSnakeBlackRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelspidersnake.LAYER_LOCATION)), 0.5f);
        this.addLayer((RenderLayer)new RenderLayer<LivingEntityRenderState, Modelspidersnake>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"caves_and_creatures:textures/entities/spidersnakeblackglow.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, LivingEntityRenderState state, float headYaw, float headPitch) {
                VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                ((Modelspidersnake)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)state, (float)0.0f));
            }
        });
    }

    public LivingEntityRenderState createRenderState() {
        return new LivingEntityRenderState();
    }

    public void extractRenderState(SpiderSnakeBlackEntity entity, LivingEntityRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, state, partialTicks);
        this.entity = entity;
        if (this.model instanceof AnimatedModel) {
            ((AnimatedModel)this.model).setEntity(entity);
        }
    }

    public ResourceLocation getTextureLocation(LivingEntityRenderState state) {
        return ResourceLocation.parse((String)"caves_and_creatures:textures/entities/spidersnakeblack.png");
    }

    private static final class AnimatedModel
    extends Modelspidersnake {
        private SpiderSnakeBlackEntity entity = null;
        private final KeyframeAnimation keyframeAnimation0;
        private final KeyframeAnimation keyframeAnimation1;
        private final KeyframeAnimation keyframeAnimation2;
        private final KeyframeAnimation keyframeAnimation3;

        public AnimatedModel(ModelPart root) {
            super(root);
            this.keyframeAnimation0 = spidersnakeAnimation.idle.bake(root);
            this.keyframeAnimation1 = spidersnakeAnimation.walk.bake(root);
            this.keyframeAnimation2 = spidersnakeAnimation.swim.bake(root);
            this.keyframeAnimation3 = spidersnakeAnimation.idle.bake(root);
        }

        public void setEntity(SpiderSnakeBlackEntity entity) {
            this.entity = entity;
        }

        @Override
        public void setupAnim(LivingEntityRenderState state) {
            this.root().getAllParts().forEach(ModelPart::resetPose);
            this.keyframeAnimation0.apply(this.entity.animationState0, state.ageInTicks, 1.0f);
            if (WalkAnimationConditionProcedure.execute((Entity)this.entity)) {
                this.keyframeAnimation1.applyWalk(state.walkAnimationPos, state.walkAnimationSpeed, 1.0f, 1.0f);
            }
            this.keyframeAnimation2.apply(this.entity.animationState2, state.ageInTicks, 1.0f);
            this.keyframeAnimation3.apply(this.entity.animationState3, state.ageInTicks, 1.0f);
            super.setupAnim(state);
        }
    }
}

