/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.cavesandcreatures.client.renderer;

import net.mcreator.cavesandcreatures.client.model.ModelSwissRollSnail;
import net.mcreator.cavesandcreatures.client.model.animations.SwissRollSnailAnimation;
import net.mcreator.cavesandcreatures.entity.SwissRollSnailEntity;
import net.mcreator.cavesandcreatures.procedures.WalkAnimationConditionProcedure;
import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class SwissRollSnailRenderer
extends MobRenderer<SwissRollSnailEntity, LivingEntityRenderState, ModelSwissRollSnail> {
    private SwissRollSnailEntity entity = null;

    public SwissRollSnailRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelSwissRollSnail.LAYER_LOCATION)), 0.5f);
    }

    public LivingEntityRenderState createRenderState() {
        return new LivingEntityRenderState();
    }

    public void extractRenderState(SwissRollSnailEntity entity, LivingEntityRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, state, partialTicks);
        this.entity = entity;
        if (this.model instanceof AnimatedModel) {
            ((AnimatedModel)this.model).setEntity(entity);
        }
    }

    public ResourceLocation getTextureLocation(LivingEntityRenderState state) {
        return ResourceLocation.parse((String)"caves_and_creatures:textures/entities/snailswissroll_java.png");
    }

    private static final class AnimatedModel
    extends ModelSwissRollSnail {
        private SwissRollSnailEntity entity = null;
        private final KeyframeAnimation keyframeAnimation0;
        private final KeyframeAnimation keyframeAnimation1;
        private final KeyframeAnimation keyframeAnimation2;

        public AnimatedModel(ModelPart root) {
            super(root);
            this.keyframeAnimation0 = SwissRollSnailAnimation.walk.bake(root);
            this.keyframeAnimation1 = SwissRollSnailAnimation.idle.bake(root);
            this.keyframeAnimation2 = SwissRollSnailAnimation.idle.bake(root);
        }

        public void setEntity(SwissRollSnailEntity entity) {
            this.entity = entity;
        }

        @Override
        public void setupAnim(LivingEntityRenderState state) {
            this.root().getAllParts().forEach(ModelPart::resetPose);
            if (WalkAnimationConditionProcedure.execute((Entity)this.entity)) {
                this.keyframeAnimation0.applyWalk(state.walkAnimationPos, state.walkAnimationSpeed, 1.0f, 1.0f);
            }
            this.keyframeAnimation1.apply(this.entity.animationState1, state.ageInTicks, 1.0f);
            this.keyframeAnimation2.apply(this.entity.animationState2, state.ageInTicks, 1.0f);
            super.setupAnim(state);
        }
    }
}

