/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.cavesandcreatures.entity;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.mcreator.cavesandcreatures.init.CavesAndCreaturesModEntities;
import net.mcreator.cavesandcreatures.init.CavesAndCreaturesModItems;
import net.mcreator.cavesandcreatures.procedures.AncientSpawnCodeProcedure;
import net.mcreator.cavesandcreatures.procedures.AxospawnProcedure;
import net.mcreator.cavesandcreatures.procedures.BoneSalSettingsProcedure;
import net.mcreator.cavesandcreatures.procedures.IdleAnimationConditionProcedure;
import net.mcreator.cavesandcreatures.procedures.IfSalotlIsOnLandProcedure;
import net.mcreator.cavesandcreatures.procedures.SalInWaterProcedure;
import net.mcreator.cavesandcreatures.procedures.SalotlStayAnimsProcedure;
import net.mcreator.cavesandcreatures.procedures.SalotlsOnTickProcedure;
import net.mcreator.cavesandcreatures.procedures.SwimmingAnimationConditionProcedure;
import net.mcreator.cavesandcreatures.procedures.SwimmingIdleAnimationConditionProcedure;
import net.mcreator.cavesandcreatures.procedures.WalkAnimationConditionProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.fluids.FluidType;

public class SkeleSalotlEntity
extends PathfinderMob {
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.defineId(SkeleSalotlEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Integer> ANIM = SynchedEntityData.defineId(SkeleSalotlEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final AnimationState animationState0 = new AnimationState();
    public final AnimationState animationState1 = new AnimationState();
    public final AnimationState animationState2 = new AnimationState();
    public final AnimationState animationState3 = new AnimationState();
    public final AnimationState animationState4 = new AnimationState();

    public SkeleSalotlEntity(EntityType<SkeleSalotlEntity> type, Level world) {
        super(type, world);
        this.xpReward = 3;
        this.setNoAi(false);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.1f, 0.5f, false);
        this.lookControl = new SmoothSwimmingLookControl((Mob)this, 20);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> data) {
        if (ANIM.equals(data)) {
            switch ((Integer)this.entityData.get(ANIM)) {
                case -1: {
                    this.animationState0.stop();
                    break;
                }
                case -2: {
                    this.animationState1.stop();
                    break;
                }
                case -3: {
                    this.animationState2.stop();
                    break;
                }
                case -4: {
                    this.animationState3.stop();
                    break;
                }
                case -5: {
                    this.animationState4.stop();
                    break;
                }
                case 0: {
                    this.animationState0.start(this.tickCount);
                    break;
                }
                case 1: {
                    this.animationState1.start(this.tickCount);
                    break;
                }
                case 2: {
                    this.animationState2.start(this.tickCount);
                    break;
                }
                case 3: {
                    this.animationState3.start(this.tickCount);
                    break;
                }
                case 4: {
                    this.animationState4.start(this.tickCount);
                }
            }
        }
        super.onSyncedDataUpdated(data);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TEXTURE, (Object)"skele_salotl_texture_java2");
        builder.define(ANIM, (Object)0);
    }

    public void setTexture(String texture) {
        this.entityData.set(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.entityData.get(TEXTURE);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new RandomSwimmingGoal(this, 0.51, 40){

            public boolean canUse() {
                double x = SkeleSalotlEntity.this.getX();
                double y = SkeleSalotlEntity.this.getY();
                double z = SkeleSalotlEntity.this.getZ();
                SkeleSalotlEntity entity = SkeleSalotlEntity.this;
                Level world = SkeleSalotlEntity.this.level();
                return super.canUse() && SalInWaterProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = SkeleSalotlEntity.this.getX();
                double y = SkeleSalotlEntity.this.getY();
                double z = SkeleSalotlEntity.this.getZ();
                SkeleSalotlEntity entity = SkeleSalotlEntity.this;
                Level world = SkeleSalotlEntity.this.level();
                return super.canContinueToUse() && SalInWaterProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(2, (Goal)new RandomSwimmingGoal(this, 1.0, 40){

            public boolean canUse() {
                double x = SkeleSalotlEntity.this.getX();
                double y = SkeleSalotlEntity.this.getY();
                double z = SkeleSalotlEntity.this.getZ();
                SkeleSalotlEntity entity = SkeleSalotlEntity.this;
                Level world = SkeleSalotlEntity.this.level();
                return super.canUse() && IfSalotlIsOnLandProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = SkeleSalotlEntity.this.getX();
                double y = SkeleSalotlEntity.this.getY();
                double z = SkeleSalotlEntity.this.getZ();
                SkeleSalotlEntity entity = SkeleSalotlEntity.this;
                Level world = SkeleSalotlEntity.this.level();
                return super.canContinueToUse() && IfSalotlIsOnLandProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, TropicalFish.class, true, true));
        this.goalSelector.addGoal(6, (Goal)new MeleeAttackGoal(this, this, 0.3, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }
        });
        this.goalSelector.addGoal(7, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of((ItemLike)((ItemLike)CavesAndCreaturesModItems.SALOTL_TREAT_BONEY.get())), false));
    }

    protected PathNavigation createNavigation(Level level) {
        return new AmphibiousPathNavigation((Mob)this, level);
    }

    public void travel(Vec3 vec) {
        if (this.isInWater()) {
            this.moveRelative(this.getSpeed(), vec);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
        } else {
            super.travel(vec);
        }
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.generic.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.generic.death"));
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, EntitySpawnReason reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        AxospawnProcedure.execute((Entity)this);
        return retval;
    }

    public void addAdditionalSaveData(ValueOutput valueOutput) {
        super.addAdditionalSaveData(valueOutput);
        valueOutput.putString("Texture", this.getTexture());
    }

    public void readAdditionalSaveData(ValueInput valueInput) {
        super.readAdditionalSaveData(valueInput);
        this.setTexture(valueInput.getStringOr("Texture", "skele_salotl_texture_java2"));
    }

    public InteractionResult mobInteract(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.getItemInHand(hand);
        InteractionResult.Success retval = InteractionResult.SUCCESS;
        super.mobInteract(sourceentity, hand);
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        SkeleSalotlEntity entity = this;
        Level world = this.level();
        BoneSalSettingsProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, (Entity)sourceentity);
        return retval;
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(IdleAnimationConditionProcedure.execute((Entity)this), this.tickCount);
            this.animationState1.animateWhen(SwimmingAnimationConditionProcedure.execute((Entity)this), this.tickCount);
            this.animationState2.animateWhen(WalkAnimationConditionProcedure.execute((Entity)this), this.tickCount);
            this.animationState3.animateWhen(SwimmingIdleAnimationConditionProcedure.execute((Entity)this), this.tickCount);
            this.animationState4.animateWhen(SalotlStayAnimsProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        SalotlsOnTickProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public boolean canDrownInFluidType(FluidType type) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        SkeleSalotlEntity entity = this;
        return false;
    }

    public boolean isPushedByFluid() {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        SkeleSalotlEntity entity = this;
        return false;
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)CavesAndCreaturesModEntities.SKELE_SALOTL.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> {
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            return AncientSpawnCodeProcedure.execute((LevelAccessor)world, x, y, z);
        }, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.4);
        builder = builder.add(Attributes.MAX_HEALTH, 30.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 3.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 1.5);
        builder = builder.add(Attributes.TEMPT_RANGE, 10.0);
        return builder;
    }
}

