/*
 * Decompiled with CFR 0.152.
 */
package com.example.FireFromExplosionMod;

import com.example.FireFromExplosionMod.ModConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

@Mod(value="fire_explosions")
@Mod.EventBusSubscriber
public class FireFromExplosionMod {
    public FireFromExplosionMod() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ModConfig.SPEC, "fire_explosions-common.toml");
    }

    @SubscribeEvent
    public static void onExplosionDetonate(ExplosionEvent.Detonate event) {
        Level level = event.getLevel();
        if (level.m_5776_()) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        RandomSource random = serverLevel.m_213780_();
        double explosionFireChance = (Double)ModConfig.EXPLOSION_FIRE_CHANCE.get();
        double fireChanceOnEachBlock = (Double)ModConfig.FIRE_CHANCE_ON_EACH_BLOCK.get();
        if (random.m_188500_() > explosionFireChance) {
            return;
        }
        BlockPos center = BlockPos.m_274446_((Position)event.getExplosion().getPosition());
        int finalRadius = Math.max(1, (int)Math.pow(event.getExplosion().m_46081_().size(), 0.3333333333333333) - 1);
        int runTick = serverLevel.m_7654_().m_129921_() + 2;
        serverLevel.m_7654_().m_6937_((Runnable)new TickTask(runTick, () -> {
            for (int x = -finalRadius; x <= finalRadius; ++x) {
                for (int y = -3; y <= 3; ++y) {
                    for (int z = -finalRadius; z <= finalRadius; ++z) {
                        BlockPos below;
                        BlockPos pos = center.m_7918_(x, y, z);
                        if (!level.m_46859_(pos) || !level.m_8055_(below = pos.m_7495_()).m_60804_((BlockGetter)level, below) || random.m_188500_() > fireChanceOnEachBlock) continue;
                        level.m_7731_(pos, Blocks.f_50083_.m_49966_(), 3);
                    }
                }
            }
        }));
    }
}

