/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.insidethesystem.procedures;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.mcreator.insidethesystem.InsideTheSystemMod;
import net.mcreator.insidethesystem.entity.FatherEntity;
import net.mcreator.insidethesystem.init.InsideTheSystemModEntities;
import net.mcreator.insidethesystem.network.InsideTheSystemModVariables;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class BehindYouProcedure {
    private static long teleportTimer = 0L;
    private static boolean isPlayerLookingAtFather = false;
    private static long approachTimer = 0L;
    private static final int APPROACH_INTERVAL = 40;
    private static Map<UUID, Integer> kickCountdowns = new HashMap<UUID, Integer>();
    private static Map<UUID, Boolean> entityRemoved = new HashMap<UUID, Boolean>();
    private static Map<UUID, Boolean> teleportationDisabled = new HashMap<UUID, Boolean>();
    private static Map<UUID, Boolean> kickSequenceStarted = new HashMap<UUID, Boolean>();
    private static Map<UUID, Integer> scaryMessageCounter = new HashMap<UUID, Integer>();

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            BehindYouProcedure.execute((Event)event, (LevelAccessor)event.player.m_9236_(), event.player.m_20185_(), event.player.m_20186_(), event.player.m_20189_(), (Entity)event.player);
        }
    }

    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
        BehindYouProcedure.execute(null, world, x, y, z, entity);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, double x, double y, double z, Entity entity) {
        if (entity == null || !(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        UUID playerId = player.m_20148_();
        Integer countdown = kickCountdowns.get(playerId);
        if (countdown != null && countdown >= 0) {
            Integer n = countdown;
            countdown = countdown - 1;
            kickCountdowns.put(playerId, countdown);
            if (countdown > 0 && countdown % 5 == 0) {
                BehindYouProcedure.sendScaryMessage(world, player);
            }
            if (countdown <= 0) {
                BehindYouProcedure.kickPlayerGuaranteed(player);
                BehindYouProcedure.cleanupPlayerData(playerId);
                return;
            }
        }
        BehindYouProcedure.handleFatherBehavior(world, player);
        if (InsideTheSystemModVariables.MapVariables.get((LevelAccessor)world).Task1) {
            Level _level;
            LivingEntity _entity;
            if (entity instanceof LivingEntity && !(_entity = (LivingEntity)entity).m_9236_().m_5776_()) {
                _entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 200, 5, false, false));
                _entity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 200, 5, false, false));
            }
            player.m_5661_((Component)Component.m_237113_((String)"\u00a74\u00a7lHe's already behind you"), true);
            boolean fatherExists = false;
            if (world instanceof Level) {
                _level = (Level)world;
                AABB searchArea = new AABB(player.m_20185_() - 50.0, player.m_20186_() - 50.0, player.m_20189_() - 50.0, player.m_20185_() + 50.0, player.m_20186_() + 50.0, player.m_20189_() + 50.0);
                List existingFathers = _level.m_45976_(FatherEntity.class, searchArea);
                boolean bl = fatherExists = !existingFathers.isEmpty();
            }
            if (!fatherExists && world instanceof ServerLevel) {
                _level = (ServerLevel)world;
                Vec3 lookVector = player.m_20154_();
                Vec3 behindVector = lookVector.m_82490_(-30.0);
                double spawnX = x + behindVector.f_82479_;
                double spawnY = y;
                double spawnZ = z + behindVector.f_82481_;
                BehindYouProcedure.createTunnel((ServerLevel)_level, new BlockPos((int)x, (int)y, (int)z), new BlockPos((int)spawnX, (int)spawnY, (int)spawnZ));
                BlockPos spawnPos = new BlockPos((int)spawnX, (int)spawnY, (int)spawnZ);
                while (!_level.m_8055_(spawnPos).m_60795_() && spawnPos.m_123342_() < _level.m_151558_()) {
                    spawnPos = spawnPos.m_7494_();
                    spawnY += 1.0;
                }
                FatherEntity entityToSpawn = new FatherEntity((EntityType<FatherEntity>)((EntityType)InsideTheSystemModEntities.FATHER.get()), _level);
                entityToSpawn.m_7678_(spawnX, spawnY, spawnZ, 0.0f, 0.0f);
                if (entityToSpawn instanceof Mob) {
                    Mob _mobToSpawn = (Mob)entityToSpawn;
                    _mobToSpawn.m_6518_((ServerLevelAccessor)_level, world.m_6436_(entityToSpawn.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                }
                world.m_7967_((Entity)entityToSpawn);
            }
            InsideTheSystemModVariables.MapVariables.get((LevelAccessor)world).Task1 = false;
            InsideTheSystemModVariables.MapVariables.get(world).syncData(world);
        }
    }

    private static void sendScaryMessage(LevelAccessor world, Player player) {
        Integer messageCount;
        if (world.m_5776_() || world.m_7654_() == null) {
            return;
        }
        UUID playerId = player.m_20148_();
        Integer n = messageCount = scaryMessageCounter.getOrDefault(playerId, 0);
        messageCount = messageCount + 1;
        scaryMessageCounter.put(playerId, messageCount);
        String[] scaryMessages = new String[]{"\u00a74\u00a7lHAHAHAHAHA", "\u00a7c\u00a7lYou looked behind you...", "\u00a74\u00a7k\u00a7lHE KNOWS\u00a7r \u00a74\u00a7lHAHAHAHA", "\u00a7c\u00a7lThere's no escape now...", "\u00a74\u00a7lHA\u00a7c\u00a7lHA\u00a74\u00a7lHA\u00a7c\u00a7lHA\u00a74\u00a7lHA", "\u00a7c\u00a7lYou should have never turned around...", "\u00a74\u00a7k\u00a7l\u2588\u2588\u2588\u00a7r \u00a74\u00a7lHe's coming\u00a7r \u00a74\u00a7k\u00a7l\u2588\u2588\u2588", "\u00a7c\u00a7lThe darkness consumes all...", "\u00a74\u00a7lHAHAHAHAHAHAHA", "\u00a74\u00a7k\u00a7lRUN\u00a7r \u00a7c\u00a7lBUT YOU CAN'T HIDE", "\u00a74\u00a7lHE SEES EVERYTHING", "\u00a7c\u00a7lYOUR FATE IS SEALED"};
        String message = scaryMessages[messageCount % scaryMessages.length];
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.m_213846_((Component)Component.m_237113_((String)message));
        }
    }

    private static void removeAllFatherEntities(LevelAccessor world, Player player) {
        if (!(world instanceof Level)) {
            return;
        }
        Level _level = (Level)world;
        AABB searchArea = new AABB(player.m_20185_() - 100.0, player.m_20186_() - 100.0, player.m_20189_() - 100.0, player.m_20185_() + 100.0, player.m_20186_() + 100.0, player.m_20189_() + 100.0);
        List fatherEntities = _level.m_45976_(FatherEntity.class, searchArea);
        for (FatherEntity father : fatherEntities) {
            father.m_146870_();
        }
    }

    private static void cleanupPlayerData(UUID playerId) {
        kickCountdowns.remove(playerId);
        entityRemoved.remove(playerId);
        kickSequenceStarted.remove(playerId);
        scaryMessageCounter.remove(playerId);
    }

    private static void kickPlayerGuaranteed(Player player) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        MinecraftServer server = serverPlayer.m_20194_();
        if (server == null) {
            return;
        }
        MutableComponent kickMessage = Component.m_237113_((String)"An unknown entity has been detected in your world\nPlease report it to https://help.minecraft.net/hc/en-us\n\u00a78\u00a7oError Code: ENTITY_UNKNOWN_0x4F");
        try {
            serverPlayer.f_8906_.m_9942_((Component)kickMessage);
            InsideTheSystemMod.LOGGER.info("Successfully kicked player " + serverPlayer.m_7755_().getString() + " after Father encounter.");
        }
        catch (Exception e) {
            InsideTheSystemMod.LOGGER.error("CRITICAL: Failed to kick player with primary method: " + e.getMessage());
            try {
                serverPlayer.f_8906_.m_9942_((Component)kickMessage);
            }
            catch (Exception e2) {
                InsideTheSystemMod.LOGGER.error("CRITICAL: Failed to kick player even with fallback method: " + e2.getMessage());
            }
        }
        server.execute(() -> BehindYouProcedure.lambda$kickPlayerGuaranteed$0(serverPlayer, (Component)kickMessage));
    }

    private static void handleFatherBehavior(LevelAccessor world, Player player) {
        if (!(world instanceof Level)) {
            return;
        }
        Level _level = (Level)world;
        UUID playerId = player.m_20148_();
        if (kickSequenceStarted.getOrDefault(playerId, false).booleanValue()) {
            return;
        }
        AABB searchArea = new AABB(player.m_20185_() - 50.0, player.m_20186_() - 50.0, player.m_20189_() - 50.0, player.m_20185_() + 50.0, player.m_20186_() + 50.0, player.m_20189_() + 50.0);
        List fatherEntities = _level.m_45976_(FatherEntity.class, searchArea);
        for (FatherEntity father : fatherEntities) {
            if ((double)father.m_20270_((Entity)player) <= 2.0 && !kickSequenceStarted.getOrDefault(playerId, false).booleanValue()) {
                kickSequenceStarted.put(playerId, true);
                teleportationDisabled.put(playerId, true);
                try {
                    _level.m_5594_(null, new BlockPos((int)player.m_20185_(), (int)player.m_20186_(), (int)player.m_20189_()), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("inside_the_system:behindscreamer")), SoundSource.NEUTRAL, 1.0f, 1.0f);
                }
                catch (Exception e) {
                    InsideTheSystemMod.LOGGER.warn("Could not play sound: " + e.getMessage());
                }
                BehindYouProcedure.removeAllFatherEntities(world, player);
                entityRemoved.put(playerId, true);
                scaryMessageCounter.put(playerId, 0);
                kickCountdowns.put(playerId, 40);
                return;
            }
            boolean lookingAtFather = BehindYouProcedure.isPlayerLookingAtEntity(player, (Entity)father);
            if (lookingAtFather) {
                if (!player.m_9236_().m_5776_()) {
                    BehindYouProcedure.lockPlayerLookAtEntity(player, (Entity)father);
                }
                if (!isPlayerLookingAtFather) {
                    isPlayerLookingAtFather = true;
                    approachTimer = 0L;
                }
                if (++approachTimer < 40L) continue;
                approachTimer = 0L;
                BehindYouProcedure.moveEntityCloserToPlayer((Entity)father, player, 5.0);
                continue;
            }
            isPlayerLookingAtFather = false;
            approachTimer = 0L;
            if (teleportationDisabled.getOrDefault(playerId, false).booleanValue() || ++teleportTimer < 20L) continue;
            teleportTimer = 0L;
            BehindYouProcedure.teleportBehindPlayer((Entity)father, player, 30.0);
        }
    }

    private static boolean isPlayerLookingAtEntity(Player player, Entity target) {
        Vec3 playerPos = player.m_146892_();
        Vec3 targetPos = target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() / 2.0f), 0.0);
        Vec3 toTarget = targetPos.m_82546_(playerPos).m_82541_();
        Vec3 lookVector = player.m_20154_();
        double dot = lookVector.m_82526_(toTarget);
        return dot > 0.7;
    }

    private static void lockPlayerLookAtEntity(Player player, Entity target) {
        Vec3 playerPos = player.m_146892_();
        Vec3 targetPos = target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() / 2.0f), 0.0);
        Vec3 direction = targetPos.m_82546_(playerPos).m_82541_();
        float yaw = (float)(Mth.m_14136_((double)(-direction.f_82479_), (double)direction.f_82481_) * 57.29577951308232);
        float pitch = (float)(-Mth.m_14136_((double)direction.f_82480_, (double)Math.sqrt(direction.f_82479_ * direction.f_82479_ + direction.f_82481_ * direction.f_82481_)) * 57.29577951308232);
        player.m_146922_(yaw);
        player.m_146926_(pitch);
        player.f_19859_ = yaw;
        player.f_19860_ = pitch;
    }

    private static void teleportBehindPlayer(Entity entity, Player player, double distance) {
        Vec3 lookVector = player.m_20154_();
        Vec3 behindVector = lookVector.m_82490_(-distance);
        double newX = player.m_20185_() + behindVector.f_82479_;
        double newY = player.m_20186_();
        double newZ = player.m_20189_() + behindVector.f_82481_;
        Level level = entity.m_9236_();
        BlockPos targetPos = new BlockPos((int)newX, (int)newY, (int)newZ);
        while (!level.m_8055_(targetPos).m_60795_() && targetPos.m_123342_() < level.m_151558_()) {
            targetPos = targetPos.m_7494_();
            newY += 1.0;
        }
        entity.m_6021_(newX, newY, newZ);
    }

    private static void moveEntityCloserToPlayer(Entity entity, Player player, double stepDistance) {
        Vec3 entityPos = entity.m_20182_();
        Vec3 playerPos = player.m_20182_();
        Vec3 direction = playerPos.m_82546_(entityPos).m_82541_();
        double currentDistance = entityPos.m_82554_(playerPos);
        if (currentDistance > 1.5) {
            Vec3 newPos = entityPos.m_82549_(direction.m_82490_(stepDistance));
            Level level = entity.m_9236_();
            BlockPos targetPos = new BlockPos((int)newPos.f_82479_, (int)newPos.f_82480_, (int)newPos.f_82481_);
            while (!level.m_8055_(targetPos).m_60795_() && targetPos.m_123342_() < level.m_151558_()) {
                targetPos = targetPos.m_7494_();
                newPos = new Vec3(newPos.f_82479_, (double)targetPos.m_123342_(), newPos.f_82481_);
            }
            entity.m_6021_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
        }
    }

    private static void createTunnel(ServerLevel level, BlockPos start, BlockPos end) {
        double dist = start.m_203198_((double)end.m_123341_() + 0.5, (double)end.m_123342_() + 0.5, (double)end.m_123343_() + 0.5);
        if (dist > 1.0) {
            Vec3 direction = new Vec3((double)(end.m_123341_() - start.m_123341_()), (double)(end.m_123342_() - start.m_123342_()), (double)(end.m_123343_() - start.m_123343_())).m_82541_();
            double step = 0.5;
            double currentX = start.m_123341_();
            double currentY = start.m_123342_();
            double currentZ = start.m_123343_();
            for (double d = 0.0; d < Math.sqrt(dist); d += step) {
                BlockPos pos1 = new BlockPos((int)(currentX += direction.f_82479_ * step), (int)(currentY += direction.f_82480_ * step) + 1, (int)(currentZ += direction.f_82481_ * step));
                BlockPos pos2 = new BlockPos((int)currentX, (int)currentY + 2, (int)currentZ);
                if (!level.m_8055_(pos1).m_60795_()) {
                    level.m_7731_(pos1, Blocks.f_50016_.m_49966_(), 3);
                }
                if (level.m_8055_(pos2).m_60795_()) continue;
                level.m_7731_(pos2, Blocks.f_50016_.m_49966_(), 3);
            }
        }
    }

    private static /* synthetic */ void lambda$kickPlayerGuaranteed$0(ServerPlayer serverPlayer, Component kickMessage) {
        if (serverPlayer.f_8906_ != null) {
            try {
                serverPlayer.f_8906_.m_9942_(kickMessage);
                InsideTheSystemMod.LOGGER.info("Force-kicked player " + serverPlayer.m_7755_().getString() + " via delayed execution");
            }
            catch (Exception e) {
                InsideTheSystemMod.LOGGER.error("Final kick attempt failed: " + e.getMessage());
            }
        }
    }
}

