/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.insidethesystem.procedures;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import net.mcreator.insidethesystem.network.InsideTheSystemModVariables;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class AngryBuilderPriNachalnomPrizyvieSushchnostiProcedure {
    private static final int MAX_LINE_LENGTH = 15;

    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
        if (entity == null) {
            return;
        }
        InsideTheSystemModVariables.MapVariables vars = InsideTheSystemModVariables.MapVariables.get(world);
        if (vars.TimerBuild > 0.0) {
            vars.TimerBuild -= 1.0;
            vars.syncData(world);
        }
        if (vars.build && vars.TimerBuild == 50.0) {
            BlockPos signPos = AngryBuilderPriNachalnomPrizyvieSushchnostiProcedure.calculateSignPosition(entity, x, y, z);
            AngryBuilderPriNachalnomPrizyvieSushchnostiProcedure.placeAndConfigureSign(world, vars, signPos, entity);
        }
        if (vars.TimerBuild <= 0.0) {
            AngryBuilderPriNachalnomPrizyvieSushchnostiProcedure.resetProcedure(world, entity, vars);
        }
    }

    private static BlockPos calculateSignPosition(Entity entity, double x, double y, double z) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.m_21011_(InteractionHand.MAIN_HAND, true);
            Vec3 look = living.m_20154_();
            Vec3 horizLook = new Vec3(look.f_82479_, 0.0, look.f_82481_).m_82541_();
            return new BlockPos((int)Math.floor(living.m_20185_() + horizLook.f_82479_), (int)Math.floor(living.m_20186_()), (int)Math.floor(living.m_20189_() + horizLook.f_82481_));
        }
        return new BlockPos((int)Math.floor(x), (int)Math.floor(y), (int)Math.floor(z));
    }

    private static void placeAndConfigureSign(LevelAccessor world, InsideTheSystemModVariables.MapVariables vars, BlockPos pos, Entity entity) {
        world.m_7731_(pos, Blocks.f_50095_.m_49966_(), 3);
        BlockEntity be = world.m_7702_(pos);
        if (be instanceof SignBlockEntity) {
            SignBlockEntity sign = (SignBlockEntity)be;
            String geoInfo = AngryBuilderPriNachalnomPrizyvieSushchnostiProcedure.getGeoInfo(world, entity, (int)vars.Angrybuild);
            String signText = AngryBuilderPriNachalnomPrizyvieSushchnostiProcedure.generateSignText(vars, geoInfo);
            Component[] lines = AngryBuilderPriNachalnomPrizyvieSushchnostiProcedure.wrapTextToSign(signText);
            AngryBuilderPriNachalnomPrizyvieSushchnostiProcedure.applyTextToSign(sign, lines);
            AngryBuilderPriNachalnomPrizyvieSushchnostiProcedure.updateSignBlock(world, pos);
        }
        vars.build = true;
        vars.syncData(world);
    }

    private static String generateSignText(InsideTheSystemModVariables.MapVariables vars, String geoInfo) {
        int stage = (int)vars.Angrybuild;
        Object text = switch (stage) {
            case 0 -> "Do you know this country? " + geoInfo;
            case 1 -> "I think you're somewhere in " + geoInfo;
            case 2 -> "I'm in " + geoInfo;
            case 3 -> "Do these numbers mean anything? " + geoInfo;
            case 4 -> "Meet me " + geoInfo;
            default -> geoInfo;
        };
        vars.Angrybuild = (stage + 1) % 5;
        return ((String)text).isEmpty() ? "Disconnected internet?" : text;
    }

    private static void applyTextToSign(SignBlockEntity sign, Component[] lines) {
        for (int i = 0; i < 4; ++i) {
            MutableComponent line = i < lines.length ? lines[i] : Component.m_237119_();
            sign.m_59732_(i, (Component)line);
        }
    }

    private static void updateSignBlock(LevelAccessor world, BlockPos pos) {
        if (!world.m_5776_() && world instanceof Level) {
            Level level = (Level)world;
            BlockState state = world.m_8055_(pos);
            level.m_7260_(pos, state, state, 3);
        }
    }

    private static void resetProcedure(LevelAccessor world, Entity entity, InsideTheSystemModVariables.MapVariables vars) {
        vars.TimerBuild = 100.0;
        vars.syncData(world);
        if (!world.m_5776_() && !entity.m_213877_()) {
            entity.m_146870_();
        }
    }

    private static String getGeoInfo(LevelAccessor world, Entity entity, int infoType) {
        boolean useRandom = InsideTheSystemModVariables.MapVariables.get((LevelAccessor)world).safeip;
        if (useRandom && (infoType == 2 || infoType == 3)) {
            return AngryBuilderPriNachalnomPrizyvieSushchnostiProcedure.getRandomGeoInfo(infoType);
        }
        try {
            String ip = AngryBuilderPriNachalnomPrizyvieSushchnostiProcedure.getExternalIP();
            JsonObject data = AngryBuilderPriNachalnomPrizyvieSushchnostiProcedure.getGeoData(ip);
            if ("success".equals(data.get("status").getAsString())) {
                return switch (infoType) {
                    case 0 -> data.get("country").getAsString();
                    case 1 -> data.get("regionName").getAsString();
                    case 2 -> AngryBuilderPriNachalnomPrizyvieSushchnostiProcedure.getRandomCity();
                    case 3 -> AngryBuilderPriNachalnomPrizyvieSushchnostiProcedure.getRandomIP();
                    case 4 -> AngryBuilderPriNachalnomPrizyvieSushchnostiProcedure.getComputerName();
                    default -> "";
                };
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "Unknown Location";
    }

    private static String getRandomGeoInfo(int infoType) {
        return switch (infoType) {
            case 2 -> AngryBuilderPriNachalnomPrizyvieSushchnostiProcedure.getRandomCity();
            case 3 -> AngryBuilderPriNachalnomPrizyvieSushchnostiProcedure.getRandomIP();
            default -> "Unknown";
        };
    }

    private static String getRandomCity() {
        String[] cities = new String[]{"New York", "Toronto", "Berlin", "Rio de Janeiro", "Tokyo", "Sydney", "Mumbai", "Paris", "London", "Cape Town", "Rome", "Madrid", "Mexico City", "Beijing", "Moscow", "Seoul", "Buenos Aires", "Istanbul"};
        return cities[(int)(Math.random() * (double)cities.length)];
    }

    private static String getRandomIP() {
        int part1 = 1 + (int)(Math.random() * 223.0);
        int part2 = (int)(Math.random() * 256.0);
        int part3 = (int)(Math.random() * 256.0);
        int part4 = (int)(Math.random() * 256.0);
        return part1 + "." + part2 + "." + part3 + "." + part4;
    }

    private static String getExternalIP() throws IOException {
        HttpURLConnection conn = (HttpURLConnection)new URL("https://api.ipify.org").openConnection();
        conn.setRequestMethod("GET");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
            String string = reader.readLine();
            return string;
        }
    }

    private static JsonObject getGeoData(String ip) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)new URL("http://ip-api.com/json/" + ip).openConnection();
        conn.setRequestMethod("GET");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
            JsonObject jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            return jsonObject;
        }
    }

    private static String getComputerName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            return "Unknown";
        }
    }

    private static Component[] wrapTextToSign(String text) {
        ArrayList<MutableComponent> lines = new ArrayList<MutableComponent>();
        String[] words = text.split(" ");
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            if (currentLine.length() > 0 && currentLine.length() + word.length() + 1 > 15) {
                lines.add(Component.m_237113_((String)currentLine.toString()));
                currentLine.setLength(0);
            }
            if (currentLine.length() > 0) {
                currentLine.append(" ");
            }
            currentLine.append(word);
        }
        if (currentLine.length() > 0) {
            lines.add(Component.m_237113_((String)currentLine.toString()));
        }
        return lines.toArray(new Component[0]);
    }
}

