/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.insidethesystem.procedures;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import javax.annotation.Nullable;
import net.mcreator.insidethesystem.entity.CoolPlayer303Entity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class CoolPlayerSkinsProcedure {
    private static int messageDelay = 0;
    private static String skinFound = "";
    private static Player playerToSend = null;

    @SubscribeEvent
    public static void onChat(ServerChatEvent event) {
        CoolPlayerSkinsProcedure.execute((Event)event, (LevelAccessor)event.getPlayer().f_19853_, event.getRawText(), (Player)event.getPlayer());
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            CoolPlayerSkinsProcedure.handleMessageDelay();
        }
    }

    private static void execute(@Nullable Event event, LevelAccessor world, String text, Player player) {
        int radius;
        if (text == null) {
            return;
        }
        String skinName = text.trim().toLowerCase();
        if (skinName.contains(" ")) {
            return;
        }
        if (!CoolPlayerSkinsProcedure.skinFileExists(skinName)) {
            return;
        }
        BlockPos playerPos = player.m_20183_();
        List mobs = world.m_45976_(CoolPlayer303Entity.class, new AABB(playerPos).m_82400_((double)(radius = 10)));
        if (mobs.isEmpty()) {
            return;
        }
        for (CoolPlayer303Entity mob : mobs) {
            mob.setSkinName(skinName);
        }
        messageDelay = 20;
        skinFound = skinName;
        playerToSend = player;
    }

    private static void handleMessageDelay() {
        if (messageDelay > 0 && --messageDelay <= 0 && playerToSend != null) {
            CoolPlayerSkinsProcedure.playChangeSound(playerToSend);
            CoolPlayerSkinsProcedure.sendDelayedMessage(playerToSend, skinFound);
            playerToSend = null;
            skinFound = "";
        }
    }

    private static void playChangeSound(Player player) {
        Level _level = player.f_19853_;
        if (!_level.m_5776_()) {
            _level.m_5594_(null, player.m_20183_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("inside_the_system:change")), SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
    }

    private static void sendDelayedMessage(Player player, String skinName) {
        MutableComponent message = Component.m_237113_((String)"You found: ").m_7220_((Component)Component.m_237113_((String)(skinName + "!")).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)9055202))));
        player.m_213846_((Component)message);
    }

    private static boolean skinFileExists(String skinName) {
        Path skinsDir = Paths.get("saves", "InsideTheSystemSkins");
        File[] files = skinsDir.toFile().listFiles();
        if (files == null) {
            return false;
        }
        String targetFilename = skinName.toLowerCase() + ".png";
        for (File file : files) {
            if (!file.isFile() || !file.getName().equalsIgnoreCase(targetFilename)) continue;
            return true;
        }
        return false;
    }
}

