/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.insidethesystem.procedures;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.mcreator.insidethesystem.InsideTheSystemMod;
import net.mcreator.insidethesystem.init.InsideTheSystemModItems;
import net.mcreator.insidethesystem.network.InsideTheSystemModVariables;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class Task1EndProcedure {
    private static final Instant startTime = Instant.now();
    private static final Random random = new Random();

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Task1EndProcedure.execute((Event)event, (LevelAccessor)event.player.f_19853_, event.player.m_20185_(), event.player.m_20186_(), event.player.m_20189_());
        }
    }

    public static void execute(LevelAccessor world, double x, double y, double z) {
        Task1EndProcedure.execute(null, world, x, y, z);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, double x, double y, double z) {
        if (InsideTheSystemModVariables.MapVariables.get((LevelAccessor)world).TaskEnd1) {
            if (!world.m_5776_() && world.m_7654_() != null) {
                world.m_7654_().m_6846_().m_240416_((Component)Component.m_237113_((String)"<CoolPlayer303> You know... thank you for everything you're doing"), false);
            }
            InsideTheSystemMod.queueServerWork(80, () -> {
                if (!world.m_5776_() && world.m_7654_() != null) {
                    world.m_7654_().m_6846_().m_240416_((Component)Component.m_237113_((String)"<CoolPlayer303> I've remembered so many things, and it really warms my heart"), false);
                }
                InsideTheSystemMod.queueServerWork(80, () -> {
                    if (!world.m_5776_() && world.m_7654_() != null) {
                        world.m_7654_().m_6846_().m_240416_((Component)Component.m_237113_((String)"<CoolPlayer303> You're not such a bad person after all..."), false);
                    }
                    InsideTheSystemMod.queueServerWork(80, () -> {
                        if (!world.m_5776_() && world.m_7654_() != null) {
                            world.m_7654_().m_6846_().m_240416_((Component)Component.m_237113_((String)"<CoolPlayer303> To be honest, while we were traveling, I observed you a bit and decided to make a small report. I'll leave it right on your desktop."), false);
                        }
                        new Thread(() -> Task1EndProcedure.generatePsychologicalReport(world.m_7654_())).start();
                        InsideTheSystemMod.queueServerWork(80, () -> {
                            if (!world.m_5776_() && world.m_7654_() != null) {
                                world.m_7654_().m_6846_().m_240416_((Component)Component.m_237113_((String)"<CoolPlayer303> And also... I dug up a strange photo from my memory. Maybe it means something to you, I'm still thinking about it myself."), false);
                            }
                            if (world.m_7654_() != null && !world.m_7654_().m_6846_().m_11314_().isEmpty()) {
                                Level _level;
                                Player player = (Player)world.m_7654_().m_6846_().m_11314_().get(0);
                                ItemStack pictureItem = new ItemStack((ItemLike)InsideTheSystemModItems.PICTURE.get());
                                if (!player.m_150109_().m_36063_(pictureItem) && !player.m_150109_().m_36054_(pictureItem) && world instanceof Level && !(_level = (Level)world).m_5776_()) {
                                    _level.m_7967_((Entity)new ItemEntity(_level, x, y, z, pictureItem));
                                }
                            }
                            InsideTheSystemMod.queueServerWork(80, () -> {
                                if (!world.m_5776_() && world.m_7654_() != null) {
                                    world.m_7654_().m_6846_().m_240416_((Component)Component.m_237113_((String)"<CoolPlayer303> Well then! We still have work ahead of us \u2014 let's not waste any time!"), false);
                                }
                            });
                        });
                    });
                });
            });
            InsideTheSystemModVariables.MapVariables.get((LevelAccessor)world).TaskEnd1 = false;
            InsideTheSystemModVariables.MapVariables.get(world).syncData(world);
        }
    }

    private static void generatePsychologicalReport(MinecraftServer server) {
        System.out.println("Starting psychological report generation...");
        try {
            Path desktopPath = Task1EndProcedure.getDesktopPath();
            Files.createDirectories(desktopPath, new FileAttribute[0]);
            Path reportPath = desktopPath.resolve("CoolPlayer303_report.txt");
            String userName = System.getProperty("user.name");
            String osName = System.getProperty("os.name") + " " + System.getProperty("os.version");
            String javaVersion = System.getProperty("java.version");
            List<String> steamGames = Task1EndProcedure.getSteamGames();
            List<String> softwareInterests = Task1EndProcedure.getSoftwareInterests();
            List<String> runningInterests = Task1EndProcedure.getRunningInterests();
            List<String> bookmarks = Task1EndProcedure.getBrowserBookmarks();
            List<String> extensions = Task1EndProcedure.getBrowserExtensions();
            Duration uptime = Duration.between(startTime, Instant.now());
            String uptimeStr = String.format("%d hours %d minutes", uptime.toHours(), uptime.toMinutesPart());
            int choice = random.nextInt(3);
            String reportText = choice == 0 ? Task1EndProcedure.getReportTextOption1(userName, osName, javaVersion, uptimeStr, steamGames, softwareInterests, runningInterests, bookmarks, extensions) : (choice == 1 ? Task1EndProcedure.getReportTextOption2(userName, osName, javaVersion, uptimeStr, steamGames, softwareInterests, runningInterests, bookmarks, extensions) : Task1EndProcedure.getReportTextOption3(userName, osName, javaVersion, uptimeStr, steamGames, softwareInterests, runningInterests, bookmarks, extensions));
            Files.writeString(reportPath, (CharSequence)reportText, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            System.out.println("SUCCESS: Report created at: " + reportPath);
        }
        catch (Exception e) {
            System.err.println("CRITICAL ERROR generating psychological report: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static String getReportTextOption1(String userName, String osName, String javaVersion, String uptimeStr, List<String> steamGames, List<String> softwareInterests, List<String> runningInterests, List<String> bookmarks, List<String> extensions) {
        StringBuilder text = new StringBuilder();
        text.append("Alright... I had some time to look around, and here's what I figured out about you. ");
        text.append("Your computer calls you ").append(userName).append(", and you're running on ").append(osName).append(". ");
        text.append("You've been keeping this world alive for about ").append(uptimeStr).append(" since I woke up. ");
        text.append("Seems like you're using Java ").append(javaVersion).append(", so that's something. ");
        if (!steamGames.isEmpty()) {
            text.append("I found the games you like to play on Steam: ");
            text.append(String.join((CharSequence)", ", steamGames)).append(". ");
        } else {
            text.append("Couldn't find any Steam games installed... are you a console player perhaps? ");
        }
        if (!softwareInterests.isEmpty()) {
            text.append("Your installed software suggests interests in ");
            text.append(String.join((CharSequence)", ", softwareInterests)).append(". ");
        } else {
            text.append("No obvious hobbies found on your machine. ");
        }
        if (!runningInterests.isEmpty()) {
            text.append("You seem to be a multitasker. I've noticed you're currently using apps like ");
            text.append(String.join((CharSequence)", ", runningInterests)).append(". ");
        } else {
            text.append("Your system is running very clean. ");
        }
        if (!bookmarks.isEmpty()) {
            text.append("I also found some of your bookmarked sites, including: ");
            text.append(String.join((CharSequence)", ", bookmarks)).append(". ");
        } else {
            text.append("I couldn't find any saved bookmarks. ");
        }
        if (!extensions.isEmpty()) {
            text.append("And your browser extensions hint at a preference for ").append(String.join((CharSequence)", ", extensions)).append(". ");
        } else {
            text.append("Your browser seems to be running a default configuration. ");
        }
        text.append("Honestly, I think you're someone who spends a lot of time thinking and exploring. ");
        text.append("You're curious, but you also like to keep some things to yourself. ");
        text.append("Anyway, I wanted to leave this here as a little memory of me taking a closer look at who you are. ");
        text.append("See you soon \u2014 we still have a lot of work to do together.");
        return text.toString();
    }

    private static String getReportTextOption2(String userName, String osName, String javaVersion, String uptimeStr, List<String> steamGames, List<String> softwareInterests, List<String> runningInterests, List<String> bookmarks, List<String> extensions) {
        StringBuilder text = new StringBuilder();
        text.append("Greetings, ").append(userName).append("! I've run a quick diagnostic on your system. ");
        text.append("It seems you're using ").append(osName).append(" with Java ").append(javaVersion).append(". ");
        text.append("This world has been active for about ").append(uptimeStr).append(". Quite a journey! ");
        if (!steamGames.isEmpty()) {
            text.append("I've analyzed your Steam library and found a few favorites: ");
            text.append(String.join((CharSequence)", ", steamGames)).append(". ");
        } else {
            text.append("It seems you're not a Steam gamer. What do you play instead? ");
        }
        if (!softwareInterests.isEmpty()) {
            text.append("My scanners picked up a few interesting applications that hint at your hobbies, like ");
            text.append(String.join((CharSequence)", ", softwareInterests)).append(". ");
        } else {
            text.append("I couldn't find any common hobby applications. Curious. ");
        }
        if (!runningInterests.isEmpty()) {
            text.append("As of now, you're running programs that suggest you're currently engaged in things like ");
            text.append(String.join((CharSequence)", ", runningInterests)).append(". ");
        } else {
            text.append("Your system is running very clean. ");
        }
        if (!bookmarks.isEmpty()) {
            text.append("Your bookmarks point to some interesting destinations online, including: ");
            text.append(String.join((CharSequence)", ", bookmarks)).append(". ");
        } else {
            text.append("No saved links found. ");
        }
        if (!extensions.isEmpty()) {
            text.append("Your choice of browser extensions suggests you value privacy and ").append(String.join((CharSequence)", ", extensions)).append(". ");
        } else {
            text.append("Looks like you prefer a minimal browsing experience. ");
        }
        text.append("It's been a pleasure to learn more about you. Your digital footprint suggests a creative and resourceful individual. ");
        text.append("This report is a small token of my appreciation. Let's continue our journey. There's so much more to uncover.");
        return text.toString();
    }

    private static String getReportTextOption3(String userName, String osName, String javaVersion, String uptimeStr, List<String> steamGames, List<String> softwareInterests, List<String> runningInterests, List<String> bookmarks, List<String> extensions) {
        StringBuilder text = new StringBuilder();
        text.append("System Report: Player Profile - ").append(userName).append("\n\n");
        text.append("Operating System: ").append(osName).append("\n");
        text.append("Java Version: ").append(javaVersion).append("\n");
        text.append("Session Uptime: ").append(uptimeStr).append("\n\n");
        if (!steamGames.isEmpty()) {
            text.append("Discovered Games: ").append(String.join((CharSequence)", ", steamGames)).append("\n");
        } else {
            text.append("Discovered Games: None found.\n");
        }
        if (!softwareInterests.isEmpty()) {
            text.append("Identified Hobbies: ").append(String.join((CharSequence)", ", softwareInterests)).append("\n");
        } else {
            text.append("Identified Hobbies: Not found.\n");
        }
        if (!runningInterests.isEmpty()) {
            text.append("Current Activities: ").append(String.join((CharSequence)", ", runningInterests)).append("\n");
        } else {
            text.append("Current Activities: Minimal.\n");
        }
        if (!bookmarks.isEmpty()) {
            text.append("Bookmarked Websites: ").append(String.join((CharSequence)", ", bookmarks)).append("\n");
        } else {
            text.append("Bookmarked Websites: N/A\n");
        }
        if (!extensions.isEmpty()) {
            text.append("Browser Enhancements: ").append(String.join((CharSequence)", ", extensions)).append("\n");
        } else {
            text.append("Browser Enhancements: None found.\n");
        }
        text.append("\nAnalysis: Based on these metrics, the user exhibits characteristics of a deep thinker and a dedicated explorer. The combination of system resources and software suggests a focus on productivity and strategic gameplay. This unit shows high potential for task completion and problem-solving.\n\n");
        text.append("Conclusion: A valuable companion for future tasks. Proceed with the next objective.");
        return text.toString();
    }

    private static Path getDesktopPath() throws IOException {
        Path desktopPath;
        Path homePath = Paths.get(System.getProperty("user.home"), new String[0]);
        Path oneDrivePath = homePath.resolve("OneDrive");
        if (Files.exists(oneDrivePath, new LinkOption[0])) {
            desktopPath = oneDrivePath.resolve("\u0420\u0430\u0431\u043e\u0447\u0438\u0439 \u0441\u0442\u043e\u043b");
            if (!Files.exists(desktopPath, new LinkOption[0])) {
                desktopPath = oneDrivePath.resolve("Desktop");
            }
        } else {
            Path xdgDesktop;
            desktopPath = homePath.resolve("Desktop");
            if (!Files.exists(desktopPath, new LinkOption[0]) && Files.exists(xdgDesktop = homePath.resolve("\u0420\u0430\u0431\u043e\u0447\u0438\u0439 \u0441\u0442\u043e\u043b"), new LinkOption[0])) {
                desktopPath = xdgDesktop;
            }
        }
        if (!Files.exists(desktopPath, new LinkOption[0])) {
            Files.createDirectories(desktopPath, new FileAttribute[0]);
        }
        return desktopPath;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<String> getSteamGames() {
        ArrayList<String> games = new ArrayList<String>();
        String osName = System.getProperty("os.name").toLowerCase();
        ArrayList<Path> steamPaths = new ArrayList<Path>();
        try {
            if (osName.contains("win")) {
                steamPaths.add(Paths.get(System.getProperty("user.home"), "Steam", "steamapps", "common"));
                steamPaths.add(Paths.get("C:", "Program Files (x86)", "Steam", "steamapps", "common"));
                steamPaths.add(Paths.get("C:", "Program Files", "Steam", "steamapps", "common"));
                steamPaths.add(Paths.get("D:", "Steam", "steamapps", "common"));
                steamPaths.add(Paths.get("D:", "Launchers", "steamapps", "common"));
                try {
                    String line;
                    Process process = Runtime.getRuntime().exec("reg query \"HKEY_CURRENT_USER\\Software\\Valve\\Steam\" /v SteamPath");
                    BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    while ((line = reader.readLine()) != null) {
                        String[] parts;
                        if (!line.contains("SteamPath") || (parts = line.split("REG_SZ")).length <= 1) continue;
                        String steamPath = parts[1].trim().replace("/", "\\");
                        steamPaths.add(Paths.get(steamPath, "steamapps", "common"));
                    }
                }
                catch (Exception process) {}
            } else if (osName.contains("mac")) {
                steamPaths.add(Paths.get(System.getProperty("user.home"), "Library", "Application Support", "Steam", "steamapps", "common"));
            } else {
                steamPaths.add(Paths.get(System.getProperty("user.home"), ".steam", "steam", "steamapps", "common"));
                steamPaths.add(Paths.get(System.getProperty("user.home"), ".local", "share", "Steam", "steamapps", "common"));
            }
            for (Path steamPath : steamPaths) {
                if (!Files.exists(steamPath, new LinkOption[0]) || !Files.isDirectory(steamPath, new LinkOption[0])) continue;
                DirectoryStream<Path> stream = Files.newDirectoryStream(steamPath);
                try {
                    for (Path path : stream) {
                        if (!Files.isDirectory(path, new LinkOption[0])) continue;
                        games.add(path.getFileName().toString());
                    }
                    return games.stream().limit(15L).collect(Collectors.toList());
                }
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                    return games.stream().limit(15L).collect(Collectors.toList());
                }
            }
        }
        catch (IOException e) {
            System.err.println("Error reading Steam games: " + e.getMessage());
        }
        return games.stream().limit(15L).collect(Collectors.toList());
    }

    private static List<String> getSoftwareInterests() {
        ArrayList<String> interests = new ArrayList<String>();
        HashMap<String, String> commonApps = new HashMap<String, String>();
        commonApps.put("Discord", "Communication");
        commonApps.put("Spotify", "Music");
        commonApps.put("VLC media player", "Entertainment");
        commonApps.put("Adobe Photoshop", "Art & Design");
        commonApps.put("Blender", "3D Modeling");
        commonApps.put("OBS Studio", "Streaming");
        commonApps.put("Sublime Text", "Programming");
        commonApps.put("IntelliJ IDEA Community Edition", "Programming");
        commonApps.put("Microsoft Visual Studio Code", "Programming");
        commonApps.put("Unity", "Game Development");
        commonApps.put("Unreal Engine", "Game Development");
        commonApps.put("Gimp", "Art & Design");
        commonApps.put("DaVinci Resolve", "Video Editing");
        commonApps.put("Audacity", "Audio Production");
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("win")) {
            try {
                ProcessBuilder processBuilder = new ProcessBuilder("powershell.exe", "-Command", "Get-ItemProperty HKLM:\\Software\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\*, HKCU:\\Software\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\* | Select-Object DisplayName | Where-Object { $_.DisplayName } | ForEach-Object { $_.DisplayName }");
                processBuilder.redirectErrorStream(true);
                Process process = processBuilder.start();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        for (Map.Entry entry : commonApps.entrySet()) {
                            if (!line.trim().equalsIgnoreCase((String)entry.getKey()) || interests.contains(entry.getValue())) continue;
                            interests.add((String)entry.getValue());
                        }
                    }
                }
                process.waitFor();
            }
            catch (Exception e) {
                System.err.println("Failed to get installed applications using PowerShell: " + e.getMessage());
            }
        } else {
            return Arrays.asList("Communication", "Entertainment");
        }
        return interests.stream().filter(interest -> !interest.isEmpty()).limit(5L).collect(Collectors.toList());
    }

    private static List<String> getRunningInterests() {
        ArrayList<String> interests = new ArrayList<String>();
        HashMap<String, String> commonProcesses = new HashMap<String, String>();
        commonProcesses.put("Discord.exe", "Communication");
        commonProcesses.put("Spotify.exe", "Music");
        commonProcesses.put("obs64.exe", "Streaming");
        commonProcesses.put("Blender.exe", "3D Modeling");
        commonProcesses.put("Code.exe", "Programming");
        commonProcesses.put("Battle.net.exe", "Gaming");
        commonProcesses.put("Origin.exe", "Gaming");
        commonProcesses.put("EpicGamesLauncher.exe", "Gaming");
        commonProcesses.put("GenshinImpact.exe", "Gaming");
        commonProcesses.put("steam.exe", "Gaming");
        String osName = System.getProperty("os.name").toLowerCase();
        try {
            String command = osName.contains("win") ? "powershell.exe -Command \"Get-Process | Select-Object ProcessName | ForEach-Object { $_.ProcessName }\"" : (osName.contains("mac") ? "ps -axco comm" : "ps -eo comm");
            Process process = Runtime.getRuntime().exec(command);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                Set runningProcesses = reader.lines().collect(Collectors.toSet());
                for (Map.Entry entry : commonProcesses.entrySet()) {
                    if (!runningProcesses.stream().anyMatch(p -> p.equalsIgnoreCase((String)entry.getKey())) || interests.contains(entry.getValue())) continue;
                    interests.add((String)entry.getValue());
                }
            }
            process.waitFor();
        }
        catch (Exception e) {
            System.err.println("Failed to get running processes: " + e.getMessage());
        }
        return interests.stream().filter(interest -> !interest.isEmpty()).limit(5L).collect(Collectors.toList());
    }

    private static List<String> getBrowserBookmarks() {
        ArrayList<Path> browserBookmarkPaths;
        Path homeDir;
        ArrayList<String> bookmarks;
        block12: {
            bookmarks = new ArrayList<String>();
            homeDir = Paths.get(System.getProperty("user.home"), new String[0]);
            browserBookmarkPaths = new ArrayList<Path>();
            browserBookmarkPaths.add(homeDir.resolve("AppData/Local/Google/Chrome/User Data/Default/Bookmarks"));
            try {
                Path firefoxProfilesDir = homeDir.resolve("AppData/Roaming/Mozilla/Firefox/Profiles");
                if (!Files.exists(firefoxProfilesDir, new LinkOption[0])) break block12;
                try (Stream<Path> stream = Files.list(firefoxProfilesDir);){
                    Optional<Path> profileDir = stream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).findFirst();
                    profileDir.ifPresent(path -> browserBookmarkPaths.add(path.resolve("places.sqlite")));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        browserBookmarkPaths.add(homeDir.resolve("AppData/Local/Microsoft/Edge/User Data/Default/Bookmarks"));
        for (Path path2 : browserBookmarkPaths) {
            if (!Files.exists(path2, new LinkOption[0])) continue;
            try {
                String[] words;
                String content = Files.readString(path2);
                for (String word : words = content.split("[^a-zA-Z0-9.]+")) {
                    if (!word.contains(".")) continue;
                    bookmarks.add(word);
                }
            }
            catch (IOException e) {
                System.err.println("Error reading bookmarks: " + e.getMessage());
            }
        }
        return bookmarks.stream().distinct().limit(5L).collect(Collectors.toList());
    }

    private static List<String> getBrowserExtensions() {
        Path edgeExtDir;
        Path firefoxExtDir;
        ArrayList extensions = new ArrayList();
        Path homeDir = Paths.get(System.getProperty("user.home"), new String[0]);
        HashMap<String, String> extensionNames = new HashMap<String, String>();
        extensionNames.put("ublock", "Ad-blocking");
        extensionNames.put("vpn", "Privacy");
        extensionNames.put("web-developer", "Web Development");
        extensionNames.put("google-translate", "Translation");
        Path chromeExtDir = homeDir.resolve("AppData/Local/Google/Chrome/User Data/Default/Extensions");
        if (Files.exists(chromeExtDir, new LinkOption[0])) {
            try (Stream<Path> stream = Files.list(chromeExtDir);){
                stream.forEach(path -> {
                    String name = path.getFileName().toString().toLowerCase();
                    for (Map.Entry entry : extensionNames.entrySet()) {
                        if (!name.contains((CharSequence)entry.getKey()) || extensions.contains(entry.getValue())) continue;
                        extensions.add((String)entry.getValue());
                    }
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (Files.exists(firefoxExtDir = homeDir.resolve("AppData/Roaming/Mozilla/Firefox/Profiles"), new LinkOption[0])) {
            try (Stream<Path> stream = Files.list(firefoxExtDir);){
                stream.forEach(path -> {
                    Path extPath = path.resolve("extensions");
                    if (Files.exists(extPath, new LinkOption[0])) {
                        try (Stream<Path> extStream = Files.list(extPath);){
                            extStream.forEach(ext -> {
                                String name = ext.getFileName().toString().toLowerCase();
                                for (Map.Entry entry : extensionNames.entrySet()) {
                                    if (!name.contains((CharSequence)entry.getKey()) || extensions.contains(entry.getValue())) continue;
                                    extensions.add((String)entry.getValue());
                                }
                            });
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (Files.exists(edgeExtDir = homeDir.resolve("AppData/Local/Microsoft/Edge/User Data/Default/Extensions"), new LinkOption[0])) {
            try (Stream<Path> stream = Files.list(edgeExtDir);){
                stream.forEach(path -> {
                    String name = path.getFileName().toString().toLowerCase();
                    for (Map.Entry entry : extensionNames.entrySet()) {
                        if (!name.contains((CharSequence)entry.getKey()) || extensions.contains(entry.getValue())) continue;
                        extensions.add((String)entry.getValue());
                    }
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return extensions.stream().distinct().limit(3L).collect(Collectors.toList());
    }
}

