/*
 * Decompiled with CFR 0.152.
 */
package the_great_outdoors.init;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import the_great_outdoors.entity.CinnamonBearEntity;
import the_great_outdoors.entity.GeyserWaterEntity;
import the_great_outdoors.entity.MountainBluebirdEntity;
import the_great_outdoors.entity.PronghornEntity;
import the_great_outdoors.entity.PumaEntity;
import the_great_outdoors.entity.RubberBoaEntity;
import the_great_outdoors.entity.SeeperEntity;
import the_great_outdoors.entity.YellowBelliedMarmotEntity;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class TheGreatOutdoorsModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"the_great_outdoors");
    public static final DeferredHolder<EntityType<?>, EntityType<PronghornEntity>> PRONGHORN = TheGreatOutdoorsModEntities.register("pronghorn", EntityType.Builder.of(PronghornEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<SeeperEntity>> SEEPER = TheGreatOutdoorsModEntities.register("seeper", EntityType.Builder.of(SeeperEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(1.0f, 2.2f));
    public static final DeferredHolder<EntityType<?>, EntityType<GeyserWaterEntity>> GEYSER_WATER = TheGreatOutdoorsModEntities.register("geyser_water", EntityType.Builder.of(GeyserWaterEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.3f, 0.4f));
    public static final DeferredHolder<EntityType<?>, EntityType<MountainBluebirdEntity>> MOUNTAIN_BLUEBIRD = TheGreatOutdoorsModEntities.register("mountain_bluebird", EntityType.Builder.of(MountainBluebirdEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.5f, 0.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<CinnamonBearEntity>> CINNAMON_BEAR = TheGreatOutdoorsModEntities.register("cinnamon_bear", EntityType.Builder.of(CinnamonBearEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<YellowBelliedMarmotEntity>> YELLOW_BELLIED_MARMOT = TheGreatOutdoorsModEntities.register("yellow_bellied_marmot", EntityType.Builder.of(YellowBelliedMarmotEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.5f, 0.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<PumaEntity>> PUMA = TheGreatOutdoorsModEntities.register("puma", EntityType.Builder.of(PumaEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(1.0f, 1.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<RubberBoaEntity>> RUBBER_BOA = TheGreatOutdoorsModEntities.register("rubber_boa", EntityType.Builder.of(RubberBoaEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 0.4f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(registryname));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        PronghornEntity.init(event);
        SeeperEntity.init(event);
        MountainBluebirdEntity.init(event);
        CinnamonBearEntity.init(event);
        YellowBelliedMarmotEntity.init(event);
        PumaEntity.init(event);
        RubberBoaEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)PRONGHORN.get(), PronghornEntity.createAttributes().build());
        event.put((EntityType)SEEPER.get(), SeeperEntity.createAttributes().build());
        event.put((EntityType)MOUNTAIN_BLUEBIRD.get(), MountainBluebirdEntity.createAttributes().build());
        event.put((EntityType)CINNAMON_BEAR.get(), CinnamonBearEntity.createAttributes().build());
        event.put((EntityType)YELLOW_BELLIED_MARMOT.get(), YellowBelliedMarmotEntity.createAttributes().build());
        event.put((EntityType)PUMA.get(), PumaEntity.createAttributes().build());
        event.put((EntityType)RUBBER_BOA.get(), RubberBoaEntity.createAttributes().build());
    }
}

