/*
 * Decompiled with CFR 0.152.
 */
package the_great_outdoors.item;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.crafting.CompoundIngredient;
import the_great_outdoors.init.TheGreatOutdoorsModBlocks;
import the_great_outdoors.procedures.HikingStickLivingEntityIsHitWithItemProcedure;
import the_great_outdoors.procedures.HikingStickRightclickedOnBlockProcedure;
import the_great_outdoors.procedures.HikingStickToolInInventoryTickProcedure;

public class HikingStickItem
extends SwordItem {
    private static final Tier TOOL_TIER = new Tier(){

        public int getUses() {
            return 90;
        }

        public float getSpeed() {
            return 5.0f;
        }

        public float getAttackDamageBonus() {
            return 0.0f;
        }

        public TagKey<Block> getIncorrectBlocksForDrops() {
            return BlockTags.INCORRECT_FOR_WOODEN_TOOL;
        }

        public int getEnchantmentValue() {
            return 10;
        }

        public Ingredient getRepairIngredient() {
            return CompoundIngredient.of((Ingredient[])new Ingredient[]{Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)TheGreatOutdoorsModBlocks.WHITEBARK_PINE_BRANCH.get())}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.STICK)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)TheGreatOutdoorsModBlocks.WHITEBARK_PINECONE_SAPLING.get())}), Ingredient.of((TagKey)ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"minecraft:saplings"))), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.OAK_SAPLING)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.SPRUCE_SAPLING)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.BIRCH_SAPLING)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.JUNGLE_SAPLING)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.ACACIA_SAPLING)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.DARK_OAK_SAPLING)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.CHERRY_SAPLING)})});
        }
    };

    public HikingStickItem() {
        super(TOOL_TIER, new Item.Properties().attributes(SwordItem.createAttributes((Tier)TOOL_TIER, (float)2.5f, (float)-3.0f)));
    }

    public boolean hurtEnemy(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        boolean retval = super.hurtEnemy(itemstack, entity, sourceentity);
        HikingStickLivingEntityIsHitWithItemProcedure.execute((LevelAccessor)entity.level(), entity.getX(), entity.getY(), entity.getZ(), (Entity)entity, itemstack);
        return retval;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.translatable((String)"item.the_great_outdoors.hiking_stick.description_0"));
        list.add((Component)Component.translatable((String)"item.the_great_outdoors.hiking_stick.description_1"));
    }

    public InteractionResult useOn(UseOnContext context) {
        super.useOn(context);
        HikingStickRightclickedOnBlockProcedure.execute((LevelAccessor)context.getLevel(), context.getClickedPos().getX(), context.getClickedPos().getY(), context.getClickedPos().getZ(), (Entity)context.getPlayer(), context.getItemInHand());
        return InteractionResult.SUCCESS;
    }

    public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(itemstack, world, entity, slot, selected);
        if (selected) {
            HikingStickToolInInventoryTickProcedure.execute((LevelAccessor)world, entity, itemstack);
        }
    }
}

