/*
 * Decompiled with CFR 0.152.
 */
package the_great_outdoors;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import the_great_outdoors.init.TheGreatOutdoorsModBlockEntities;
import the_great_outdoors.init.TheGreatOutdoorsModBlocks;
import the_great_outdoors.init.TheGreatOutdoorsModEnchantments;
import the_great_outdoors.init.TheGreatOutdoorsModEntities;
import the_great_outdoors.init.TheGreatOutdoorsModFeatures;
import the_great_outdoors.init.TheGreatOutdoorsModFluidTypes;
import the_great_outdoors.init.TheGreatOutdoorsModFluids;
import the_great_outdoors.init.TheGreatOutdoorsModItems;
import the_great_outdoors.init.TheGreatOutdoorsModPaintings;
import the_great_outdoors.init.TheGreatOutdoorsModParticleTypes;
import the_great_outdoors.init.TheGreatOutdoorsModPotions;
import the_great_outdoors.init.TheGreatOutdoorsModSounds;
import the_great_outdoors.init.TheGreatOutdoorsModTabs;
import the_great_outdoors.init.TheGreatOutdoorsModVillagerProfessions;
import the_great_outdoors.world.features.StructureFeature;

@Mod(value="the_great_outdoors")
public class TheGreatOutdoorsMod {
    public static final Logger LOGGER = LogManager.getLogger(TheGreatOutdoorsMod.class);
    public static final String MODID = "the_great_outdoors";
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("the_great_outdoors", "the_great_outdoors"), () -> "1", "1"::equals, "1"::equals);
    private static int messageID = 0;
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public TheGreatOutdoorsMod() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        TheGreatOutdoorsModSounds.REGISTRY.register(bus);
        TheGreatOutdoorsModBlocks.REGISTRY.register(bus);
        TheGreatOutdoorsModBlockEntities.REGISTRY.register(bus);
        TheGreatOutdoorsModItems.REGISTRY.register(bus);
        TheGreatOutdoorsModEntities.REGISTRY.register(bus);
        TheGreatOutdoorsModEnchantments.REGISTRY.register(bus);
        TheGreatOutdoorsModTabs.REGISTRY.register(bus);
        TheGreatOutdoorsModFeatures.REGISTRY.register(bus);
        StructureFeature.REGISTRY.register(bus);
        TheGreatOutdoorsModPotions.REGISTRY.register(bus);
        TheGreatOutdoorsModPaintings.REGISTRY.register(bus);
        TheGreatOutdoorsModParticleTypes.REGISTRY.register(bus);
        TheGreatOutdoorsModVillagerProfessions.PROFESSIONS.register(bus);
        TheGreatOutdoorsModFluids.REGISTRY.register(bus);
        TheGreatOutdoorsModFluidTypes.REGISTRY.register(bus);
    }

    public static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer);
        ++messageID;
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.setValue((Integer)work.getValue() - 1);
                if ((Integer)work.getValue() == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.getKey()).run());
            workQueue.removeAll(actions);
        }
    }
}

