/*
 * Decompiled with CFR 0.152.
 */
package the_great_outdoors.init;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import the_great_outdoors.entity.CinnamonBearEntity;
import the_great_outdoors.entity.GeyserWaterEntity;
import the_great_outdoors.entity.MountainBluebirdEntity;
import the_great_outdoors.entity.PronghornEntity;
import the_great_outdoors.entity.PumaEntity;
import the_great_outdoors.entity.RubberBoaEntity;
import the_great_outdoors.entity.SeeperEntity;
import the_great_outdoors.entity.YellowBelliedMarmotEntity;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class TheGreatOutdoorsModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"the_great_outdoors");
    public static final RegistryObject<EntityType<PronghornEntity>> PRONGHORN = TheGreatOutdoorsModEntities.register("pronghorn", EntityType.Builder.m_20704_(PronghornEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(PronghornEntity::new).m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<SeeperEntity>> SEEPER = TheGreatOutdoorsModEntities.register("seeper", EntityType.Builder.m_20704_(SeeperEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(SeeperEntity::new).m_20719_().m_20699_(1.0f, 2.2f));
    public static final RegistryObject<EntityType<GeyserWaterEntity>> GEYSER_WATER = TheGreatOutdoorsModEntities.register("geyser_water", EntityType.Builder.m_20704_(GeyserWaterEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(GeyserWaterEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.3f, 0.4f));
    public static final RegistryObject<EntityType<MountainBluebirdEntity>> MOUNTAIN_BLUEBIRD = TheGreatOutdoorsModEntities.register("mountain_bluebird", EntityType.Builder.m_20704_(MountainBluebirdEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(MountainBluebirdEntity::new).m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<CinnamonBearEntity>> CINNAMON_BEAR = TheGreatOutdoorsModEntities.register("cinnamon_bear", EntityType.Builder.m_20704_(CinnamonBearEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(CinnamonBearEntity::new).m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<YellowBelliedMarmotEntity>> YELLOW_BELLIED_MARMOT = TheGreatOutdoorsModEntities.register("yellow_bellied_marmot", EntityType.Builder.m_20704_(YellowBelliedMarmotEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(YellowBelliedMarmotEntity::new).m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<PumaEntity>> PUMA = TheGreatOutdoorsModEntities.register("puma", EntityType.Builder.m_20704_(PumaEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(PumaEntity::new).m_20699_(1.0f, 1.0f));
    public static final RegistryObject<EntityType<RubberBoaEntity>> RUBBER_BOA = TheGreatOutdoorsModEntities.register("rubber_boa", EntityType.Builder.m_20704_(RubberBoaEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(RubberBoaEntity::new).m_20699_(0.6f, 0.4f));

    private static <T extends Entity> RegistryObject<EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.m_20712_(registryname));
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            PronghornEntity.init();
            SeeperEntity.init();
            MountainBluebirdEntity.init();
            CinnamonBearEntity.init();
            YellowBelliedMarmotEntity.init();
            PumaEntity.init();
            RubberBoaEntity.init();
        });
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)PRONGHORN.get(), PronghornEntity.createAttributes().m_22265_());
        event.put((EntityType)SEEPER.get(), SeeperEntity.createAttributes().m_22265_());
        event.put((EntityType)MOUNTAIN_BLUEBIRD.get(), MountainBluebirdEntity.createAttributes().m_22265_());
        event.put((EntityType)CINNAMON_BEAR.get(), CinnamonBearEntity.createAttributes().m_22265_());
        event.put((EntityType)YELLOW_BELLIED_MARMOT.get(), YellowBelliedMarmotEntity.createAttributes().m_22265_());
        event.put((EntityType)PUMA.get(), PumaEntity.createAttributes().m_22265_());
        event.put((EntityType)RUBBER_BOA.get(), RubberBoaEntity.createAttributes().m_22265_());
    }
}

