/*
 * Decompiled with CFR 0.152.
 */
package com.example.globe;

import com.example.globe.GlobeNet;
import com.example.globe.GlobePending;
import com.example.globe.PolarCapScrubber;
import com.example.globe.StartCompass;
import com.example.globe.util.LatitudeMath;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.EnumSet;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2709;
import net.minecraft.class_2784;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3754;
import net.minecraft.class_5217;
import net.minecraft.class_5284;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_7924;
import net.minecraft.class_8710;
import net.minecraft.class_9276;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobeMod
implements ModInitializer {
    public static final String MOD_ID = "globe";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"globe");
    private static final String SPAWN_CHOSEN_TAG = "globe_spawn_chosen";
    public static final int BORDER_RADIUS = 7500;
    public static final int POLE_BAND_START_ABS_Z = 12000;
    public static final int POLE_WARNING_DISTANCE_BLOCKS = 256;
    public static final int POLE_LETHAL_DISTANCE_BLOCKS = 96;
    public static final int POLE_LETHAL_WARNING_DISTANCE = 256;
    public static final int EFFECT_REFRESH_TICKS = 20;
    public static final int POLE_START = 12000;
    private static PolarCapScrubber POLAR_SCRUBBER;
    private static final boolean ENABLE_POLAR_SCRUBBER = false;
    private static final class_2960 GLOBE_SETTINGS_ID;
    private static final class_2960 GLOBE_SETTINGS_XSMALL_ID;
    private static final class_2960 GLOBE_SETTINGS_SMALL_ID;
    private static final class_2960 GLOBE_SETTINGS_REGULAR_ID;
    private static final class_5321<class_5284> GLOBE_SETTINGS_KEY;
    private static final class_5321<class_5284> GLOBE_SETTINGS_XSMALL_KEY;
    private static final class_5321<class_5284> GLOBE_SETTINGS_SMALL_KEY;
    private static final class_5321<class_5284> GLOBE_SETTINGS_REGULAR_KEY;

    public void onInitialize() {
        LOGGER.info("{} initialized. Use the globe:globe world preset for deterministic terrain.", (Object)MOD_ID);
        GlobeNet.registerPayloads();
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"flyspeed").then(class_2170.method_9244((String)"level", (ArgumentType)IntegerArgumentType.integer((int)1, (int)5)).executes(ctx -> {
            class_3222 player = ((class_2168)ctx.getSource()).method_9207();
            int level = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"level");
            float speed = 0.05f * (float)level;
            player.method_31549().method_7248(speed);
            player.method_7355();
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Fly speed set to " + level)), false);
            return 1;
        }))));
        ServerLifecycleEvents.SERVER_STARTED.register(GlobeMod::applyWorldBorder);
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> {
            POLAR_SCRUBBER = null;
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            boolean startWithCompass;
            class_3218 overworld = server.method_30002();
            if (overworld == null) {
                return;
            }
            boolean isGlobe = GlobeMod.isGlobeOverworld(overworld);
            LOGGER.info("JOIN: player={}, isGlobeOverworld={}", (Object)handler.field_14140.method_5477().getString(), (Object)isGlobe);
            ServerPlayNetworking.send((class_3222)handler.field_14140, (class_8710)new GlobeNet.GlobeStatePayload(isGlobe));
            String pendingZone = server.method_3816() ? null : GlobePending.consume();
            boolean bl = startWithCompass = !server.method_3816() && GlobePending.startWithCompass;
            if (isGlobe && !server.method_3816() && !StartCompass.hasReceived(handler.field_14140)) {
                if (!startWithCompass) {
                    StartCompass.markReceived(handler.field_14140);
                } else if (GlobeMod.hasCompassAnywhere(handler.field_14140)) {
                    StartCompass.markReceived(handler.field_14140);
                } else {
                    boolean given = handler.field_14140.method_7270(new class_1799((class_1935)class_1802.field_8251));
                    if (given) {
                        StartCompass.markReceived(handler.field_14140);
                    }
                }
            }
            if (isGlobe && !handler.field_14140.method_5752().contains(SPAWN_CHOSEN_TAG)) {
                if (pendingZone != null) {
                    GlobeMod.applySpawnChoice(handler.field_14140, pendingZone);
                }
                if (!handler.field_14140.method_5752().contains(SPAWN_CHOSEN_TAG)) {
                    LOGGER.info("Sending spawn picker open to player={}", (Object)handler.field_14140.method_5477().getString());
                    ServerPlayNetworking.send((class_3222)handler.field_14140, (class_8710)new GlobeNet.OpenSpawnPickerPayload(true));
                }
            }
        });
        ServerPlayNetworking.registerGlobalReceiver(GlobeNet.SetSpawnPickerPayload.ID, (payload, context) -> context.server().execute(() -> GlobeMod.applySpawnChoice(context.player(), payload.zoneId())));
        ServerTickEvents.END_SERVER_TICK.register(GlobeMod::borderUxTick);
    }

    private static void applyWorldBorder(MinecraftServer server) {
        class_3218 overworld = server.method_30002();
        if (overworld == null) {
            return;
        }
        if (!GlobeMod.isGlobeOverworld(overworld)) {
            return;
        }
        int borderRadiusBlocks = GlobeMod.borderRadiusForGlobeOverworld(overworld);
        class_2784 border = overworld.method_8621();
        double diameter = (double)borderRadiusBlocks * 2.0;
        border.method_11978(0.0, 0.0);
        border.method_11969(diameter);
        POLAR_SCRUBBER = null;
        LOGGER.info("[Latitude] WorldBorder set: radius={} diameter={} center=0,0", (Object)borderRadiusBlocks, (Object)diameter);
    }

    private static void borderUxTick(MinecraftServer server) {
        class_3218 overworld = server.method_30002();
        if (overworld == null) {
            return;
        }
        if (!GlobeMod.isGlobeOverworld(overworld)) {
            return;
        }
        long worldTime = overworld.method_75260();
        if (worldTime % 10L != 0L) {
            return;
        }
        class_2784 border = overworld.method_8621();
        double radius = border.method_11965() * 0.5;
        if (radius < 2000.0) {
            return;
        }
        for (class_3222 player : server.method_3760().method_14571()) {
            if (player.method_51469() != overworld) continue;
            double absZ = Math.abs(player.method_23321());
            double distToPole = radius - absZ;
            PolarStage stage = distToPole <= 96.0 ? PolarStage.LETHAL : PolarStage.NONE;
            int duration = 40;
            boolean ambient = true;
            boolean showParticles = false;
            boolean showIcon = false;
            if (stage != PolarStage.LETHAL && stage != PolarStage.HOPELESS) continue;
            player.method_6092(new class_1293(class_1294.field_5909, duration, 2, ambient, showParticles, showIcon));
            player.method_6092(new class_1293(class_1294.field_5911, duration, 1, ambient, showParticles, showIcon));
            player.method_6092(new class_1293(class_1294.field_5919, duration, 0, ambient, showParticles, showIcon));
            int max = 140;
            int target = (int)Math.floor((double)max * 0.85);
            if (target < 1) {
                target = 1;
            }
            player.method_32317(Math.max(player.method_32312(), target));
        }
    }

    private static void applyContinuousBlindness(class_3222 player, boolean inFinalWhiteout) {
        if (!inFinalWhiteout) {
            return;
        }
        class_1293 cur = player.method_6112(class_1294.field_5919);
        if (cur == null || cur.method_5584() < 80) {
            player.method_6092(new class_1293(class_1294.field_5919, 200, 0, true, false, false));
        }
    }

    private static boolean isGlobeOverworld(class_3218 overworld) {
        if (!overworld.method_27983().method_29177().equals((Object)class_1937.field_25179.method_29177())) {
            return false;
        }
        class_2794 generator = overworld.method_14178().method_12129();
        if (!(generator instanceof class_3754)) {
            return false;
        }
        class_3754 noise = (class_3754)generator;
        return noise.method_28548(GLOBE_SETTINGS_KEY) || noise.method_28548(GLOBE_SETTINGS_XSMALL_KEY) || noise.method_28548(GLOBE_SETTINGS_SMALL_KEY) || noise.method_28548(GLOBE_SETTINGS_REGULAR_KEY);
    }

    private static int borderRadiusForGlobeOverworld(class_3218 overworld) {
        class_2794 generator = overworld.method_14178().method_12129();
        if (!(generator instanceof class_3754)) {
            return 7500;
        }
        class_3754 noise = (class_3754)generator;
        if (noise.method_28548(GLOBE_SETTINGS_XSMALL_KEY)) {
            return 3750;
        }
        if (noise.method_28548(GLOBE_SETTINGS_SMALL_KEY)) {
            return 5000;
        }
        return 7500;
    }

    private static void applySpawnChoice(class_3222 player, String id) {
        long seed;
        int targetZ;
        class_2338 spawnPos;
        if (player.method_5752().contains(SPAWN_CHOSEN_TAG)) {
            return;
        }
        class_3218 world = player.method_51469();
        if (!GlobeMod.isGlobeOverworld(world)) {
            return;
        }
        String zoneId = id;
        if (zoneId != null && zoneId.equals("RANDOM")) {
            long seed2 = world.method_8503().method_27728().method_28057().method_28028();
            zoneId = GlobeMod.resolveSpawnZoneId(zoneId, seed2);
            LOGGER.info("Resolved RANDOM spawn zone: player={}, seed={}, chosen={}", new Object[]{player.method_5477().getString(), seed2, zoneId});
        }
        if (zoneId == null) {
            zoneId = "EQUATOR";
        }
        LOGGER.info("Applying spawn choice: player={}, zoneId={}", (Object)player.method_5477().getString(), (Object)zoneId);
        class_2784 border = world.method_8621();
        int radius = (int)Math.round(border.method_11965() * 0.5);
        double t = LatitudeMath.spawnFracForZoneKey(zoneId);
        if (t < 0.0) {
            t = 0.0;
        }
        if (t > 1.0) {
            t = 1.0;
        }
        int z = (int)Math.round((double)radius * t);
        int margin = 320;
        int minZ = -radius + margin;
        int maxZ = radius - margin;
        if (minZ > maxZ) {
            minZ = 0;
            maxZ = 0;
        }
        if (z < minZ) {
            z = minZ;
        }
        if (z > maxZ) {
            z = maxZ;
        }
        if ((spawnPos = GlobeMod.findLandSpawn(world, radius, targetZ = z, seed = world.method_8503().method_27728().method_28057().method_28028())) == null) {
            LOGGER.warn("[Latitude] Could not find land spawn for zone={} targetZ={}. Falling back to (0, seaLevel+2).", (Object)zoneId, (Object)targetZ);
            spawnPos = new class_2338(0, world.method_8615() + 2, targetZ);
        }
        world.method_27873(class_5217.class_12064.method_74895((class_5321)world.method_27983(), (class_2338)spawnPos, (float)0.0f, (float)0.0f));
        player.method_48105(world, (double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5, EnumSet.noneOf(class_2709.class), player.method_36454(), player.method_36455(), true);
        player.method_5780(SPAWN_CHOSEN_TAG);
    }

    private static class_2338 findLandSpawn(class_3218 world, int borderHalf, int targetZ, long seed) {
        int y;
        class_2338 candidate;
        int z;
        int x;
        int i;
        int margin = 320;
        int max = Math.max(0, borderHalf - 320);
        int attemptsXOnly = 96;
        int attemptsWithZJitter = 96;
        int zJitter = 96;
        class_5819 rng = class_5819.method_43049((long)(seed ^ 0x9E3779B97F4A7C15L ^ (long)targetZ));
        class_2338 best = null;
        int bestY = Integer.MIN_VALUE;
        for (i = 0; i < 96; ++i) {
            x = rng.method_39332(-max, max);
            candidate = GlobeMod.tryLandAt(world, x, z = targetZ);
            if (candidate == null || (y = candidate.method_10264()) <= bestY) continue;
            bestY = y;
            best = candidate;
        }
        if (best != null) {
            return best;
        }
        for (i = 0; i < 96; ++i) {
            x = rng.method_39332(-max, max);
            candidate = GlobeMod.tryLandAt(world, x, z = class_3532.method_15340((int)(targetZ + rng.method_39332(-96, 96)), (int)(-max), (int)max));
            if (candidate == null || (y = candidate.method_10264()) <= bestY) continue;
            bestY = y;
            best = candidate;
        }
        return best;
    }

    private static class_2338 tryLandAt(class_3218 world, int x, int z) {
        world.method_8497(x >> 4, z >> 4);
        class_2338 ground = world.method_8598(class_2902.class_2903.field_13203, new class_2338(x, world.method_31607(), z));
        class_2338 spawn = ground.method_10084();
        if (!world.method_8316(spawn).method_15769()) {
            return null;
        }
        if (!world.method_8316(spawn.method_10084()).method_15769()) {
            return null;
        }
        if (!world.method_8320(spawn).method_26215()) {
            return null;
        }
        if (!world.method_8320(spawn.method_10084()).method_26215()) {
            return null;
        }
        if (!world.method_8316(ground).method_15769()) {
            return null;
        }
        return spawn;
    }

    private static String resolveSpawnZoneId(String selected, long seed) {
        if (selected == null || !selected.equals("RANDOM")) {
            return selected;
        }
        String[] options = new String[]{"EQUATOR", "TROPICAL", "SUBTROPICAL", "TEMPERATE", "SUBPOLAR", "POLAR"};
        long mixed = seed ^ 0x9E3779B97F4A7C15L;
        int idx = Math.floorMod(mixed, options.length);
        return options[idx];
    }

    private static boolean hasCompassAnywhere(class_3222 player) {
        if (player == null) {
            return false;
        }
        class_1661 inv = player.method_31548();
        for (int i = 0; i < inv.method_5439(); ++i) {
            if (!GlobeMod.containsCompass(inv.method_5438(i), 0)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsCompass(class_1799 stack, int depth) {
        class_9276 contents;
        if (stack == null || stack.method_7960()) {
            return false;
        }
        if (stack.method_31574(class_1802.field_8251)) {
            return true;
        }
        if (depth >= 6) {
            return false;
        }
        if (stack.method_31574(class_1802.field_27023) && (contents = (class_9276)stack.method_58694(class_9334.field_49650)) != null) {
            for (class_1799 inside : contents.method_57421()) {
                if (!GlobeMod.containsCompass(inside, depth + 1)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        GLOBE_SETTINGS_ID = class_2960.method_60655((String)MOD_ID, (String)"overworld");
        GLOBE_SETTINGS_XSMALL_ID = class_2960.method_60655((String)MOD_ID, (String)"overworld_xsmall");
        GLOBE_SETTINGS_SMALL_ID = class_2960.method_60655((String)MOD_ID, (String)"overworld_small");
        GLOBE_SETTINGS_REGULAR_ID = class_2960.method_60655((String)MOD_ID, (String)"overworld_regular");
        GLOBE_SETTINGS_KEY = class_5321.method_29179((class_5321)class_7924.field_41243, (class_2960)GLOBE_SETTINGS_ID);
        GLOBE_SETTINGS_XSMALL_KEY = class_5321.method_29179((class_5321)class_7924.field_41243, (class_2960)GLOBE_SETTINGS_XSMALL_ID);
        GLOBE_SETTINGS_SMALL_KEY = class_5321.method_29179((class_5321)class_7924.field_41243, (class_2960)GLOBE_SETTINGS_SMALL_ID);
        GLOBE_SETTINGS_REGULAR_KEY = class_5321.method_29179((class_5321)class_7924.field_41243, (class_2960)GLOBE_SETTINGS_REGULAR_ID);
    }

    private static enum PolarStage {
        NONE,
        UNEASE,
        IMPAIR,
        HOSTILE,
        WHITEOUT,
        LETHAL,
        HOPELESS;

    }
}

