/*
 * Decompiled with CFR 0.152.
 */
package com.example.globe;

import com.example.globe.GlobeMod;
import com.example.globe.GlobeNet;
import com.example.globe.client.ClientKeybinds;
import com.example.globe.client.CompassHud;
import com.example.globe.client.CompassHudConfig;
import com.example.globe.client.GlobeClientState;
import com.example.globe.client.GlobeWarningOverlay;
import com.example.globe.client.LatitudeConfig;
import com.example.globe.client.LatitudeSettingsScreen;
import com.example.globe.client.SpawnZoneScreen;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5819;

public class GlobeModClient
implements ClientModInitializer {
    private static boolean pendingSpawnPickerOpen;

    public void onInitializeClient() {
        GlobeNet.registerPayloads();
        GlobeMod.LOGGER.info("Globe client init OK");
        LatitudeConfig.get();
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            GlobeClientState.setGlobeWorld(false);
            pendingSpawnPickerOpen = false;
        });
        ClientPlayNetworking.registerGlobalReceiver(GlobeNet.GlobeStatePayload.ID, (payload, context) -> context.client().execute(() -> {
            GlobeClientState.setGlobeWorld(payload.isGlobe());
            GlobeMod.LOGGER.info("S2C globe state: isGlobe={}", (Object)payload.isGlobe());
        }));
        ClientPlayNetworking.registerGlobalReceiver(GlobeNet.OpenSpawnPickerPayload.ID, (payload, context) -> {
            if (!payload.open()) {
                return;
            }
            context.client().execute(() -> {
                pendingSpawnPickerOpen = true;
                GlobeMod.LOGGER.info("S2C open spawn picker received (pending=true)");
            });
        });
        GlobeWarningOverlay.init();
        CompassHud.init();
        ClientTickEvents.END_CLIENT_TICK.register(GlobeModClient::polarCapClientTick);
        ClientKeybinds.init();
        ClientTickEvents.END_CLIENT_TICK.register(GlobeModClient::clientKeybindTick);
    }

    private static void clientKeybindTick(class_310 client) {
        while (ClientKeybinds.TOGGLE_COMPASS.method_1436()) {
            CompassHudConfig cfg = CompassHudConfig.get();
            cfg.enabled = !cfg.enabled;
            CompassHudConfig.saveCurrent();
        }
        while (ClientKeybinds.OPEN_SETTINGS.method_1436()) {
            if (client.field_1755 == null) {
                client.method_1507((class_437)new LatitudeSettingsScreen(null));
                continue;
            }
            client.method_1507((class_437)new LatitudeSettingsScreen(client.field_1755));
        }
    }

    private static void polarCapClientTick(class_310 client) {
        boolean ewActive;
        if (pendingSpawnPickerOpen && client.field_1724 != null && client.field_1687 != null && client.field_1755 == null) {
            pendingSpawnPickerOpen = false;
            client.method_1507((class_437)new SpawnZoneScreen());
            GlobeMod.LOGGER.info("Opened SpawnZoneScreen");
        }
        if (client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        if (!GlobeClientState.isGlobeWorld()) {
            return;
        }
        if (GlobeClientState.DEBUG_DISABLE_WARNINGS) {
            return;
        }
        GlobeClientState.Eval eval = GlobeClientState.evaluate(client);
        if (!eval.active()) {
            return;
        }
        if (!eval.surfaceOk()) {
            return;
        }
        if (!LatitudeConfig.enableWarningParticles) {
            return;
        }
        GlobeClientState.PolarStage polarStage = GlobeClientState.computePolarStage(client.field_1687, (class_1657)client.field_1724);
        GlobeClientState.EwStormStage ewStage = GlobeClientState.computeEwStormStage(client.field_1687, (class_1657)client.field_1724);
        boolean polarActive = polarStage != GlobeClientState.PolarStage.NONE;
        boolean bl = ewActive = ewStage != GlobeClientState.EwStormStage.NONE;
        if (!polarActive && !ewActive) {
            return;
        }
        if ((client.field_1687.method_75260() & 3L) != 0L) {
            return;
        }
        if (ewActive) {
            GlobeModClient.ewSandstormClientTick(client, ewStage);
        }
        if (polarActive) {
            float intensity = switch (polarStage) {
                case GlobeClientState.PolarStage.WARN_1 -> 0.12f;
                case GlobeClientState.PolarStage.WARN_2 -> 0.22f;
                case GlobeClientState.PolarStage.DANGER -> 0.35f;
                case GlobeClientState.PolarStage.LETHAL -> Math.max(0.4f, GlobeClientState.computePoleWhiteoutFactor(client.field_1724.method_23321()));
                default -> 0.0f;
            };
            intensity = Math.max(0.0f, Math.min(1.0f, intensity));
            if (intensity <= 0.001f) {
                return;
            }
            int count = 2 + (int)Math.round((double)intensity * 26.0);
            if (count > 6) {
                count = 6;
            }
            class_5819 random = client.field_1724.method_59922();
            double px = client.field_1724.method_23317();
            double py = client.field_1724.method_23318();
            double pz = client.field_1724.method_23321();
            for (int i = 0; i < count; ++i) {
                double ox = (random.method_43058() - 0.5) * 10.0;
                double oy = random.method_43058() * 4.0;
                double oz = (random.method_43058() - 0.5) * 10.0;
                double vx = (random.method_43058() - 0.5) * 0.06;
                double vy = -0.02 - random.method_43058() * 0.03;
                double vz = (random.method_43058() - 0.5) * 0.06;
                double vHoriz = (vx + vz) * 0.5;
                client.field_1713.method_3056((class_2394)class_2398.field_28013, px + ox, py + 1.5 + oy, pz + oz, vHoriz, vy, vz);
            }
        }
    }

    private static void ewSandstormClientTick(class_310 client, GlobeClientState.EwStormStage stage) {
        int base;
        switch (stage) {
            case LEVEL_1: {
                int n = 2;
                break;
            }
            case LEVEL_2: {
                int n = 6;
                break;
            }
            default: {
                int n = base = 0;
            }
        }
        if (base <= 0) {
            return;
        }
        class_5819 random = client.field_1724.method_59922();
        double px = client.field_1724.method_23317();
        double py = client.field_1724.method_23318();
        double pz = client.field_1724.method_23321();
        double vx = client.field_1724.method_23317() >= 0.0 ? -0.1 : 0.1;
        int sandCount = base;
        int hazeCount = Math.max(1, base / 2);
        GlobeModClient.spawnCloudRing(client, (class_2394)class_2398.field_22247, sandCount, random, px, py, pz, vx);
        GlobeModClient.spawnCloudRing(client, (class_2394)class_2398.field_11204, hazeCount, random, px, py, pz, vx * 0.6);
    }

    private static void spawnCloudRing(class_310 client, class_2394 particle, int count, class_5819 random, double px, double py, double pz, double vx) {
        for (int i = 0; i < count; ++i) {
            double ox = (random.method_43058() - 0.5) * 16.0;
            double oy = 1.0 + random.method_43058() * 6.0;
            double oz = (random.method_43058() - 0.5) * 16.0;
            client.field_1713.method_3056(particle, px + ox, py + oy, pz + oz, vx, 0.01, 0.0);
        }
    }

    private static boolean isWarningParticleActive(class_310 client) {
        if (client.field_1724 == null || client.field_1687 == null) {
            return false;
        }
        GlobeClientState.PolarStage polarStage = GlobeClientState.computePolarStage(client.field_1687, (class_1657)client.field_1724);
        GlobeClientState.EwStormStage ewStage = GlobeClientState.computeEwStormStage(client.field_1687, (class_1657)client.field_1724);
        return polarStage != GlobeClientState.PolarStage.NONE || ewStage != GlobeClientState.EwStormStage.NONE;
    }
}

