/*
 * Decompiled with CFR 0.152.
 */
package com.example.globe;

import net.minecraft.class_2338;
import net.minecraft.class_3532;

public final class GlobeRegions {
    public static final int HALF_SIZE = 7500;
    public static final int POLAR_WHITEOUT_COLOR_START = 14000;
    public static final int POLAR_UNEASE_START = 14000;
    public static final int POLAR_EFFECTS_1 = 14100;
    public static final int POLAR_EFFECTS_2 = 14300;
    public static final int POLAR_WHITEOUT_START = 14500;
    public static final int POLAR_LETHAL_START = 14650;
    public static final int POLAR_HOPELESS_START = 14800;
    public static final int BORDER = 7500;
    public static final int POLAR_FOG_VISUAL_START = 12000;
    public static final int STORM_WARN_START = 12800;
    public static final int STORM_START = 13000;
    public static final int STORM_SEVERE_START = 14500;
    public static final int STORM_OPAQUE_START = 14900;
    public static final int STORM_OVERLAY_WARN_START = 14400;
    public static final int STORM_OVERLAY_DANGER_START = 14550;
    public static final int STORM_OVERLAY_EDGE_START = 14650;
    public static final int POLAR_FOG_START = 14500;
    public static final int POLAR_DEBUFF_START = 14100;
    public static final int POLAR_DANGER_START = 14800;
    public static final int POLAR_DEADLY_WARN_START = 14650;
    public static final int POLAR_CAP_START = 14500;
    public static final int POOR_CONDITIONS_WARN_START = 14000;
    public static final int POOR_CONDITIONS_EFFECTS_START = 14100;
    public static final int STORM_FOG_START = 13000;
    public static final int STORM_DEBUFF_START = 13000;

    private GlobeRegions() {
    }

    public static double t(int value, int start, int end) {
        if (value <= start) {
            return 0.0;
        }
        if (value >= end) {
            return 1.0;
        }
        return (double)(value - start) / (double)(end - start);
    }

    public static float polarFogSeverity(class_2338 pos) {
        return GlobeRegions.ramp(Math.abs(pos.method_10260()), 14500, 7500);
    }

    public static float polarDebuffSeverity(class_2338 pos) {
        return GlobeRegions.ramp(Math.abs(pos.method_10260()), 14100, 7500);
    }

    public static float polarWhiteoutSeverity(class_2338 pos) {
        return GlobeRegions.ramp(Math.abs(pos.method_10260()), 14500, 7500);
    }

    public static float polarDangerSeverity(class_2338 pos) {
        return GlobeRegions.ramp(Math.abs(pos.method_10260()), 14650, 7500);
    }

    public static float stormFogSeverity(class_2338 pos) {
        return GlobeRegions.ramp(Math.abs(pos.method_10263()), 13000, 7500);
    }

    public static float stormDebuffSeverity(class_2338 pos) {
        return GlobeRegions.ramp(Math.abs(pos.method_10263()), 13000, 7500);
    }

    public static float stormSevereSeverity(class_2338 pos) {
        return GlobeRegions.ramp(Math.abs(pos.method_10263()), 14500, 7500);
    }

    public static float stormOpaqueSeverity(class_2338 pos) {
        return GlobeRegions.ramp(Math.abs(pos.method_10263()), 14900, 7500);
    }

    private static float ramp(int v, int start, int end) {
        return class_3532.method_15363((float)((float)(v - start) / (float)(end - start)), (float)0.0f, (float)1.0f);
    }

    public static boolean nearPolarWarning(class_2338 pos) {
        int z = Math.abs(pos.method_10260());
        return z >= 14000 && z < 14100;
    }

    public static boolean nearWhiteoutWarning(class_2338 pos) {
        int z = Math.abs(pos.method_10260());
        return z >= 14244 && z < 14500;
    }

    public static boolean nearStormWarning(class_2338 pos) {
        int x = Math.abs(pos.method_10263());
        return x >= 12800 && x < 13000;
    }
}

