/*
 * Decompiled with CFR 0.152.
 */
package com.example.globe;

import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3481;

public final class PolarCapScrubber {
    private final int borderRadius;
    private final int poleBandStartAbsZ;
    private final LongSet scrubbedChunks = new LongOpenHashSet();
    private final Long2IntMap chunkProgress = new Long2IntOpenHashMap();
    private static final int COLUMNS_PER_TICK = 16;

    public PolarCapScrubber(int borderRadius, int poleBandStartAbsZ) {
        this.borderRadius = borderRadius;
        this.poleBandStartAbsZ = poleBandStartAbsZ;
    }

    public void tick(class_3218 world) {
        for (class_3222 player : world.method_18456()) {
            if (Math.abs(player.method_23321()) < (double)this.poleBandStartAbsZ) continue;
            class_1923 center = new class_1923(player.method_24515());
            boolean didScrub = false;
            for (int dz = -1; dz <= 1 && !didScrub; ++dz) {
                for (int dx = -1; dx <= 1 && !didScrub; ++dx) {
                    int approxChunkCenterZ;
                    int cx = center.field_9181 + dx;
                    int cz = center.field_9180 + dz;
                    long key = PolarCapScrubber.chunkKey(cx, cz);
                    if (this.scrubbedChunks.contains(key) || Math.abs(approxChunkCenterZ = (cz << 4) + 8) < this.poleBandStartAbsZ) continue;
                    class_2818 chunk = world.method_8497(cx, cz);
                    this.scrubChunkSurface(world, chunk);
                    didScrub = true;
                }
            }
        }
    }

    private void scrubChunkSurface(class_3218 world, class_2818 chunk) {
        class_1923 pos = chunk.method_12004();
        int baseX = pos.method_8326();
        int baseZ = pos.method_8328();
        long key = PolarCapScrubber.chunkKey(pos.field_9181, pos.field_9180);
        int startIndex = this.chunkProgress.getOrDefault(key, 0);
        int endIndex = Math.min(256, startIndex + 16);
        for (int i = startIndex; i < endIndex; ++i) {
            int surfaceY;
            int localX = i & 0xF;
            int localZ = i >> 4 & 0xF;
            int x = baseX + localX;
            int z = baseZ + localZ;
            if (Math.abs(z) < this.poleBandStartAbsZ || Math.abs(z) > this.borderRadius + 32 || (surfaceY = world.method_8624(class_2902.class_2903.field_13203, x, z) - 1) <= world.method_31607()) continue;
            int maxY = surfaceY + 24;
            for (int y = surfaceY; y <= maxY; ++y) {
                class_2338 p = new class_2338(x, y, z);
                class_2680 s = world.method_8320(p);
                if (!this.isVegetation(s)) continue;
                world.method_8652(p, class_2246.field_10124.method_9564(), 2);
            }
            class_2338 surfacePos = new class_2338(x, surfaceY, z);
            class_2680 surfaceState = world.method_8320(surfacePos);
            if (surfaceState.method_26204() == class_2246.field_10382) {
                world.method_8652(surfacePos, class_2246.field_10295.method_9564(), 2);
                continue;
            }
            class_2680 newSurface = this.pickPolarSurface(x, z);
            if (surfaceState.method_26204() == newSurface.method_26204()) continue;
            world.method_8652(surfacePos, newSurface, 2);
        }
        if (endIndex >= 256) {
            this.chunkProgress.remove(key);
            this.scrubbedChunks.add(key);
        } else {
            this.chunkProgress.put(key, endIndex);
        }
    }

    private class_2680 pickPolarSurface(int x, int z) {
        long h = (long)x * 341873128712L ^ (long)z * 132897987541L;
        int r = (int)(h ^ h >>> 32);
        int m = r & 0x3FF;
        if (m < 716) {
            return class_2246.field_10491.method_9564();
        }
        if (m < 921) {
            return class_2246.field_10340.method_9564();
        }
        return class_2246.field_10225.method_9564();
    }

    private boolean isVegetation(class_2680 state) {
        return state.method_26164(class_3481.field_15503) || state.method_26164(class_3481.field_15475) || state.method_26164(class_3481.field_15462) || state.method_26164(class_3481.field_20339) || state.method_26164(class_3481.field_20341) || state.method_26204() == class_2246.field_10479 || state.method_26204() == class_2246.field_10214 || state.method_26204() == class_2246.field_10112 || state.method_26204() == class_2246.field_10313 || state.method_26204() == class_2246.field_10597;
    }

    private static long chunkKey(int cx, int cz) {
        return ((long)cx & 0xFFFFFFFFL) << 32 | (long)cz & 0xFFFFFFFFL;
    }
}

