/*
 * Decompiled with CFR 0.152.
 */
package com.example.globe.client;

import com.example.globe.client.CompassHudConfig;
import com.example.globe.client.LatitudeMath;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_9276;
import net.minecraft.class_9334;
import net.minecraft.class_9779;
import org.joml.Matrix3x2fStack;

public final class CompassHud {
    private static long lastCheckWorldTime = Long.MIN_VALUE;
    private static boolean cachedHasCompass = false;

    private CompassHud() {
    }

    public static void init() {
    }

    public static void render(class_332 ctx, class_9779 tickCounter) {
        class_310 client = class_310.method_1551();
        if (client == null || client.method_22683() == null) {
            return;
        }
        CompassHud.renderInternal(ctx, client.method_22683().method_4486(), client.method_22683().method_4502(), false);
    }

    public static void render(class_332 ctx, int screenW, int screenH) {
        CompassHud.renderInternal(ctx, screenW, screenH, false);
    }

    public static void renderAdjustPreview(class_332 ctx, int screenW, int screenH) {
        CompassHud.renderInternal(ctx, screenW, screenH, true);
    }

    private static void renderInternal(class_332 ctx, int screenW, int screenH, boolean forceVisible) {
        Object hudText;
        String directionText;
        class_310 client = class_310.method_1551();
        if (client == null || client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        if (!forceVisible && client.field_1755 != null) {
            return;
        }
        CompassHudConfig cfg = CompassHudConfig.get();
        if (!forceVisible && !cfg.enabled) {
            return;
        }
        boolean isHoldingCompass = client.field_1724.method_6047().method_31574(class_1802.field_8251) || client.field_1724.method_6079().method_31574(class_1802.field_8251);
        long t = client.field_1687.method_75260();
        if (t != lastCheckWorldTime) {
            lastCheckWorldTime = t;
            cachedHasCompass = CompassHud.hasCompassAnywhere((class_1657)client.field_1724);
        }
        boolean hasCompassAnywhere = cachedHasCompass;
        if (!forceVisible) {
            switch (cfg.showMode) {
                case ALWAYS: {
                    break;
                }
                case COMPASS_PRESENT: {
                    if (hasCompassAnywhere) break;
                    return;
                }
                case HOLDING_COMPASS: {
                    if (isHoldingCompass) break;
                    return;
                }
            }
        }
        switch (cfg.directionMode) {
            default: {
                throw new MatchException(null, null);
            }
            case CARDINAL_8: {
                String string = CompassHud.direction8(client.field_1724.method_36454());
                break;
            }
            case CARDINAL_4: {
                String string = CompassHud.direction4(client.field_1724.method_36454());
                break;
            }
            case DEGREES: {
                String string = directionText = CompassHud.degrees(client.field_1724.method_36454());
            }
        }
        if (Boolean.TRUE.equals(cfg.showLatitude)) {
            String latText = LatitudeMath.formatLatitudeDeg(client.field_1724.method_23321(), client.field_1687.method_8621());
            String sep = cfg.compactHud ? " " : " \u00b7 ";
            hudText = directionText + sep + latText;
        } else {
            hudText = directionText;
        }
        String[] lines = new String[]{hudText};
        HudBounds b = CompassHud.computeBounds(screenW, screenH, client, cfg, lines);
        CompassHud.renderAt(ctx, client, cfg, lines, b.x, b.y, forceVisible);
    }

    public static HudBounds computeBounds(class_310 client, CompassHudConfig cfg) {
        return CompassHud.computeBounds(client, cfg, CompassHud.sampleLines(cfg));
    }

    public static HudPoint computeBasePosition(class_310 client, CompassHudConfig cfg) {
        int y;
        int x;
        String[] lines = CompassHud.sampleLines(cfg);
        int screenW = client.method_22683().method_4486();
        int screenH = client.method_22683().method_4502();
        int pad = cfg.padding;
        int textW = CompassHud.maxLineWidth(client, lines);
        Objects.requireNonNull(client.field_1772);
        int textH = 9 * lines.length;
        int boxW = textW + pad * 2;
        int boxH = textH + pad * 2;
        float s = cfg.scale;
        int scaledBoxW = (int)Math.ceil((float)boxW * s);
        int scaledBoxH = (int)Math.ceil((float)boxH * s);
        if (cfg.attachToHotbarCompass && client.field_1724 != null) {
            int slotIndex = CompassHud.findHotbarCompassSlot((class_1657)client.field_1724);
            if (slotIndex >= 0) {
                int hotbarLeft = screenW / 2 - 91;
                int slotX = hotbarLeft + slotIndex * 20 + 2;
                int slotY = screenH - 22 + 3;
                x = slotX;
                y = slotY - (scaledBoxH + 6);
            } else {
                x = CompassHud.anchoredX(cfg, screenW, scaledBoxW);
                y = CompassHud.anchoredY(cfg, screenH, scaledBoxH);
            }
        } else {
            x = CompassHud.anchoredX(cfg, screenW, scaledBoxW);
            y = CompassHud.anchoredY(cfg, screenH, scaledBoxH);
        }
        x = CompassHud.clamp(x, 0, Math.max(0, screenW - scaledBoxW));
        y = CompassHud.clamp(y, 0, Math.max(0, screenH - scaledBoxH));
        return new HudPoint(x, y);
    }

    public static HudBounds computeBounds(class_310 client, CompassHudConfig cfg, class_2561 text) {
        int screenW = client.method_22683().method_4486();
        int screenH = client.method_22683().method_4502();
        return CompassHud.computeBounds(screenW, screenH, client, cfg, new String[]{text.getString()});
    }

    public static HudBounds computeBounds(class_310 client, CompassHudConfig cfg, String[] lines) {
        int screenW = client.method_22683().method_4486();
        int screenH = client.method_22683().method_4502();
        return CompassHud.computeBounds(screenW, screenH, client, cfg, lines);
    }

    private static HudBounds computeBounds(int screenW, int screenH, class_310 client, CompassHudConfig cfg, String[] lines) {
        int y;
        int x;
        int pad = cfg.padding;
        int textW = CompassHud.maxLineWidth(client, lines);
        Objects.requireNonNull(client.field_1772);
        int textH = 9 * lines.length;
        int boxW = textW + pad * 2;
        int boxH = textH + pad * 2;
        float s = cfg.scale;
        int scaledBoxW = (int)Math.ceil((float)boxW * s);
        int scaledBoxH = (int)Math.ceil((float)boxH * s);
        if (cfg.attachToHotbarCompass && client.field_1724 != null) {
            int slotIndex = CompassHud.findHotbarCompassSlot((class_1657)client.field_1724);
            if (slotIndex >= 0) {
                int hotbarLeft = screenW / 2 - 91;
                int slotX = hotbarLeft + slotIndex * 20 + 2;
                int slotY = screenH - 22 + 3;
                x = slotX;
                y = slotY - (scaledBoxH + 6);
            } else {
                x = CompassHud.anchoredX(cfg, screenW, scaledBoxW);
                y = CompassHud.anchoredY(cfg, screenH, scaledBoxH);
            }
        } else {
            x = CompassHud.anchoredX(cfg, screenW, scaledBoxW);
            y = CompassHud.anchoredY(cfg, screenH, scaledBoxH);
        }
        x += cfg.offsetX;
        y += cfg.offsetY;
        x = CompassHud.clamp(x, 0, Math.max(0, screenW - scaledBoxW));
        y = CompassHud.clamp(y, 0, Math.max(0, screenH - scaledBoxH));
        return new HudBounds(x, y, scaledBoxW, scaledBoxH);
    }

    public static void renderPreview(class_332 ctx, class_310 client, CompassHudConfig cfg, int x, int y) {
        CompassHud.renderAt(ctx, client, cfg, CompassHud.sampleLines(cfg), x, y, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void renderAt(class_332 ctx, class_310 client, CompassHudConfig cfg, String[] lines, int x, int y, boolean isPreview) {
        int pad = cfg.padding;
        int textW = CompassHud.maxLineWidth(client, lines);
        Objects.requireNonNull(client.field_1772);
        int textH = 9 * lines.length;
        int boxW = textW + pad * 2;
        int boxH = textH + pad * 2;
        float s = cfg.scale;
        Matrix3x2fStack m = ctx.method_51448();
        m.pushMatrix();
        try {
            m.translate((float)x, (float)y);
            m.scale(s, s);
            if (cfg.showBackground || isPreview) {
                int bg;
                if (cfg.showBackground) {
                    bg = cfg.backgroundArgb();
                } else {
                    int a = 160;
                    bg = a << 24 | cfg.backgroundRgb & 0xFFFFFF;
                }
                ctx.method_25294(0, 0, boxW, boxH, bg);
                if (isPreview) {
                    int border = 0x55FFFFFF;
                    ctx.method_25294(0, 0, boxW, 1, border);
                    ctx.method_25294(0, boxH - 1, boxW, boxH, border);
                    ctx.method_25294(0, 0, 1, boxH, border);
                    ctx.method_25294(boxW - 1, 0, boxW, boxH, border);
                }
            }
            int color = cfg.textArgb();
            int tx = pad;
            int ty = pad;
            for (int i = 0; i < lines.length; ++i) {
                Objects.requireNonNull(client.field_1772);
                int lineY = ty + i * 9;
                class_5250 line = class_2561.method_43470((String)lines[i]);
                if (cfg.shadow) {
                    ctx.method_27535(client.field_1772, (class_2561)line, tx, lineY, color);
                    continue;
                }
                ctx.method_51439(client.field_1772, (class_2561)line, tx, lineY, color, false);
            }
        }
        finally {
            m.popMatrix();
        }
    }

    private static String[] sampleLines(CompassHudConfig cfg) {
        String dir;
        switch (cfg.directionMode) {
            default: {
                throw new MatchException(null, null);
            }
            case CARDINAL_8: {
                String string = "NW";
                break;
            }
            case CARDINAL_4: {
                String string = "W";
                break;
            }
            case DEGREES: {
                String string = dir = "360\u00b0";
            }
        }
        if (Boolean.TRUE.equals(cfg.showLatitude)) {
            String sep = cfg.compactHud ? " " : " \u00b7 ";
            return new String[]{dir + sep + "1\u00b0S"};
        }
        return new String[]{dir};
    }

    private static int maxLineWidth(class_310 client, String[] lines) {
        int w = 0;
        for (String s : lines) {
            w = Math.max(w, client.field_1772.method_1727(s));
        }
        return w;
    }

    private static int clamp(int v, int lo, int hi) {
        return Math.max(lo, Math.min(hi, v));
    }

    private static boolean hasCompassAnywhere(class_1657 player) {
        class_1661 inv = player.method_31548();
        for (int i = 0; i < inv.method_5439(); ++i) {
            if (!CompassHud.containsCompass(inv.method_5438(i), 0)) continue;
            return true;
        }
        return CompassHud.containsCompass(player.method_6079(), 0);
    }

    private static boolean containsCompass(class_1799 stack, int depth) {
        class_9276 contents;
        if (stack == null || stack.method_7960()) {
            return false;
        }
        if (stack.method_31574(class_1802.field_8251)) {
            return true;
        }
        if (depth >= 6) {
            return false;
        }
        if (stack.method_31574(class_1802.field_27023) && (contents = (class_9276)stack.method_58694(class_9334.field_49650)) != null) {
            for (class_1799 inside : contents.method_57421()) {
                if (!CompassHud.containsCompass(inside, depth + 1)) continue;
                return true;
            }
        }
        return false;
    }

    private static int findHotbarCompassSlot(class_1657 player) {
        class_1661 inv = player.method_31548();
        for (int i = 0; i < 9 && i < inv.method_5439(); ++i) {
            if (!CompassHud.containsCompass(inv.method_5438(i), 0)) continue;
            return i;
        }
        return -1;
    }

    private static int anchoredX(CompassHudConfig cfg, int screenW, int scaledBoxW) {
        return switch (cfg.hAnchor) {
            default -> throw new MatchException(null, null);
            case CompassHudConfig.HAnchor.LEFT -> 4;
            case CompassHudConfig.HAnchor.CENTER -> (screenW - scaledBoxW) / 2;
            case CompassHudConfig.HAnchor.RIGHT -> screenW - scaledBoxW - 4;
        };
    }

    private static int anchoredY(CompassHudConfig cfg, int screenH, int scaledBoxH) {
        return switch (cfg.vAnchor) {
            default -> throw new MatchException(null, null);
            case CompassHudConfig.VAnchor.TOP -> 4;
            case CompassHudConfig.VAnchor.CENTER -> (screenH - scaledBoxH) / 2;
            case CompassHudConfig.VAnchor.BOTTOM -> screenH - scaledBoxH - 4;
        };
    }

    private static String direction4(float yawDegrees) {
        float yaw = class_3532.method_15393((float)yawDegrees);
        int idx = class_3532.method_15375((float)((yaw + 180.0f + 45.0f) / 90.0f)) & 3;
        return switch (idx) {
            case 0 -> "N";
            case 1 -> "E";
            case 2 -> "S";
            default -> "W";
        };
    }

    private static String degrees(float yawDegrees) {
        float deg = yawDegrees % 360.0f;
        if (deg < 0.0f) {
            deg += 360.0f;
        }
        return class_3532.method_15375((float)deg) + "\u00b0";
    }

    private static String direction8(float yawDegrees) {
        float yaw = class_3532.method_15393((float)yawDegrees);
        int idx = class_3532.method_15375((float)((yaw + 180.0f + 22.5f) / 45.0f)) & 7;
        return switch (idx) {
            case 0 -> "N";
            case 1 -> "NE";
            case 2 -> "E";
            case 3 -> "SE";
            case 4 -> "S";
            case 5 -> "SW";
            case 6 -> "W";
            default -> "NW";
        };
    }

    public record HudBounds(int x, int y, int w, int h) {
        public boolean contains(double mx, double my) {
            return mx >= (double)this.x && mx < (double)(this.x + this.w) && my >= (double)this.y && my < (double)(this.y + this.h);
        }
    }

    public record HudPoint(int x, int y) {
    }
}

