/*
 * Decompiled with CFR 0.152.
 */
package com.example.globe.client;

import com.example.globe.GlobeMod;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;

public final class CompassHudConfig {
    public boolean enabled = true;
    public ShowMode showMode = ShowMode.COMPASS_PRESENT;
    public DirectionMode directionMode = DirectionMode.CARDINAL_8;
    public HAnchor hAnchor = HAnchor.CENTER;
    public VAnchor vAnchor = VAnchor.TOP;
    public int offsetX = 0;
    public int offsetY = 0;
    public float scale = 1.0f;
    public int padding = 3;
    public boolean showBackground = true;
    public int backgroundRgb = 0;
    public int backgroundAlpha = 64;
    public int textRgb = 0xFFFFFF;
    public int textAlpha = 255;
    public boolean shadow = true;
    public Boolean showLatitude = true;
    public Integer latitudeDecimals = 0;
    public boolean compactHud = false;
    public boolean attachToHotbarCompass = false;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path PATH = FabricLoader.getInstance().getConfigDir().resolve("globe_compass_hud.json");
    private static CompassHudConfig INSTANCE;

    private CompassHudConfig() {
    }

    public static CompassHudConfig get() {
        if (INSTANCE == null) {
            INSTANCE = CompassHudConfig.load();
        }
        return INSTANCE;
    }

    public static void reload() {
        INSTANCE = CompassHudConfig.load();
    }

    public static void saveCurrent() {
        CompassHudConfig.save(CompassHudConfig.get());
    }

    public static void setEnabledAndSave(boolean value) {
        CompassHudConfig.get().enabled = value;
        CompassHudConfig.saveCurrent();
    }

    public int textArgb() {
        return (this.textAlpha & 0xFF) << 24 | this.textRgb & 0xFFFFFF;
    }

    public int backgroundArgb() {
        return (this.backgroundAlpha & 0xFF) << 24 | this.backgroundRgb & 0xFFFFFF;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static CompassHudConfig load() {
        block9: {
            try {
                if (!Files.exists(PATH, new LinkOption[0])) break block9;
                try (BufferedReader r = Files.newBufferedReader(PATH);){
                    CompassHudConfig cfg = (CompassHudConfig)GSON.fromJson((Reader)r, CompassHudConfig.class);
                    if (cfg != null) {
                        cfg.sanitize();
                        CompassHudConfig compassHudConfig = cfg;
                        return compassHudConfig;
                    }
                }
            }
            catch (Exception e) {
                GlobeMod.LOGGER.warn("Failed to read compass HUD config; using defaults", (Throwable)e);
            }
        }
        CompassHudConfig fresh = new CompassHudConfig();
        CompassHudConfig.save(fresh);
        return fresh;
    }

    private static void save(CompassHudConfig cfg) {
        try {
            Files.createDirectories(PATH.getParent(), new FileAttribute[0]);
            try (BufferedWriter w = Files.newBufferedWriter(PATH, new OpenOption[0]);){
                GSON.toJson((Object)cfg, (Appendable)w);
            }
        }
        catch (Exception e) {
            GlobeMod.LOGGER.warn("Failed to write compass HUD config", (Throwable)e);
        }
    }

    private void sanitize() {
        if (this.showMode == null) {
            this.showMode = ShowMode.COMPASS_PRESENT;
        }
        if (this.directionMode == null) {
            this.directionMode = DirectionMode.CARDINAL_8;
        }
        if (this.hAnchor == null) {
            this.hAnchor = HAnchor.CENTER;
        }
        if (this.vAnchor == null) {
            this.vAnchor = VAnchor.TOP;
        }
        if (this.showLatitude == null) {
            this.showLatitude = true;
        }
        if (this.latitudeDecimals == null) {
            this.latitudeDecimals = 0;
        }
        if (this.latitudeDecimals < 0) {
            this.latitudeDecimals = 0;
        }
        if (this.latitudeDecimals > 3) {
            this.latitudeDecimals = 3;
        }
        if (this.scale < 0.25f) {
            this.scale = 0.25f;
        }
        if (this.scale > 4.0f) {
            this.scale = 4.0f;
        }
        if (this.padding < 0) {
            this.padding = 0;
        }
        if (this.backgroundAlpha < 0) {
            this.backgroundAlpha = 0;
        }
        if (this.backgroundAlpha > 255) {
            this.backgroundAlpha = 255;
        }
        if (this.textAlpha < 0) {
            this.textAlpha = 0;
        }
        if (this.textAlpha > 255) {
            this.textAlpha = 255;
        }
    }

    public static enum ShowMode {
        ALWAYS,
        COMPASS_PRESENT,
        HOLDING_COMPASS;

    }

    public static enum DirectionMode {
        CARDINAL_4,
        CARDINAL_8,
        DEGREES;

    }

    public static enum HAnchor {
        LEFT,
        CENTER,
        RIGHT;

    }

    public static enum VAnchor {
        TOP,
        CENTER,
        BOTTOM;

    }
}

