/*
 * Decompiled with CFR 0.152.
 */
package com.example.globe.client;

import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2784;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_746;

public final class GlobeClientState {
    public static boolean DEBUG_DISABLE_WARNINGS = false;
    private static boolean globeWorld;
    private static final int POLE_WARN_2_DISTANCE_BLOCKS = 192;
    private static final int POLE_DANGER_DISTANCE_BLOCKS = 128;
    private static final int EW_TEXT_DANGER_DISTANCE_BLOCKS = 64;
    private static long cachedEvalWorldTime;
    private static Eval cachedEval;

    private static double axisDistanceInsideBorder(class_2784 border, double coord, boolean isX) {
        double center = isX ? border.method_11964() : border.method_11980();
        double radius = border.method_11965() * 0.5;
        return radius - Math.abs(coord - center);
    }

    private static int borderRadiusBlocks(class_638 world) {
        return (int)Math.round(world.method_8621().method_11965() / 2.0);
    }

    private static PolarStage polarStageForDist(int distToZBorder) {
        if (distToZBorder <= 96) {
            return PolarStage.LETHAL;
        }
        if (distToZBorder <= 128) {
            return PolarStage.DANGER;
        }
        if (distToZBorder <= 192) {
            return PolarStage.WARN_2;
        }
        if (distToZBorder <= 256) {
            return PolarStage.WARN_1;
        }
        return PolarStage.NONE;
    }

    private static EwStormStage ewStageForDist(int distToXBorder) {
        if (distToXBorder <= 96) {
            return EwStormStage.LEVEL_2;
        }
        if (distToXBorder <= 256) {
            return EwStormStage.LEVEL_1;
        }
        return EwStormStage.NONE;
    }

    private static int polarRank(PolarStage stage) {
        return switch (stage.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> 0;
            case 1 -> 1;
            case 2 -> 2;
            case 3 -> 3;
            case 4 -> 4;
        };
    }

    private static int ewRank(EwStormStage stage) {
        return switch (stage.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> 0;
            case 1 -> 1;
            case 2 -> 2;
        };
    }

    public static WarningState computeWarningState(class_638 world, class_1657 player) {
        boolean ewTextDanger;
        if (DEBUG_DISABLE_WARNINGS) {
            return WarningState.NONE;
        }
        class_2784 border = world.method_8621();
        double distToXBorder = GlobeClientState.axisDistanceInsideBorder(border, player.method_23317(), true);
        double distToZBorder = GlobeClientState.axisDistanceInsideBorder(border, player.method_23321(), false);
        int distToX = (int)Math.floor(distToXBorder);
        int distToZ = (int)Math.floor(distToZBorder);
        PolarStage polar = GlobeClientState.polarStageForDist(distToZ);
        EwStormStage ewVisual = GlobeClientState.ewStageForDist(distToX);
        boolean ewTextWarn = distToX <= 256;
        boolean bl = ewTextDanger = distToX <= 64;
        EwStormStage ewTextStage = ewTextDanger ? EwStormStage.LEVEL_2 : (ewTextWarn ? EwStormStage.LEVEL_1 : EwStormStage.NONE);
        int pr = GlobeClientState.polarRank(polar);
        int er = GlobeClientState.ewRank(ewTextStage);
        if (pr <= 0 && er <= 0) {
            return WarningState.NONE;
        }
        if (polar == PolarStage.LETHAL) {
            return new WarningState(WarningType.POLAR, polar, pr);
        }
        if (ewTextDanger) {
            return new WarningState(WarningType.STORM, ewTextStage, er);
        }
        if (polar != PolarStage.NONE) {
            return new WarningState(WarningType.POLAR, polar, pr);
        }
        if (ewVisual != EwStormStage.NONE && ewTextStage == EwStormStage.NONE) {
            ewTextStage = EwStormStage.LEVEL_1;
            er = GlobeClientState.ewRank(ewTextStage);
        }
        return new WarningState(WarningType.STORM, ewTextStage, er);
    }

    public static PolarStage computePolarStage(class_638 world, class_1657 player) {
        class_2784 border = world.method_8621();
        double distToZBorder = GlobeClientState.axisDistanceInsideBorder(border, player.method_23321(), false);
        int distToZ = (int)Math.floor(distToZBorder);
        return GlobeClientState.polarStageForDist(distToZ);
    }

    public static EwStormStage computeEwStormStage(class_638 world, class_1657 player) {
        class_2784 border = world.method_8621();
        double distToXBorder = GlobeClientState.axisDistanceInsideBorder(border, player.method_23317(), true);
        int distToX = (int)Math.floor(distToXBorder);
        return GlobeClientState.ewStageForDist(distToX);
    }

    public static float computeEwFogEnd(double x) {
        float end;
        if (DEBUG_DISABLE_WARNINGS) {
            return -1.0f;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1687 == null) {
            return -1.0f;
        }
        class_2784 border = client.field_1687.method_8621();
        double distToXBorder = GlobeClientState.axisDistanceInsideBorder(border, x, true);
        int warn = 256;
        int danger = 96;
        int blackout = 20;
        if (distToXBorder > (double)warn) {
            return -1.0f;
        }
        if (distToXBorder <= (double)blackout) {
            return 20.0f;
        }
        if (distToXBorder <= (double)danger) {
            float end2;
            float t = (float)(((double)danger - distToXBorder) / (double)(danger - blackout));
            if (t < 0.0f) {
                t = 0.0f;
            }
            if (t > 1.0f) {
                t = 1.0f;
            }
            if ((end2 = 40.0f - t * 20.0f) < 20.0f) {
                end2 = 20.0f;
            }
            return end2;
        }
        float t = (float)(((double)warn - distToXBorder) / (double)(warn - danger));
        if (t < 0.0f) {
            t = 0.0f;
        }
        if (t > 1.0f) {
            t = 1.0f;
        }
        if ((end = 160.0f - t * 120.0f) < 40.0f) {
            end = 40.0f;
        }
        return end;
    }

    private static float polarWhiteoutIntensity(class_638 world, class_1657 player) {
        class_2784 border = world.method_8621();
        double distToZBorder = GlobeClientState.axisDistanceInsideBorder(border, player.method_23321(), false);
        if (distToZBorder > 256.0) {
            return 0.0f;
        }
        if (distToZBorder <= 0.0) {
            return 1.0f;
        }
        double warn = 256.0;
        double t = (warn - distToZBorder) / warn;
        if (t < 0.0) {
            t = 0.0;
        }
        if (t > 1.0) {
            t = 1.0;
        }
        return (float)t;
    }

    private GlobeClientState() {
    }

    public static boolean isGlobeWorld() {
        return globeWorld;
    }

    public static void setGlobeWorld(boolean value) {
        if (globeWorld != value) {
            globeWorld = value;
            cachedEvalWorldTime = Long.MIN_VALUE;
            cachedEval = null;
        }
    }

    public static Eval evaluate(class_310 client) {
        boolean stormCritical;
        if (client.field_1724 == null || client.field_1687 == null) {
            cachedEvalWorldTime = Long.MIN_VALUE;
            cachedEval = null;
            return Eval.INACTIVE;
        }
        long worldTime = client.field_1687.method_75260();
        if (cachedEval != null && cachedEvalWorldTime == worldTime) {
            return cachedEval;
        }
        cachedEvalWorldTime = worldTime;
        class_2338 pos = client.field_1724.method_24515();
        int absX = (int)Math.floor(Math.abs(client.field_1724.method_23317()));
        int absZ = (int)Math.floor(Math.abs(client.field_1724.method_23321()));
        boolean surfaceOk = GlobeClientState.isSurfaceOk(client, pos);
        boolean active = globeWorld;
        if (!active) {
            double size = client.field_1687.method_8621().method_11965();
            boolean bl = active = Math.abs(size - 7500.0) < 1.0 || Math.abs(size - 10000.0) < 1.0 || Math.abs(size - 15000.0) < 1.0;
        }
        if (!globeWorld && !client.field_1687.method_27983().method_29177().equals((Object)class_1937.field_25179.method_29177())) {
            active = false;
        }
        if (!active) {
            cachedEval = new Eval(false, surfaceOk, absX, absZ, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, false, false);
            return cachedEval;
        }
        class_638 world = client.field_1687;
        class_746 player = client.field_1724;
        if (world == null || player == null) {
            return Eval.INACTIVE;
        }
        class_2784 border = world.method_8621();
        double x = player.method_23317();
        double z = player.method_23321();
        double distToXBorder = GlobeClientState.axisDistanceInsideBorder(border, x, true);
        double distToZBorder = GlobeClientState.axisDistanceInsideBorder(border, z, false);
        double radius = border.method_11965() * 0.5;
        double warnStart = Math.min(1500.0, Math.max(300.0, radius / 8.0));
        double warnCritical = Math.min(750.0, Math.max(150.0, radius / 16.0));
        float poleSeverity = distToZBorder <= warnStart ? (float)(1.0 - distToZBorder / warnStart) : 0.0f;
        float stormSeverity = distToXBorder <= warnStart ? (float)(1.0 - distToXBorder / warnStart) : 0.0f;
        poleSeverity = Math.max(0.0f, Math.min(1.0f, poleSeverity));
        stormSeverity = Math.max(0.0f, Math.min(1.0f, stormSeverity));
        boolean poleCritical = distToZBorder <= warnCritical;
        boolean bl = stormCritical = distToXBorder <= warnCritical;
        if (DEBUG_DISABLE_WARNINGS) {
            cachedEval = new Eval(true, surfaceOk, absX, absZ, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, false, false);
            return cachedEval;
        }
        float polarFog = poleSeverity;
        float polarWhiteout = poleSeverity;
        float stormFog = stormSeverity;
        float stormSevere = stormSeverity;
        float stormOpaque = stormSeverity;
        cachedEval = new Eval(true, surfaceOk, absX, absZ, polarFog, polarWhiteout, stormFog, stormSevere, stormOpaque, poleCritical, stormCritical);
        return cachedEval;
    }

    private static boolean isSurfaceOk(class_310 client, class_2338 pos) {
        class_638 world = client.field_1687;
        if (world == null) {
            return false;
        }
        int sea = world.method_8615();
        if (pos.method_10264() < sea - 2) {
            return false;
        }
        return world.method_8311(pos.method_10084());
    }

    public static float computePoleFogEnd(double z) {
        if (DEBUG_DISABLE_WARNINGS) {
            return -1.0f;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1687 == null) {
            return -1.0f;
        }
        float intensity = GlobeClientState.polarWhiteoutIntensity(client.field_1687, (class_1657)client.field_1724);
        if ((intensity = Math.max(0.0f, Math.min(1.0f, intensity))) <= 0.001f) {
            return -1.0f;
        }
        float e = intensity * intensity;
        float startEnd = 96.0f;
        float endEnd = 2.0f;
        return startEnd + (endEnd - startEnd) * e;
    }

    public static float computeEdgeFogEnd(double x) {
        if (DEBUG_DISABLE_WARNINGS) {
            return -1.0f;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1687 == null) {
            return -1.0f;
        }
        class_2784 border = client.field_1687.method_8621();
        double radius = border.method_11965() * 0.5;
        double warnStart = Math.min(1500.0, Math.max(300.0, radius / 8.0));
        double distX = GlobeClientState.axisDistanceInsideBorder(border, x, true);
        if (distX > warnStart) {
            return -1.0f;
        }
        float t = (float)((warnStart - distX) / warnStart);
        if (t < 0.0f) {
            t = 0.0f;
        }
        if (t > 1.0f) {
            t = 1.0f;
        }
        if (t <= 0.001f) {
            return -1.0f;
        }
        float e = t * t;
        float startEnd = 96.0f;
        float endEnd = 2.0f;
        return startEnd + (endEnd - startEnd) * e;
    }

    public static float computePoleWhiteoutFactor(double z) {
        if (DEBUG_DISABLE_WARNINGS) {
            return 0.0f;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1687 == null) {
            return 0.0f;
        }
        float intensity = GlobeClientState.polarWhiteoutIntensity(client.field_1687, (class_1657)client.field_1724);
        if ((intensity = Math.max(0.0f, Math.min(1.0f, intensity))) <= 0.001f) {
            return 0.0f;
        }
        return intensity;
    }

    static {
        cachedEvalWorldTime = Long.MIN_VALUE;
    }

    public static enum PolarStage {
        NONE,
        WARN_1,
        WARN_2,
        DANGER,
        LETHAL;

    }

    public static enum EwStormStage {
        NONE,
        LEVEL_1,
        LEVEL_2;

    }

    public record WarningState(WarningType type, Enum<?> stage, int severityRank) {
        public static final WarningState NONE = new WarningState(WarningType.NONE, PolarStage.NONE, 0);
    }

    public static enum WarningType {
        NONE,
        POLAR,
        STORM;

    }

    public record Eval(boolean active, boolean surfaceOk, int absX, int absZ, float polarFogSeverity, float polarWhiteoutSeverity, float stormFogSeverity, float stormSevereSeverity, float stormOpaqueSeverity, boolean poleCritical, boolean stormCritical) {
        public static final Eval INACTIVE = new Eval(false, false, 0, 0, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, false, false);
    }
}

