/*
 * Decompiled with CFR 0.152.
 */
package com.example.globe.client;

import com.example.globe.GlobeMod;
import com.example.globe.client.GlobeClientState;
import com.example.globe.client.LatitudeConfig;
import com.example.globe.client.ZoneEnterTitleOverlay;
import com.example.globe.util.LatitudeMath;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2784;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5321;
import net.minecraft.class_5348;
import net.minecraft.class_6880;
import net.minecraft.class_9779;

public final class GlobeWarningOverlay {
    private static long debugStartWorldTime = -1L;
    private static String lastZoneKey;
    private static final String POLE_WARN_1_TEXT = "The air is turning bitterly cold. You should consider turning back.";
    private static final String POLE_WARN_2_TEXT = "The cold seeps into your body. Movement is becoming difficult.";
    private static final String POLE_DANGER_TEXT = "DANGER! You are entering a lethal cold zone. Turn back immediately.";
    private static final String POLE_LETHAL_TEXT = "The cold overwhelms you.";
    private static final String EW_SAND_WARN_TEXT = "Sandstorms ahead. Consider turning back.";
    private static final String EW_SAND_DANGER_TEXT = "It is too dangerous to continue. Turn back.";
    private static long lastZoneUpdateWorldTime;
    private static int lastZoneUpdateX;
    private static int lastZoneUpdateZ;
    private static boolean registered;

    private GlobeWarningOverlay() {
    }

    public static void init() {
        if (registered) {
            return;
        }
        GlobeMod.LOGGER.info("Globe overlay init OK");
        registered = true;
    }

    private static String zoneDisplayName(String zoneKey) {
        return switch (zoneKey) {
            case "EQUATOR" -> "Equator";
            case "TROPICAL" -> "Tropics";
            case "SUBTROPICAL" -> "Subtropics";
            case "TEMPERATE" -> "Temperate";
            case "SUBPOLAR" -> "Subpolar";
            case "POLAR" -> "Polar";
            default -> zoneKey;
        };
    }

    private static String biomeName(class_310 client) {
        if (client.field_1687 == null || client.field_1724 == null) {
            return "Unknown";
        }
        class_6880 biomeEntry = client.field_1687.method_23753(client.field_1724.method_24515());
        Optional optKey = biomeEntry.method_40230();
        if (optKey.isPresent()) {
            String path = ((class_5321)optKey.get()).method_29177().method_12832();
            return GlobeWarningOverlay.titleCase(path);
        }
        return "Unknown";
    }

    private static String titleCase(String s) {
        String[] parts = s.split("[_/]");
        StringBuilder out = new StringBuilder();
        for (String p : parts) {
            if (p.isEmpty()) continue;
            if (out.length() > 0) {
                out.append(' ');
            }
            out.append(Character.toUpperCase(p.charAt(0)));
            if (p.length() <= 1) continue;
            out.append(p.substring(1));
        }
        return out.length() == 0 ? s : out.toString();
    }

    private static class_2561 poleTextForStage(GlobeClientState.PolarStage stage) {
        if (stage == null) {
            return null;
        }
        return switch (stage) {
            case GlobeClientState.PolarStage.WARN_1 -> class_2561.method_43470((String)POLE_WARN_1_TEXT);
            case GlobeClientState.PolarStage.WARN_2 -> class_2561.method_43470((String)POLE_WARN_2_TEXT);
            case GlobeClientState.PolarStage.DANGER -> class_2561.method_43470((String)POLE_DANGER_TEXT).method_27695(new class_124[]{class_124.field_1061, class_124.field_1067});
            case GlobeClientState.PolarStage.LETHAL -> class_2561.method_43470((String)POLE_LETHAL_TEXT).method_27695(new class_124[]{class_124.field_1061, class_124.field_1067});
            default -> null;
        };
    }

    private static class_2561 ewTextForStage(GlobeClientState.EwStormStage stage) {
        if (stage == null) {
            return null;
        }
        return switch (stage) {
            case GlobeClientState.EwStormStage.LEVEL_1 -> class_2561.method_43470((String)EW_SAND_WARN_TEXT);
            case GlobeClientState.EwStormStage.LEVEL_2 -> class_2561.method_43470((String)EW_SAND_DANGER_TEXT).method_27695(new class_124[]{class_124.field_1061, class_124.field_1067});
            default -> null;
        };
    }

    public static void render(class_332 ctx, class_9779 tickCounter) {
        class_310 client = class_310.method_1551();
        if (client == null) {
            return;
        }
        if (!LatitudeConfig.showWarningMessages) {
            return;
        }
        if (client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        try {
            boolean movedFar;
            long worldTime = client.field_1687.method_75260();
            if (debugStartWorldTime < 0L || worldTime < debugStartWorldTime) {
                debugStartWorldTime = worldTime;
                lastZoneKey = null;
            }
            GlobeClientState.Eval eval = GlobeClientState.evaluate(client);
            int screenW = client.method_22683().method_4486();
            if (!eval.active()) {
                return;
            }
            if (!eval.surfaceOk()) {
                return;
            }
            int px = client.field_1724.method_31477();
            int pz = client.field_1724.method_31479();
            boolean bl = movedFar = lastZoneUpdateX == Integer.MIN_VALUE || Math.abs(px - lastZoneUpdateX) > 16 || Math.abs(pz - lastZoneUpdateZ) > 16;
            if (lastZoneUpdateWorldTime == Long.MIN_VALUE || movedFar || worldTime % 10L == 0L) {
                lastZoneUpdateWorldTime = worldTime;
                lastZoneUpdateX = px;
                lastZoneUpdateZ = pz;
                class_2784 border = client.field_1687.method_8621();
                String zoneKey = LatitudeMath.zoneKey(border, client.field_1724.method_23321());
                if (lastZoneKey == null || !lastZoneKey.equals(zoneKey)) {
                    lastZoneKey = zoneKey;
                    if (LatitudeConfig.zoneEnterTitleEnabled) {
                        String titleText = GlobeWarningOverlay.buildZoneEnterTitle(client, zoneKey);
                        int durationTicks = (int)Math.round(GlobeWarningOverlay.clamp(LatitudeConfig.zoneEnterTitleSeconds, 2.0, 10.0) * 20.0);
                        double scale = GlobeWarningOverlay.clamp(LatitudeConfig.zoneEnterTitleScale, 1.0, 3.0);
                        ZoneEnterTitleOverlay.trigger(titleText, durationTicks, scale);
                    }
                }
            }
            class_2561 bestText = null;
            GlobeClientState.WarningState state = GlobeClientState.computeWarningState(client.field_1687, (class_1657)client.field_1724);
            if (state.type() == GlobeClientState.WarningType.NONE) {
                return;
            }
            if (state.type() == GlobeClientState.WarningType.POLAR) {
                stage = (GlobeClientState.PolarStage)state.stage();
                bestText = GlobeWarningOverlay.poleTextForStage((GlobeClientState.PolarStage)stage);
            } else if (state.type() == GlobeClientState.WarningType.STORM) {
                stage = (GlobeClientState.EwStormStage)state.stage();
                bestText = GlobeWarningOverlay.ewTextForStage((GlobeClientState.EwStormStage)stage);
            }
            if (bestText == null) {
                return;
            }
            int warnY = client.method_22683().method_4502() - 68;
            if (warnY < 18) {
                warnY = 18;
            }
            GlobeWarningOverlay.drawCenteredWarning(ctx, client.field_1772, bestText, warnY);
        }
        catch (Throwable t) {
            GlobeMod.LOGGER.error("GlobeWarningOverlay.render crashed", t);
        }
    }

    private static void drawCenteredWarning(class_332 ctx, class_327 tr, class_2561 text, int y) {
        int screenW = class_310.method_1551().method_22683().method_4486();
        int w = tr.method_27525((class_5348)text);
        int x = Math.max(4, (screenW - w) / 2);
        ctx.method_27535(tr, text, x, y, -1);
    }

    private static String buildZoneEnterTitle(class_310 client, String zoneKey) {
        String zoneName = GlobeWarningOverlay.zoneDisplayName(zoneKey).toUpperCase();
        if (!LatitudeConfig.showZoneBaseDegreesOnTitle) {
            return zoneName;
        }
        if (client.field_1724 == null || client.field_1687 == null) {
            return zoneName;
        }
        class_2784 border = client.field_1687.method_8621();
        int baseDeg = LatitudeMath.zoneCenterDeg(zoneKey);
        if (baseDeg <= 0) {
            return zoneName + " 0\u00b0";
        }
        char hemi = LatitudeMath.hemisphere(border, client.field_1724.method_23321());
        return zoneName + " " + baseDeg + "\u00b0" + hemi;
    }

    private static double clamp(double v, double lo, double hi) {
        return Math.max(lo, Math.min(hi, v));
    }

    static {
        lastZoneUpdateWorldTime = Long.MIN_VALUE;
        lastZoneUpdateX = Integer.MIN_VALUE;
        lastZoneUpdateZ = Integer.MIN_VALUE;
    }
}

