/*
 * Decompiled with CFR 0.152.
 */
package com.example.globe.client;

import com.example.globe.client.CompassHud;
import com.example.globe.client.CompassHudConfig;
import com.example.globe.client.LatitudeConfig;
import com.example.globe.client.LatitudeMath;
import com.example.globe.client.ZoneEnterTitleOverlay;
import java.util.Objects;
import net.minecraft.class_1041;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_2784;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5676;

public class LatitudeHudAdjustScreen
extends class_437 {
    private final class_437 parent;
    private Mode mode = Mode.BOTH;
    private boolean draggingTitle = false;
    private boolean draggingCompass = false;
    private double lastMouseX;
    private double lastMouseY;
    private int compassGrabDx;
    private int compassGrabDy;
    private boolean showSettings = true;
    private class_339 settingsScale;
    private class_339 settingsTextColor;
    private class_339 settingsBackgroundColor;
    private class_339 settingsBackground;
    private class_339 settingsTransparency;
    private class_339 settingsShowLatitude;
    private class_339 settingsCompactHud;
    private boolean wasLDown = false;

    public LatitudeHudAdjustScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Adjust HUD Position"));
        this.parent = parent;
    }

    protected void method_25426() {
        int bw = 200;
        int bh = 20;
        int x = (this.field_22789 - bw) / 2;
        int y = this.field_22790 - 28;
        int panelX = 8;
        int panelY = 52;
        int panelW = 170;
        int rowH = 20;
        int rowGap = 4;
        CompassHudConfig cfg = CompassHudConfig.get();
        int py = panelY;
        this.settingsScale = (class_339)this.method_37063((class_364)new FloatSlider(panelX, py, panelW, rowH, (class_2561)class_2561.method_43470((String)"Scale"), 0.5f, 3.0f, cfg.scale, v -> {
            cfg.scale = v;
        }));
        this.settingsTransparency = (class_339)this.method_37063((class_364)new IntSlider(panelX, py += rowH + rowGap, panelW, rowH, (class_2561)class_2561.method_43470((String)"Transparency"), 0, 255, cfg.backgroundAlpha, v -> {
            cfg.backgroundAlpha = v;
        }));
        this.settingsBackground = (class_339)this.method_37063((class_364)class_5676.method_75345(v -> class_2561.method_43470((String)(v != false ? "ON" : "OFF")), () -> cfg.showBackground).method_32624((Object[])new Boolean[]{true, false}).method_32617(panelX, py += rowH + rowGap, panelW, rowH, (class_2561)class_2561.method_43470((String)"Background"), (btn, value) -> {
            cfg.showBackground = value;
        }));
        this.settingsShowLatitude = (class_339)this.method_37063((class_364)class_5676.method_75345(v -> class_2561.method_43470((String)(v != false ? "ON" : "OFF")), () -> Boolean.TRUE.equals(cfg.showLatitude)).method_32624((Object[])new Boolean[]{true, false}).method_32617(panelX, py += rowH + rowGap, panelW, rowH, (class_2561)class_2561.method_43470((String)"Show Latitude"), (btn, value) -> {
            cfg.showLatitude = value;
        }));
        this.settingsCompactHud = (class_339)this.method_37063((class_364)class_5676.method_75345(v -> class_2561.method_43470((String)(v != false ? "ON" : "OFF")), () -> cfg.compactHud).method_32624((Object[])new Boolean[]{true, false}).method_32617(panelX, py += rowH + rowGap, panelW, rowH, (class_2561)class_2561.method_43470((String)"Compact HUD"), (btn, value) -> {
            cfg.compactHud = value;
        }));
        this.settingsBackgroundColor = (class_339)this.method_37063((class_364)class_5676.method_75345(this::bgColorLabel, () -> LatitudeHudAdjustScreen.bgColorName(cfg.backgroundRgb)).method_32624((Object[])new String[]{"BLACK", "DARK_GRAY", "BLUE"}).method_32617(panelX, py += rowH + rowGap, panelW, rowH, (class_2561)class_2561.method_43470((String)"Background Color"), (btn, value) -> {
            cfg.backgroundRgb = LatitudeHudAdjustScreen.bgColorRgb(value);
        }));
        this.settingsTextColor = (class_339)this.method_37063((class_364)class_5676.method_75345(this::textColorLabel, () -> LatitudeHudAdjustScreen.textColorName(cfg.textRgb)).method_32624((Object[])new String[]{"WHITE", "YELLOW", "RED", "CYAN"}).method_32617(panelX, py += rowH + rowGap, panelW, rowH, (class_2561)class_2561.method_43470((String)"Text Color"), (btn, value) -> {
            cfg.textRgb = LatitudeHudAdjustScreen.textColorRgb(value);
        }));
        this.updateSettingsVisibility();
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Adjust: BOTH"), btn -> {
            this.mode = switch (this.mode.ordinal()) {
                default -> throw new MatchException(null, null);
                case 2 -> Mode.TITLE;
                case 0 -> Mode.COMPASS;
                case 1 -> Mode.BOTH;
            };
            btn.method_25355((class_2561)class_2561.method_43470((String)("Adjust: " + this.mode.name())));
        }).method_46434(8, 28, 140, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Done"), btn -> {
            LatitudeConfig.saveCurrent();
            CompassHudConfig.saveCurrent();
            class_310.method_1551().method_1507(this.parent);
        }).method_46434(x, y, bw, bh).method_46431());
    }

    public void method_25394(class_332 ctx, int mouseX, int mouseY, float delta) {
        class_2784 border;
        this.method_52752(ctx);
        ctx.method_25294(0, 0, this.field_22789, this.field_22790, 0x66000000);
        if (this.showSettings) {
            int px = 6;
            int py = 46;
            int pw = 174;
            int ph = 178;
            ctx.method_25294(px, py, px + pw, py + ph, -1442840576);
            ctx.method_25303(this.field_22793, "HUD Settings", px + 6, py + 6, -1);
            ctx.method_25303(this.field_22793, "Press L to hide/show settings", px + 6, py + 18, -3355444);
        }
        ctx.method_51433(this.field_22793, "Drag the zone title to reposition. Click Done when finished.", 8, 8, 0xFFFFFF, true);
        class_310 mc = class_310.method_1551();
        double z = 0.0;
        class_2784 class_27842 = border = mc.field_1687 != null ? mc.field_1687.method_8621() : null;
        if (mc.field_1724 != null) {
            z = mc.field_1724.method_23321();
        }
        String degText = border != null ? LatitudeMath.formatLatitudeDeg(z, border) : "0\u00b0";
        String sampleTitle = "EQUATOR " + degText;
        ZoneEnterTitleOverlay.renderStaticAt(ctx, this.field_22789, this.field_22790, sampleTitle, LatitudeConfig.zoneEnterTitleScale, LatitudeConfig.zoneEnterTitleOffsetX, LatitudeConfig.zoneEnterTitleOffsetY);
        if (this.mode == Mode.COMPASS || this.mode == Mode.BOTH) {
            CompassHud.renderAdjustPreview(ctx, this.field_22789, this.field_22790);
        }
        super.method_25394(ctx, mouseX, mouseY, delta);
    }

    public void method_25393() {
        super.method_25393();
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.method_22683() == null) {
            return;
        }
        boolean lDown = class_3675.method_15987((class_1041)mc.method_22683(), (int)76);
        if (lDown && !this.wasLDown) {
            this.showSettings = !this.showSettings;
            this.updateSettingsVisibility();
        }
        this.wasLDown = lDown;
    }

    public boolean method_25402(class_11909 click, boolean doubleClick) {
        if (super.method_25402(click, doubleClick)) {
            return true;
        }
        double mouseX = click.comp_4798();
        double mouseY = click.comp_4799();
        int button = click.method_74245();
        if (button == 0 && (this.mode == Mode.TITLE || this.mode == Mode.BOTH) && this.isMouseOverTitle(mouseX, mouseY)) {
            this.draggingTitle = true;
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
            return true;
        }
        if (button == 0 && (this.mode == Mode.COMPASS || this.mode == Mode.BOTH) && this.isMouseOverCompass(mouseX, mouseY)) {
            this.draggingCompass = true;
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
            return true;
        }
        return super.method_25402(click, doubleClick);
    }

    public boolean method_25403(class_11909 click, double deltaX, double deltaY) {
        if (super.method_25403(click, deltaX, deltaY)) {
            return true;
        }
        double mouseX = click.comp_4798();
        double mouseY = click.comp_4799();
        int button = click.method_74245();
        if (this.draggingTitle && button == 0) {
            LatitudeConfig.zoneEnterTitleOffsetX += (int)Math.round(mouseX - this.lastMouseX);
            LatitudeConfig.zoneEnterTitleOffsetY += (int)Math.round(mouseY - this.lastMouseY);
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
            if (LatitudeConfig.hudSnapEnabled) {
                LatitudeConfig.zoneEnterTitleOffsetX = LatitudeHudAdjustScreen.snap(LatitudeConfig.zoneEnterTitleOffsetX, LatitudeConfig.hudSnapPixels);
                LatitudeConfig.zoneEnterTitleOffsetY = LatitudeHudAdjustScreen.snap(LatitudeConfig.zoneEnterTitleOffsetY, LatitudeConfig.hudSnapPixels);
            }
            return true;
        }
        if (this.draggingCompass && button == 0) {
            class_310 mc = class_310.method_1551();
            if (mc == null || mc.method_22683() == null) {
                return true;
            }
            CompassHudConfig cfg = CompassHudConfig.get();
            if (cfg.attachToHotbarCompass) {
                return true;
            }
            int screenW = mc.method_22683().method_4486();
            int screenH = mc.method_22683().method_4502();
            int targetX = (int)Math.round(mouseX) - this.compassGrabDx;
            int targetY = (int)Math.round(mouseY) - this.compassGrabDy;
            CompassHud.HudBounds b = CompassHud.computeBounds(mc, cfg);
            int boxW = b.w();
            int boxH = b.h();
            targetX = LatitudeHudAdjustScreen.clamp(targetX, 0, Math.max(0, screenW - boxW));
            targetY = LatitudeHudAdjustScreen.clamp(targetY, 0, Math.max(0, screenH - boxH));
            CompassHud.HudPoint base = CompassHud.computeBasePosition(mc, cfg);
            cfg.offsetX = targetX - base.x();
            cfg.offsetY = targetY - base.y();
            if (LatitudeConfig.hudSnapEnabled) {
                cfg.offsetX = LatitudeHudAdjustScreen.snap(cfg.offsetX, LatitudeConfig.hudSnapPixels);
                cfg.offsetY = LatitudeHudAdjustScreen.snap(cfg.offsetY, LatitudeConfig.hudSnapPixels);
            }
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
            return true;
        }
        return super.method_25403(click, deltaX, deltaY);
    }

    private void updateSettingsVisibility() {
        LatitudeHudAdjustScreen.setVisible(this.settingsScale, this.showSettings);
        LatitudeHudAdjustScreen.setVisible(this.settingsTextColor, this.showSettings);
        LatitudeHudAdjustScreen.setVisible(this.settingsBackgroundColor, this.showSettings);
        LatitudeHudAdjustScreen.setVisible(this.settingsBackground, this.showSettings);
        LatitudeHudAdjustScreen.setVisible(this.settingsTransparency, this.showSettings);
        LatitudeHudAdjustScreen.setVisible(this.settingsShowLatitude, this.showSettings);
        LatitudeHudAdjustScreen.setVisible(this.settingsCompactHud, this.showSettings);
    }

    private static void setVisible(class_339 w, boolean v) {
        if (w == null) {
            return;
        }
        w.field_22764 = v;
        w.field_22763 = v;
    }

    private class_2561 textColorLabel(String v) {
        return class_2561.method_43470((String)v);
    }

    private static String textColorName(int rgb) {
        int c = rgb & 0xFFFFFF;
        if (c == 0xFFFF00) {
            return "YELLOW";
        }
        if (c == 0xFF0000) {
            return "RED";
        }
        if (c == 65535) {
            return "CYAN";
        }
        return "WHITE";
    }

    private static int textColorRgb(String name) {
        return switch (name) {
            case "YELLOW" -> 0xFFFF00;
            case "RED" -> 0xFF0000;
            case "CYAN" -> 65535;
            default -> 0xFFFFFF;
        };
    }

    private class_2561 bgColorLabel(String v) {
        return class_2561.method_43470((String)v);
    }

    private static String bgColorName(int rgb) {
        int c = rgb & 0xFFFFFF;
        if (c == 0x111111) {
            return "DARK_GRAY";
        }
        if (c == 727866) {
            return "BLUE";
        }
        return "BLACK";
    }

    private static int bgColorRgb(String name) {
        return switch (name) {
            case "DARK_GRAY" -> 0x111111;
            case "BLUE" -> 727866;
            default -> 0;
        };
    }

    public boolean method_25406(class_11909 click) {
        if (click.method_74245() == 0) {
            this.draggingTitle = false;
            if (this.draggingCompass) {
                this.draggingCompass = false;
                CompassHudConfig.saveCurrent();
            }
        }
        return super.method_25406(click);
    }

    private boolean isMouseOverCompass(double mx, double my) {
        class_310 mc = class_310.method_1551();
        if (mc == null) {
            return false;
        }
        CompassHudConfig cfg = CompassHudConfig.get();
        if (cfg.attachToHotbarCompass) {
            return false;
        }
        CompassHud.HudBounds b = CompassHud.computeBounds(mc, cfg);
        if (b == null) {
            return false;
        }
        if (mx < (double)b.x() || mx >= (double)(b.x() + b.w()) || my < (double)b.y() || my >= (double)(b.y() + b.h())) {
            return false;
        }
        this.compassGrabDx = (int)Math.round(mx) - b.x();
        this.compassGrabDy = (int)Math.round(my) - b.y();
        return true;
    }

    private static int snap(int v, int step) {
        if (step <= 1) {
            return v;
        }
        return Math.round((float)v / (float)step) * step;
    }

    private static int clamp(int v, int lo, int hi) {
        return Math.max(lo, Math.min(hi, v));
    }

    private boolean isMouseOverTitle(double mx, double my) {
        String s = "EQUATOR 0\u00b0";
        int w = this.field_22793.method_1727(s);
        Objects.requireNonNull(this.field_22793);
        int h = 9;
        double scale = class_3532.method_15350((double)LatitudeConfig.zoneEnterTitleScale, (double)1.0, (double)3.0);
        int cx = this.field_22789 / 2 + LatitudeConfig.zoneEnterTitleOffsetX;
        int cy = this.field_22790 / 2 + LatitudeConfig.zoneEnterTitleOffsetY;
        double halfW = (double)w * scale / 2.0;
        double halfH = (double)h * scale / 2.0;
        double pad = 6.0;
        return mx >= (double)cx - halfW - pad && mx <= (double)cx + halfW + pad && my >= (double)cy - halfH - pad && my <= (double)cy + halfH + pad;
    }

    private static enum Mode {
        TITLE,
        COMPASS,
        BOTH;

    }

    private static final class FloatSlider
    extends class_357 {
        private final float min;
        private final float max;
        private final FloatConsumer onChange;

        private FloatSlider(int x, int y, int w, int h, class_2561 label, float min, float max, float value, FloatConsumer onChange) {
            super(x, y, w, h, label, 0.0);
            this.min = min;
            this.max = max;
            this.onChange = onChange;
            this.setValue(value);
            this.method_25346();
        }

        private void setValue(float v) {
            float clamped = Math.max(this.min, Math.min(this.max, v));
            this.field_22753 = (double)(clamped - this.min) / (double)(this.max - this.min);
        }

        private float getFloatValue() {
            return (float)((double)this.min + this.field_22753 * (double)(this.max - this.min));
        }

        protected void method_25346() {
            float v = this.getFloatValue();
            this.method_25355((class_2561)class_2561.method_43470((String)(this.method_25369().getString().split(":")[0] + ": " + String.format("%.2f", Float.valueOf(v)))));
        }

        protected void method_25344() {
            this.onChange.accept(this.getFloatValue());
        }
    }

    private static interface FloatConsumer {
        public void accept(float var1);
    }

    private static final class IntSlider
    extends class_357 {
        private final int min;
        private final int max;
        private final IntConsumer onChange;

        private IntSlider(int x, int y, int w, int h, class_2561 label, int min, int max, int value, IntConsumer onChange) {
            super(x, y, w, h, label, 0.0);
            this.min = min;
            this.max = max;
            this.onChange = onChange;
            this.setValue(value);
            this.method_25346();
        }

        private void setValue(int v) {
            int clamped = Math.max(this.min, Math.min(this.max, v));
            this.field_22753 = (double)(clamped - this.min) / (double)(this.max - this.min);
        }

        private int getIntValue() {
            return (int)Math.round((double)this.min + this.field_22753 * (double)(this.max - this.min));
        }

        protected void method_25346() {
            this.method_25355((class_2561)class_2561.method_43470((String)(this.method_25369().getString().split(":")[0] + ": " + this.getIntValue())));
        }

        protected void method_25344() {
            this.onChange.accept(this.getIntValue());
        }
    }

    private static interface IntConsumer {
        public void accept(int var1);
    }
}

