/*
 * Decompiled with CFR 0.152.
 */
package com.example.globe.client;

import com.example.globe.client.CompassHud;
import com.example.globe.client.CompassHudConfig;
import com.example.globe.client.LatitudeConfig;
import com.example.globe.client.LatitudeMath;
import com.example.globe.client.ZoneEnterTitleOverlay;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.class_1041;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_2784;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5676;

public class LatitudeHudStudioScreen
extends class_437 {
    private final class_437 parent;
    private boolean sidebarVisible = true;
    private int sidebarWidth = 180;
    private Target target = Target.COMPASS;
    private DragElement dragElement = DragElement.NONE;
    private boolean wasLDown = false;
    private int compassGrabDx;
    private int compassGrabDy;
    private double titleOffsetXf;
    private double titleOffsetYf;
    private double titleGrabDx;
    private double titleGrabDy;
    private class_339 wTarget;
    private class_339 wCompassScale;
    private class_339 wCompassTransparency;
    private class_339 wCompassBackground;
    private class_339 wCompassBgColor;
    private class_339 wCompassTextColor;
    private class_339 wCompassShowLatitude;
    private class_339 wCompassCompact;
    private class_339 wCompassAttachHotbar;
    private class_339 wTitleScale;
    private class_339 wResetHud;
    private int sidebarHintY;

    public LatitudeHudStudioScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"HUD Studio"));
        this.parent = parent;
    }

    protected void method_25426() {
        this.method_37067();
        int panelX = 8;
        int panelY = 28;
        int panelW = this.sidebarWidth;
        int rowH = 20;
        int rowGap = 4;
        CompassHudConfig cfg = CompassHudConfig.get();
        this.titleOffsetXf = LatitudeConfig.zoneEnterTitleOffsetX;
        this.titleOffsetYf = LatitudeConfig.zoneEnterTitleOffsetY;
        int y = panelY;
        this.wTarget = (class_339)this.method_37063((class_364)class_4185.method_46430((class_2561)this.targetLabel(), b -> {
            this.target = switch (this.target.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> Target.TITLE;
                case 1 -> Target.BOTH;
                case 2 -> Target.COMPASS;
            };
            b.method_25355(this.targetLabel());
            this.updateSidebarVisibility();
        }).method_46434(panelX, y, panelW, rowH).method_46431());
        this.wCompassScale = (class_339)this.method_37063((class_364)new FloatSlider(panelX, y += rowH + rowGap, panelW, rowH, (class_2561)class_2561.method_43470((String)"Scale"), 0.5f, 3.0f, cfg.scale, v -> {
            cfg.scale = v;
        }));
        this.wCompassTransparency = (class_339)this.method_37063((class_364)new IntSlider(panelX, y += rowH + rowGap, panelW, rowH, (class_2561)class_2561.method_43470((String)"Transparency"), 0, 255, cfg.backgroundAlpha, v -> {
            cfg.backgroundAlpha = v;
        }));
        this.wCompassBackground = (class_339)this.method_37063((class_364)class_5676.method_75345(v -> class_2561.method_43470((String)(v != false ? "ON" : "OFF")), () -> cfg.showBackground).method_32624((Object[])new Boolean[]{true, false}).method_32617(panelX, y += rowH + rowGap, panelW, rowH, (class_2561)class_2561.method_43470((String)"Background"), (btn, value) -> {
            cfg.showBackground = value;
        }));
        this.wCompassBgColor = (class_339)this.method_37063((class_364)class_5676.method_75345(class_2561::method_43470, () -> LatitudeHudStudioScreen.bgColorName(cfg.backgroundRgb)).method_32624((Object[])new String[]{"BLACK", "WHITE", "DARK_GRAY", "BLUE"}).method_32617(panelX, y += rowH + rowGap, panelW, rowH, (class_2561)class_2561.method_43470((String)"Background Color"), (btn, value) -> {
            cfg.backgroundRgb = LatitudeHudStudioScreen.bgColorRgb(value);
        }));
        this.wCompassTextColor = (class_339)this.method_37063((class_364)class_5676.method_75345(class_2561::method_43470, () -> LatitudeHudStudioScreen.textColorName(cfg.textRgb)).method_32624((Object[])new String[]{"WHITE", "BLACK", "YELLOW", "RED", "CYAN"}).method_32617(panelX, y += rowH + rowGap, panelW, rowH, (class_2561)class_2561.method_43470((String)"Text Color"), (btn, value) -> {
            cfg.textRgb = LatitudeHudStudioScreen.textColorRgb(value);
        }));
        this.wCompassShowLatitude = (class_339)this.method_37063((class_364)class_5676.method_75345(v -> class_2561.method_43470((String)(v != false ? "ON" : "OFF")), () -> Boolean.TRUE.equals(cfg.showLatitude)).method_32624((Object[])new Boolean[]{true, false}).method_32617(panelX, y += rowH + rowGap, panelW, rowH, (class_2561)class_2561.method_43470((String)"Show Latitude"), (btn, value) -> {
            cfg.showLatitude = value;
        }));
        this.wCompassCompact = (class_339)this.method_37063((class_364)class_5676.method_75345(v -> class_2561.method_43470((String)(v != false ? "ON" : "OFF")), () -> cfg.compactHud).method_32624((Object[])new Boolean[]{true, false}).method_32617(panelX, y += rowH + rowGap, panelW, rowH, (class_2561)class_2561.method_43470((String)"Compact HUD"), (btn, value) -> {
            cfg.compactHud = value;
        }));
        this.wCompassAttachHotbar = (class_339)this.method_37063((class_364)class_5676.method_75345(v -> class_2561.method_43470((String)(v != false ? "ON" : "OFF")), () -> cfg.attachToHotbarCompass).method_32624((Object[])new Boolean[]{true, false}).method_32617(panelX, y += rowH + rowGap, panelW, rowH, (class_2561)class_2561.method_43470((String)"Attach to Hotbar"), (btn, value) -> {
            cfg.attachToHotbarCompass = value;
            CompassHudConfig.saveCurrent();
        }));
        this.wTitleScale = (class_339)this.method_37063((class_364)new StepSlider(panelX, y += rowH + rowGap, panelW, rowH, (class_2561)class_2561.method_43470((String)"Title Size"), 1.0, 3.0, 0.1, LatitudeConfig.zoneEnterTitleScale, v -> {
            LatitudeConfig.zoneEnterTitleScale = v;
        }));
        int resetY = this.field_22790 - 52;
        this.wResetHud = (class_339)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Reset HUD"), b -> {
            LatitudeHudStudioScreen.resetHudDefaults();
            this.dragElement = DragElement.NONE;
            this.method_25426();
        }).method_46434(panelX, resetY, panelW, rowH).method_46431());
        int bw = 200;
        int bh = 20;
        int doneX = (this.field_22789 - bw) / 2;
        int doneY = this.field_22790 - 28;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Done"), btn -> {
            CompassHudConfig.saveCurrent();
            LatitudeConfig.saveCurrent();
            class_310.method_1551().method_1507(this.parent);
        }).method_46434(doneX, doneY, bw, bh).method_46431());
        this.updateSidebarVisibility();
    }

    public void method_25394(class_332 ctx, int mouseX, int mouseY, float delta) {
        class_2784 border;
        this.method_52752(ctx);
        ctx.method_25294(0, 0, this.field_22789, this.field_22790, 0x66000000);
        int sidebarX = 6;
        int sidebarY = 22;
        if (this.sidebarVisible) {
            int px = sidebarX;
            int py = sidebarY;
            int pw = this.sidebarWidth + 4;
            int ph = this.field_22790 - 44;
            ctx.method_25294(px, py, px + pw, py + ph, -1442840576);
        }
        class_310 mc = class_310.method_1551();
        double z = 0.0;
        class_2784 class_27842 = border = mc.field_1687 != null ? mc.field_1687.method_8621() : null;
        if (mc.field_1724 != null) {
            z = mc.field_1724.method_23321();
        }
        String degText = border != null ? LatitudeMath.formatLatitudeDeg(z, border) : "0\u00b0";
        String sampleTitle = "EQUATOR " + degText;
        int titleOffsetX = this.dragElement == DragElement.TITLE ? (int)Math.round(this.titleOffsetXf) : LatitudeConfig.zoneEnterTitleOffsetX;
        int titleOffsetY = this.dragElement == DragElement.TITLE ? (int)Math.round(this.titleOffsetYf) : LatitudeConfig.zoneEnterTitleOffsetY;
        ZoneEnterTitleOverlay.renderStaticAt(ctx, this.field_22789, this.field_22790, sampleTitle, LatitudeConfig.zoneEnterTitleScale, titleOffsetX, titleOffsetY);
        CompassHud.renderAdjustPreview(ctx, this.field_22789, this.field_22790);
        super.method_25394(ctx, mouseX, mouseY, delta);
        if (this.sidebarVisible) {
            ctx.method_25303(this.field_22793, "Press L to hide settings", sidebarX + 8, this.sidebarHintY, -1);
        } else {
            ctx.method_25303(this.field_22793, "Press L to show settings", 8, 8, -1);
        }
    }

    public void method_25393() {
        super.method_25393();
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.method_22683() == null) {
            return;
        }
        boolean lDown = class_3675.method_15987((class_1041)mc.method_22683(), (int)76);
        if (lDown && !this.wasLDown) {
            this.sidebarVisible = !this.sidebarVisible;
            this.updateSidebarVisibility();
        }
        this.wasLDown = lDown;
    }

    public boolean method_25402(class_11909 click, boolean doubleClick) {
        if (super.method_25402(click, doubleClick)) {
            return true;
        }
        double mx = click.comp_4798();
        double my = click.comp_4799();
        if (click.method_74245() == 0) {
            if (LatitudeConfig.zoneEnterTitleDraggable && this.isMouseOverTitle(mx, my)) {
                this.dragElement = DragElement.TITLE;
                int cx = this.field_22789 / 2 + LatitudeConfig.zoneEnterTitleOffsetX;
                int cy = this.field_22790 / 2 + LatitudeConfig.zoneEnterTitleOffsetY;
                this.titleGrabDx = mx - (double)cx;
                this.titleGrabDy = my - (double)cy;
                this.titleOffsetXf = LatitudeConfig.zoneEnterTitleOffsetX;
                this.titleOffsetYf = LatitudeConfig.zoneEnterTitleOffsetY;
                return true;
            }
            if (this.isMouseOverCompass(mx, my)) {
                this.dragElement = DragElement.COMPASS;
                return true;
            }
        }
        return false;
    }

    public boolean method_25403(class_11909 click, double deltaX, double deltaY) {
        if (super.method_25403(click, deltaX, deltaY)) {
            return true;
        }
        double mx = click.comp_4798();
        double my = click.comp_4799();
        if (click.method_74245() != 0) {
            return false;
        }
        if (this.dragElement == DragElement.TITLE) {
            double newCx = mx - this.titleGrabDx;
            double newCy = my - this.titleGrabDy;
            this.titleOffsetXf = newCx - (double)this.field_22789 / 2.0;
            this.titleOffsetYf = newCy - (double)this.field_22790 / 2.0;
            return true;
        }
        if (this.dragElement == DragElement.COMPASS) {
            class_310 mc = class_310.method_1551();
            if (mc == null || mc.method_22683() == null) {
                return true;
            }
            CompassHudConfig cfg = CompassHudConfig.get();
            if (cfg.attachToHotbarCompass) {
                return true;
            }
            int screenW = mc.method_22683().method_4486();
            int screenH = mc.method_22683().method_4502();
            int targetX = (int)Math.round(mx) - this.compassGrabDx;
            int targetY = (int)Math.round(my) - this.compassGrabDy;
            CompassHud.HudBounds b = CompassHud.computeBounds(mc, cfg);
            int boxW = b.w();
            int boxH = b.h();
            targetX = LatitudeHudStudioScreen.clamp(targetX, 0, Math.max(0, screenW - boxW));
            targetY = LatitudeHudStudioScreen.clamp(targetY, 0, Math.max(0, screenH - boxH));
            CompassHud.HudPoint base = CompassHud.computeBasePosition(mc, cfg);
            cfg.offsetX = targetX - base.x();
            cfg.offsetY = targetY - base.y();
            if (LatitudeConfig.hudSnapEnabled) {
                cfg.offsetX = LatitudeHudStudioScreen.snap(cfg.offsetX, LatitudeConfig.hudSnapPixels);
                cfg.offsetY = LatitudeHudStudioScreen.snap(cfg.offsetY, LatitudeConfig.hudSnapPixels);
            }
            return true;
        }
        return false;
    }

    public boolean method_25406(class_11909 click) {
        if (click.method_74245() == 0) {
            if (this.dragElement == DragElement.TITLE) {
                int x = (int)Math.round(this.titleOffsetXf);
                int y = (int)Math.round(this.titleOffsetYf);
                if (LatitudeConfig.hudSnapEnabled) {
                    x = LatitudeHudStudioScreen.snap(x, LatitudeConfig.hudSnapPixels);
                    y = LatitudeHudStudioScreen.snap(y, LatitudeConfig.hudSnapPixels);
                }
                LatitudeConfig.zoneEnterTitleOffsetX = x;
                LatitudeConfig.zoneEnterTitleOffsetY = y;
                LatitudeConfig.saveCurrent();
            }
            if (this.dragElement == DragElement.COMPASS) {
                CompassHudConfig.saveCurrent();
            }
            this.dragElement = DragElement.NONE;
        }
        return super.method_25406(click);
    }

    private static void resetHudDefaults() {
        CompassHudConfig cfg = CompassHudConfig.get();
        LatitudeHudStudioScreen.applyDefaults(cfg);
        CompassHudConfig.saveCurrent();
        LatitudeConfig.zoneEnterTitleScale = 1.8;
        LatitudeConfig.zoneEnterTitleOffsetX = 0;
        LatitudeConfig.zoneEnterTitleOffsetY = -40;
        LatitudeConfig.saveCurrent();
    }

    private void updateSidebarVisibility() {
        LatitudeHudStudioScreen.setVisible(this.wTarget, this.sidebarVisible);
        boolean showCompassControls = this.sidebarVisible && (this.target == Target.COMPASS || this.target == Target.BOTH);
        LatitudeHudStudioScreen.setVisible(this.wCompassScale, showCompassControls);
        LatitudeHudStudioScreen.setVisible(this.wCompassTransparency, showCompassControls);
        LatitudeHudStudioScreen.setVisible(this.wCompassBackground, showCompassControls);
        LatitudeHudStudioScreen.setVisible(this.wCompassBgColor, showCompassControls);
        LatitudeHudStudioScreen.setVisible(this.wCompassTextColor, showCompassControls);
        LatitudeHudStudioScreen.setVisible(this.wCompassShowLatitude, showCompassControls);
        LatitudeHudStudioScreen.setVisible(this.wCompassCompact, showCompassControls);
        LatitudeHudStudioScreen.setVisible(this.wCompassAttachHotbar, showCompassControls);
        boolean showTitleControls = this.sidebarVisible && (this.target == Target.TITLE || this.target == Target.BOTH);
        LatitudeHudStudioScreen.setVisible(this.wTitleScale, showTitleControls);
        LatitudeHudStudioScreen.setVisible(this.wResetHud, this.sidebarVisible);
        this.sidebarHintY = this.computeSidebarHintY();
    }

    private int computeSidebarHintY() {
        if (!this.sidebarVisible) {
            return 8;
        }
        int bottom = 0;
        bottom = Math.max(bottom, LatitudeHudStudioScreen.bottomYIfVisible(this.wTarget));
        bottom = Math.max(bottom, LatitudeHudStudioScreen.bottomYIfVisible(this.wCompassScale));
        bottom = Math.max(bottom, LatitudeHudStudioScreen.bottomYIfVisible(this.wCompassTransparency));
        bottom = Math.max(bottom, LatitudeHudStudioScreen.bottomYIfVisible(this.wCompassBackground));
        bottom = Math.max(bottom, LatitudeHudStudioScreen.bottomYIfVisible(this.wCompassBgColor));
        bottom = Math.max(bottom, LatitudeHudStudioScreen.bottomYIfVisible(this.wCompassTextColor));
        bottom = Math.max(bottom, LatitudeHudStudioScreen.bottomYIfVisible(this.wCompassShowLatitude));
        bottom = Math.max(bottom, LatitudeHudStudioScreen.bottomYIfVisible(this.wCompassCompact));
        bottom = Math.max(bottom, LatitudeHudStudioScreen.bottomYIfVisible(this.wCompassAttachHotbar));
        if ((bottom = Math.max(bottom, LatitudeHudStudioScreen.bottomYIfVisible(this.wTitleScale))) <= 0) {
            return 8;
        }
        int hintY = bottom + 6;
        if (this.wResetHud != null && this.wResetHud.field_22764) {
            hintY = Math.min(hintY, this.wResetHud.method_46427() - 14);
        }
        hintY = Math.max(hintY, 22);
        hintY = Math.min(hintY, Math.max(0, this.field_22790 - 18));
        return hintY;
    }

    private static int bottomYIfVisible(class_339 w) {
        if (w == null || !w.field_22764) {
            return 0;
        }
        return w.method_46427() + w.method_25364();
    }

    private static void applyDefaults(CompassHudConfig cfg) {
        cfg.enabled = true;
        cfg.showMode = CompassHudConfig.ShowMode.COMPASS_PRESENT;
        cfg.directionMode = CompassHudConfig.DirectionMode.CARDINAL_8;
        cfg.hAnchor = CompassHudConfig.HAnchor.CENTER;
        cfg.vAnchor = CompassHudConfig.VAnchor.TOP;
        cfg.offsetX = 0;
        cfg.offsetY = 0;
        cfg.scale = 1.0f;
        cfg.padding = 3;
        cfg.showBackground = true;
        cfg.backgroundRgb = 0;
        cfg.backgroundAlpha = 64;
        cfg.textRgb = 0xFFFFFF;
        cfg.textAlpha = 255;
        cfg.shadow = true;
        cfg.showLatitude = true;
        cfg.latitudeDecimals = 0;
        cfg.attachToHotbarCompass = false;
        cfg.compactHud = false;
    }

    private static void setVisible(class_339 w, boolean v) {
        if (w == null) {
            return;
        }
        w.field_22764 = v;
        w.field_22763 = v;
    }

    private class_2561 targetLabel() {
        return switch (this.target.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> class_2561.method_43470((String)"Target: Compass");
            case 1 -> class_2561.method_43470((String)"Target: Title");
            case 2 -> class_2561.method_43470((String)"Target: Both");
        };
    }

    private boolean isMouseOverCompass(double mx, double my) {
        class_310 mc = class_310.method_1551();
        if (mc == null) {
            return false;
        }
        CompassHudConfig cfg = CompassHudConfig.get();
        if (cfg.attachToHotbarCompass) {
            return false;
        }
        CompassHud.HudBounds b = CompassHud.computeBounds(mc, cfg);
        if (b == null) {
            return false;
        }
        if (mx < (double)b.x() || mx >= (double)(b.x() + b.w()) || my < (double)b.y() || my >= (double)(b.y() + b.h())) {
            return false;
        }
        this.compassGrabDx = (int)Math.round(mx) - b.x();
        this.compassGrabDy = (int)Math.round(my) - b.y();
        return true;
    }

    private boolean isMouseOverTitle(double mx, double my) {
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1772 == null) {
            return false;
        }
        String s = "EQUATOR 0\u00b0";
        int w = mc.field_1772.method_1727(s);
        Objects.requireNonNull(mc.field_1772);
        int h = 9;
        double scale = class_3532.method_15350((double)LatitudeConfig.zoneEnterTitleScale, (double)1.0, (double)3.0);
        int cx = this.field_22789 / 2 + LatitudeConfig.zoneEnterTitleOffsetX;
        int cy = this.field_22790 / 2 + LatitudeConfig.zoneEnterTitleOffsetY;
        double halfW = (double)w * scale / 2.0;
        double halfH = (double)h * scale / 2.0;
        double pad = 6.0;
        return mx >= (double)cx - halfW - pad && mx <= (double)cx + halfW + pad && my >= (double)cy - halfH - pad && my <= (double)cy + halfH + pad;
    }

    private static int snap(int v, int step) {
        if (step <= 1) {
            return v;
        }
        return Math.round((float)v / (float)step) * step;
    }

    private static int clamp(int v, int lo, int hi) {
        return Math.max(lo, Math.min(hi, v));
    }

    private static String textColorName(int rgb) {
        int c = rgb & 0xFFFFFF;
        if (c == 0) {
            return "BLACK";
        }
        if (c == 0xFFFF00) {
            return "YELLOW";
        }
        if (c == 0xFF0000) {
            return "RED";
        }
        if (c == 65535) {
            return "CYAN";
        }
        return "WHITE";
    }

    private static int textColorRgb(String name) {
        return switch (name) {
            case "BLACK" -> 0;
            case "YELLOW" -> 0xFFFF00;
            case "RED" -> 0xFF0000;
            case "CYAN" -> 65535;
            default -> 0xFFFFFF;
        };
    }

    private static String bgColorName(int rgb) {
        int c = rgb & 0xFFFFFF;
        if (c == 0xFFFFFF) {
            return "WHITE";
        }
        if (c == 0x111111) {
            return "DARK_GRAY";
        }
        if (c == 727866) {
            return "BLUE";
        }
        return "BLACK";
    }

    private static int bgColorRgb(String name) {
        return switch (name) {
            case "WHITE" -> 0xFFFFFF;
            case "DARK_GRAY" -> 0x111111;
            case "BLUE" -> 727866;
            default -> 0;
        };
    }

    private static enum Target {
        COMPASS,
        TITLE,
        BOTH;

    }

    private static enum DragElement {
        NONE,
        COMPASS,
        TITLE;

    }

    private static final class FloatSlider
    extends class_357 {
        private final class_2561 label;
        private final float min;
        private final float max;
        private final FloatConsumer onChange;

        private FloatSlider(int x, int y, int width, int height, class_2561 label, float min, float max, float initial, FloatConsumer onChange) {
            super(x, y, width, height, (class_2561)class_2561.method_43473(), FloatSlider.toNorm(initial, min, max));
            this.label = label;
            this.min = min;
            this.max = max;
            this.onChange = onChange;
            this.method_25346();
        }

        protected void method_25346() {
            this.method_25355((class_2561)class_2561.method_43470((String)(this.label.getString() + ": " + FloatSlider.format(this.getValue()))));
        }

        protected void method_25344() {
            this.onChange.accept(this.getValue());
        }

        private float getValue() {
            float v = this.min + (this.max - this.min) * (float)this.field_22753;
            return class_3532.method_15363((float)v, (float)this.min, (float)this.max);
        }

        private static double toNorm(float v, float min, float max) {
            if (max == min) {
                return 0.0;
            }
            return (v - min) / (max - min);
        }

        private static String format(float v) {
            return String.format(Locale.ROOT, "%.2f", Float.valueOf(v));
        }
    }

    private static interface FloatConsumer {
        public void accept(float var1);
    }

    private static final class IntSlider
    extends class_357 {
        private final class_2561 label;
        private final int min;
        private final int max;
        private final IntConsumer onChange;

        private IntSlider(int x, int y, int width, int height, class_2561 label, int min, int max, int initial, IntConsumer onChange) {
            super(x, y, width, height, (class_2561)class_2561.method_43473(), IntSlider.toNorm(initial, min, max));
            this.label = label;
            this.min = min;
            this.max = max;
            this.onChange = onChange;
            this.method_25346();
        }

        protected void method_25346() {
            this.method_25355((class_2561)class_2561.method_43470((String)(this.label.getString() + ": " + this.getValue())));
        }

        protected void method_25344() {
            this.onChange.accept(this.getValue());
        }

        private int getValue() {
            return class_3532.method_15340((int)((int)Math.round((double)this.min + (double)(this.max - this.min) * this.field_22753)), (int)this.min, (int)this.max);
        }

        private static double toNorm(int v, int min, int max) {
            if (max == min) {
                return 0.0;
            }
            return (double)(v - min) / (double)(max - min);
        }
    }

    private static interface IntConsumer {
        public void accept(int var1);
    }

    private static final class StepSlider
    extends class_357 {
        private final class_2561 label;
        private final double min;
        private final double max;
        private final double step;
        private final DoubleConsumer onChange;

        private StepSlider(int x, int y, int width, int height, class_2561 label, double min, double max, double step, double initial, DoubleConsumer onChange) {
            super(x, y, width, height, (class_2561)class_2561.method_43473(), StepSlider.toNorm(initial, min, max));
            this.label = label;
            this.min = min;
            this.max = max;
            this.step = step;
            this.onChange = onChange;
            this.method_25346();
        }

        protected void method_25346() {
            this.method_25355((class_2561)class_2561.method_43470((String)(this.label.getString() + ": " + StepSlider.format(this.getValue()))));
        }

        protected void method_25344() {
            this.onChange.accept(this.getValue());
        }

        private double getValue() {
            double q;
            if (this.max <= this.min) {
                return this.min;
            }
            double raw = this.min + (this.max - this.min) * this.field_22753;
            double d = q = this.step > 0.0 ? (double)Math.round(raw / this.step) * this.step : raw;
            if (q < this.min) {
                q = this.min;
            }
            if (q > this.max) {
                q = this.max;
            }
            return q;
        }

        private static double toNorm(double v, double min, double max) {
            if (max == min) {
                return 0.0;
            }
            return (v - min) / (max - min);
        }

        private static String format(double v) {
            return String.format(Locale.ROOT, "%.1f", v);
        }
    }

    private static interface DoubleConsumer {
        public void accept(double var1);
    }
}

