/*
 * Decompiled with CFR 0.152.
 */
package com.example.globe.client;

import com.example.globe.client.CompassHudConfig;
import com.example.globe.client.LatitudeConfig;
import com.example.globe.client.LatitudeHudStudioScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5676;
import net.minecraft.class_7919;

public class LatitudeSettingsScreen
extends class_437 {
    private final class_437 parent;
    private int scrollY = 0;
    private int contentHeight = 0;
    private final List<class_339> layoutWidgets = new ArrayList<class_339>();
    private final List<Integer> layoutBaseYs = new ArrayList<Integer>();

    public LatitudeSettingsScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Latitude Settings"));
        this.parent = parent;
    }

    protected void method_25426() {
        CompassHudConfig cfg = CompassHudConfig.get();
        LatitudeConfig latCfg = LatitudeConfig.get();
        this.layoutWidgets.clear();
        this.layoutBaseYs.clear();
        int y = 28;
        int w = 220;
        int h = 20;
        int columnX = (this.field_22789 - w) / 2;
        int baseY = y;
        class_5676 wZoneTitle = (class_5676)this.method_37063((class_364)class_5676.method_32606(v -> class_2561.method_43470((String)(v != false ? "ON" : "OFF")), (Object)LatitudeConfig.zoneEnterTitleEnabled).method_32624((Object[])new Boolean[]{true, false}).method_32617(columnX, y, w, h, (class_2561)class_2561.method_43470((String)"Zone Enter Title"), (btn, value) -> {
            LatitudeConfig.zoneEnterTitleEnabled = value;
        }));
        this.layoutWidgets.add((class_339)wZoneTitle);
        this.layoutBaseYs.add(baseY);
        baseY = y += 24;
        class_5676 wWarnText = (class_5676)this.method_37063((class_364)class_5676.method_32606(v -> class_2561.method_43470((String)(v != false ? "ON" : "OFF")), (Object)LatitudeConfig.showWarningMessages).method_32624((Object[])new Boolean[]{true, false}).method_32617(columnX, y, w, h, (class_2561)class_2561.method_43470((String)"Warning messages"), (btn, value) -> {
            LatitudeConfig.showWarningMessages = value;
            LatitudeConfig.saveCurrent();
        }));
        wWarnText.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Show/hide on-screen warning text (fog/particles/effects still apply).")));
        this.layoutWidgets.add((class_339)wWarnText);
        this.layoutBaseYs.add(baseY);
        baseY = y += 24;
        StepSlider wTitleSec = (StepSlider)this.method_37063((class_364)new StepSlider(columnX, y, w, h, (class_2561)class_2561.method_43470((String)"Title Duration (seconds)"), 2.0, 10.0, 0.5, LatitudeConfig.zoneEnterTitleSeconds, v -> {
            LatitudeConfig.zoneEnterTitleSeconds = v;
        }));
        this.layoutWidgets.add((class_339)wTitleSec);
        this.layoutBaseYs.add(baseY);
        baseY = y += 24;
        class_5676 wShowMode = (class_5676)this.method_37063((class_364)class_5676.method_75345(this::showModeLabel, () -> cfg.showMode).method_32624((Object[])CompassHudConfig.ShowMode.values()).method_32617(columnX, y, w, h, (class_2561)class_2561.method_43470((String)"Show Mode"), (btn, value) -> {
            cfg.showMode = value;
        }));
        this.layoutWidgets.add((class_339)wShowMode);
        this.layoutBaseYs.add(baseY);
        baseY = y += 24;
        class_4185 wHudStudio = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"HUD Studio"), b -> class_310.method_1551().method_1507((class_437)new LatitudeHudStudioScreen(this))).method_46434(columnX, y, w, 20).method_46431());
        this.layoutWidgets.add((class_339)wHudStudio);
        this.layoutBaseYs.add(baseY);
        baseY = y += 24;
        class_4185 wDone = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Done"), b -> {
            CompassHudConfig.saveCurrent();
            LatitudeConfig.saveCurrent();
            if (this.field_22787 != null) {
                this.field_22787.method_1507(this.parent);
            }
        }).method_46434(columnX, y, 70, 20).method_46431());
        this.layoutWidgets.add((class_339)wDone);
        this.layoutBaseYs.add(baseY);
        baseY = y;
        class_4185 wReset = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Reset"), b -> {
            LatitudeSettingsScreen.applyDefaults(cfg);
            LatitudeSettingsScreen.applyDefaults(latCfg);
            CompassHudConfig.saveCurrent();
            LatitudeConfig.saveCurrent();
            this.method_37067();
            this.method_25426();
        }).method_46434(columnX + 150, y, 70, 20).method_46431());
        this.layoutWidgets.add((class_339)wReset);
        this.layoutBaseYs.add(baseY);
        this.contentHeight = y += 40;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_52752(context);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 10, -1);
        int maxScroll = Math.max(0, this.contentHeight - (this.field_22790 - 20));
        if (this.scrollY < 0) {
            this.scrollY = 0;
        }
        if (this.scrollY > maxScroll) {
            this.scrollY = maxScroll;
        }
        for (int i = 0; i < this.layoutWidgets.size(); ++i) {
            boolean visible;
            class_339 w = this.layoutWidgets.get(i);
            int baseY = this.layoutBaseYs.get(i);
            int drawY = baseY - this.scrollY;
            w.method_46419(drawY);
            w.field_22764 = visible = drawY > -40 && drawY < this.field_22790 + 40;
            w.field_22763 = visible;
        }
        super.method_25394(context, mouseX, mouseY, delta);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int maxScroll = Math.max(0, this.contentHeight - (this.field_22790 - 20));
        this.scrollY -= (int)Math.signum(verticalAmount) * 18;
        this.scrollY = Math.max(0, Math.min(maxScroll, this.scrollY));
        return true;
    }

    private class_2561 showModeLabel(CompassHudConfig.ShowMode v) {
        if (v == null) {
            return class_2561.method_43470((String)"Always");
        }
        return switch (v) {
            default -> throw new MatchException(null, null);
            case CompassHudConfig.ShowMode.COMPASS_PRESENT -> class_2561.method_43470((String)"When compass is in inventory");
            case CompassHudConfig.ShowMode.HOLDING_COMPASS -> class_2561.method_43470((String)"When holding compass");
            case CompassHudConfig.ShowMode.ALWAYS -> class_2561.method_43470((String)"Always");
        };
    }

    private static void applyDefaults(CompassHudConfig cfg) {
        cfg.enabled = true;
        cfg.showMode = CompassHudConfig.ShowMode.COMPASS_PRESENT;
        cfg.directionMode = CompassHudConfig.DirectionMode.CARDINAL_8;
        cfg.hAnchor = CompassHudConfig.HAnchor.CENTER;
        cfg.vAnchor = CompassHudConfig.VAnchor.TOP;
        cfg.offsetX = 0;
        cfg.offsetY = 0;
        cfg.scale = 1.0f;
        cfg.padding = 3;
        cfg.showBackground = true;
        cfg.backgroundRgb = 0;
        cfg.backgroundAlpha = 64;
        cfg.textRgb = 0xFFFFFF;
        cfg.textAlpha = 255;
        cfg.shadow = true;
        cfg.showLatitude = true;
        cfg.latitudeDecimals = 0;
        cfg.attachToHotbarCompass = false;
    }

    private static void applyDefaults(LatitudeConfig cfg) {
        LatitudeConfig.zoneEnterTitleEnabled = true;
        LatitudeConfig.zoneEnterTitleSeconds = 6.0;
        LatitudeConfig.zoneEnterTitleScale = 1.8;
        LatitudeConfig.zoneEnterTitleOffsetX = 0;
        LatitudeConfig.zoneEnterTitleOffsetY = -40;
        LatitudeConfig.zoneEnterTitleDraggable = true;
        LatitudeConfig.hudSnapEnabled = true;
        LatitudeConfig.hudSnapPixels = 8;
        LatitudeConfig.showLatitudeDegreesOnCompass = false;
        LatitudeConfig.showZoneBaseDegreesOnTitle = true;
        LatitudeConfig.latitudeBandBlendingEnabled = true;
        LatitudeConfig.latitudeBandBlendWidthFrac = 0.08;
        LatitudeConfig.latitudeBandBoundaryWarpFrac = 0.06;
        LatitudeConfig.debugLatitudeBlend = false;
        LatitudeConfig.showWarningMessages = true;
    }

    private static final class StepSlider
    extends class_357 {
        private final class_2561 label;
        private final double min;
        private final double max;
        private final double step;
        private final DoubleConsumer onChange;

        private StepSlider(int x, int y, int width, int height, class_2561 label, double min, double max, double step, double initial, DoubleConsumer onChange) {
            super(x, y, width, height, (class_2561)class_2561.method_43473(), StepSlider.toNorm(initial, min, max));
            this.label = label;
            this.min = min;
            this.max = max;
            this.step = step;
            this.onChange = onChange;
            this.method_25346();
        }

        protected void method_25346() {
            this.method_25355((class_2561)class_2561.method_43470((String)(this.label.getString() + ": " + StepSlider.format(this.getValue()))));
        }

        protected void method_25344() {
            this.onChange.accept(this.getValue());
        }

        private double getValue() {
            double q;
            if (this.max <= this.min) {
                return this.min;
            }
            double raw = this.min + (this.max - this.min) * this.field_22753;
            double d = q = this.step > 0.0 ? (double)Math.round(raw / this.step) * this.step : raw;
            if (q < this.min) {
                q = this.min;
            }
            if (q > this.max) {
                q = this.max;
            }
            return q;
        }

        private static double toNorm(double v, double min, double max) {
            if (max == min) {
                return 0.0;
            }
            return (v - min) / (max - min);
        }

        private static String format(double v) {
            return String.format(Locale.ROOT, "%.1f", v);
        }
    }

    private static interface DoubleConsumer {
        public void accept(double var1);
    }
}

