/*
 * Decompiled with CFR 0.152.
 */
package com.example.globe.mixin.client;

import com.example.globe.client.GlobeClientState;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_638;
import net.minecraft.class_758;
import org.joml.Vector4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_758.class})
public class FogRendererMixin {
    private static float globe$smoothedEdgeEnd = -1.0f;
    private static float globe$smoothedPoleEnd = -1.0f;
    private static final int EW_FOG_WARN_DISTANCE = 256;
    private static final int EW_FOG_DANGER_DISTANCE = 96;
    private static final int EW_FOG_BLACKOUT_DISTANCE = 20;

    @ModifyVariable(method={"applyFog(Ljava/nio/ByteBuffer;ILorg/joml/Vector4f;FFFFFF)V"}, at=@At(value="HEAD"), argsOnly=true, ordinal=1)
    private float globe$clampEnvironmentalEnd(float environmentalEnd) {
        float clamped = this.globe$computeFogEndClamp(environmentalEnd);
        return clamped;
    }

    @ModifyVariable(method={"applyFog(Ljava/nio/ByteBuffer;ILorg/joml/Vector4f;FFFFFF)V"}, at=@At(value="HEAD"), argsOnly=true, ordinal=3)
    private float globe$clampRenderDistanceEnd(float renderDistanceEnd) {
        float clamped = this.globe$computeFogEndClamp(renderDistanceEnd);
        return clamped;
    }

    @Inject(method={"getFogColor"}, at={@At(value="RETURN")}, cancellable=true)
    private static void globe$mixFogColor(class_4184 camera, float tickDelta, class_638 world, int viewDistance, float skyDarkness, CallbackInfoReturnable<Vector4f> cir) {
        if (!GlobeClientState.isGlobeWorld()) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        if (!GlobeClientState.isGlobeWorld()) {
            return;
        }
        float w = GlobeClientState.computePoleWhiteoutFactor(client.field_1724.method_23321());
        if ((w = Math.max(0.0f, Math.min(1.0f, w))) <= 0.001f) {
            return;
        }
        Vector4f c = (Vector4f)cir.getReturnValue();
        float r = c.x();
        float g = c.y();
        float b = c.z();
        float a = c.w();
        r += (1.0f - r) * w;
        g += (1.0f - g) * w;
        b += (1.0f - b) * w;
        cir.setReturnValue((Object)new Vector4f(r, g, b, a));
    }

    private float globe$computeFogEndClamp(float currentEnd) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1687 == null) {
            return currentEnd;
        }
        if (!client.field_1687.method_27983().method_29177().equals((Object)class_1937.field_25179.method_29177())) {
            FogRendererMixin.globe$resetSmoothing();
            return currentEnd;
        }
        if (!GlobeClientState.isGlobeWorld()) {
            FogRendererMixin.globe$resetSmoothing();
            return currentEnd;
        }
        float poleDesired = GlobeClientState.computePoleFogEnd(client.field_1724.method_23321());
        float edgeDesired = GlobeClientState.computeEwFogEnd(client.field_1724.method_23317());
        float poleEnd = -1.0f;
        if (poleDesired >= 0.0f) {
            poleEnd = globe$smoothedPoleEnd = FogRendererMixin.globe$smoothToward(globe$smoothedPoleEnd, poleDesired, 0.18f);
        } else {
            globe$smoothedPoleEnd = -1.0f;
        }
        float edgeEnd = -1.0f;
        if (edgeDesired >= 0.0f) {
            edgeEnd = globe$smoothedEdgeEnd = FogRendererMixin.globe$smoothToward(globe$smoothedEdgeEnd, edgeDesired, 0.18f);
        } else {
            globe$smoothedEdgeEnd = -1.0f;
        }
        float clamped = currentEnd;
        if (poleEnd >= 0.0f) {
            clamped = Math.min(clamped, poleEnd);
        }
        if (edgeEnd >= 0.0f) {
            clamped = Math.min(clamped, edgeEnd);
        }
        return FogRendererMixin.globe$sanitizeFogEnd(currentEnd, clamped);
    }

    private static float globe$smoothToward(float prev, float target, float alpha) {
        if (prev < 0.0f) {
            return target;
        }
        return prev + (target - prev) * alpha;
    }

    private static float globe$sanitizeFogEnd(float currentEnd, float clamped) {
        if (Float.isNaN(clamped) || Float.isInfinite(clamped)) {
            return currentEnd;
        }
        float safe = clamped;
        safe = Math.min(safe, currentEnd);
        if ((safe = Math.max(2.0f, safe)) < 0.0f) {
            safe = currentEnd;
        }
        return safe;
    }

    private static void globe$resetSmoothing() {
        globe$smoothedEdgeEnd = -1.0f;
        globe$smoothedPoleEnd = -1.0f;
    }
}

