/*
 * Decompiled with CFR 0.152.
 */
package com.example.globe.util;

import net.minecraft.class_2784;

public final class LatitudeMath {
    public static final double EQUATOR_MAX_FRAC = 0.1;
    public static final double TROPICAL_MAX_FRAC = 0.3;
    public static final double SUBTROPICAL_MAX_FRAC = 0.5;
    public static final double TEMPERATE_MAX_FRAC = 0.666;
    public static final double SUBPOLAR_MAX_FRAC = 0.783;
    public static final int EQUATOR_MAX_DEG = (int)Math.ceil(9.0);
    public static final int TROPICAL_MAX_DEG = (int)Math.ceil(27.0);
    public static final int SUBTROPICAL_MAX_DEG = (int)Math.ceil(45.0);
    public static final int TEMPERATE_MAX_DEG = (int)Math.ceil(59.940000000000005);
    public static final int SUBPOLAR_MAX_DEG = (int)Math.ceil(70.47);
    public static final double POLAR_START_FRAC = 0.783;
    public static final int POLAR_START_DEG = (int)Math.floor(70.47);

    private LatitudeMath() {
    }

    public static double worldRadiusBlocks(class_2784 border) {
        if (border == null) {
            return 0.0;
        }
        return border.method_11965() * 0.5;
    }

    public static double absLatFraction(class_2784 border, double z) {
        if (border == null) {
            return 0.0;
        }
        double radius = LatitudeMath.worldRadiusBlocks(border);
        if (radius <= 1.0E-4) {
            return 0.0;
        }
        double centerZ = border.method_11980();
        double frac = Math.abs(z - centerZ) / radius;
        if (frac < 0.0) {
            frac = 0.0;
        }
        if (frac > 1.0) {
            frac = 1.0;
        }
        return frac;
    }

    public static double absLatDegExact(class_2784 border, double z) {
        return LatitudeMath.absLatFraction(border, z) * 90.0;
    }

    public static int latitudeDegrees(class_2784 border, double z) {
        int deg = (int)Math.round(LatitudeMath.absLatDegExact(border, z));
        if (deg < 0) {
            deg = 0;
        }
        if (deg > 90) {
            deg = 90;
        }
        return deg;
    }

    public static char hemisphere(class_2784 border, double z) {
        double centerZ = border != null ? border.method_11980() : 0.0;
        return z < centerZ ? (char)'N' : 'S';
    }

    public static String formatLatitudeDeg(class_2784 border, double z) {
        int deg = LatitudeMath.latitudeDegrees(border, z);
        if (deg == 0) {
            return "0\u00b0";
        }
        char hemi = LatitudeMath.hemisphere(border, z);
        return deg + "\u00b0" + hemi;
    }

    public static LatitudeZone zoneForDeg(int deg) {
        if (deg < EQUATOR_MAX_DEG) {
            return LatitudeZone.EQUATOR;
        }
        if (deg < TROPICAL_MAX_DEG) {
            return LatitudeZone.TROPICAL;
        }
        if (deg < SUBTROPICAL_MAX_DEG) {
            return LatitudeZone.SUBTROPICAL;
        }
        if (deg < TEMPERATE_MAX_DEG) {
            return LatitudeZone.TEMPERATE;
        }
        if (deg < SUBPOLAR_MAX_DEG) {
            return LatitudeZone.SUBPOLAR;
        }
        return LatitudeZone.POLAR;
    }

    public static LatitudeZone zoneFor(class_2784 border, double z) {
        double t = LatitudeMath.absLatFraction(border, z);
        if (t < 0.1) {
            return LatitudeZone.EQUATOR;
        }
        if (t < 0.3) {
            return LatitudeZone.TROPICAL;
        }
        if (t < 0.5) {
            return LatitudeZone.SUBTROPICAL;
        }
        if (t < 0.666) {
            return LatitudeZone.TEMPERATE;
        }
        if (t < 0.783) {
            return LatitudeZone.SUBPOLAR;
        }
        return LatitudeZone.POLAR;
    }

    public static String zoneKey(class_2784 border, double z) {
        return LatitudeMath.zoneFor(border, z).name();
    }

    public static double spawnFracForZoneKey(String zoneKey) {
        if (zoneKey == null) {
            return 0.0;
        }
        return switch (zoneKey) {
            case "EQUATOR" -> 0.0;
            case "TROPICAL" -> 0.2;
            case "SUBTROPICAL" -> 0.4;
            case "TEMPERATE" -> 0.583;
            case "SUBPOLAR" -> 0.725;
            case "POLAR" -> 0.83;
            default -> 0.0;
        };
    }

    public static int zoneCenterDeg(String zoneKey) {
        double t = LatitudeMath.spawnFracForZoneKey(zoneKey);
        int deg = (int)Math.round(t * 90.0);
        if (deg < 0) {
            deg = 0;
        }
        if (deg > 90) {
            deg = 90;
        }
        return deg;
    }

    public static enum LatitudeZone {
        EQUATOR,
        TROPICAL,
        SUBTROPICAL,
        TEMPERATE,
        SUBPOLAR,
        POLAR;

    }
}

