/*
 * Decompiled with CFR 0.152.
 */
package com.example.globe.util;

public final class ValueNoise2D {
    private ValueNoise2D() {
    }

    private static long mix64(long z) {
        z ^= z >>> 33;
        z *= -49064778989728563L;
        z ^= z >>> 33;
        z *= -4265267296055464877L;
        z ^= z >>> 33;
        return z;
    }

    private static double toUnit(long h) {
        return (double)(h >>> 11) * (double)1.110223E-16f;
    }

    private static double smooth(double t) {
        return t * t * (3.0 - 2.0 * t);
    }

    private static double lerp(double a, double b, double t) {
        return a + (b - a) * t;
    }

    private static double valueAt(long seed, int x, int z) {
        long h = seed ^ (long)x << 32 ^ (long)z & 0xFFFFFFFFL;
        return ValueNoise2D.toUnit(ValueNoise2D.mix64(h));
    }

    public static double sampleBlocks(long seed, int blockX, int blockZ, int scaleBlocks) {
        double x = (double)blockX / (double)scaleBlocks;
        double z = (double)blockZ / (double)scaleBlocks;
        int x0 = (int)Math.floor(x);
        int z0 = (int)Math.floor(z);
        double tx = ValueNoise2D.smooth(x - (double)x0);
        double tz = ValueNoise2D.smooth(z - (double)z0);
        double v00 = ValueNoise2D.valueAt(seed, x0, z0);
        double v10 = ValueNoise2D.valueAt(seed, x0 + 1, z0);
        double v01 = ValueNoise2D.valueAt(seed, x0, z0 + 1);
        double v11 = ValueNoise2D.valueAt(seed, x0 + 1, z0 + 1);
        return ValueNoise2D.lerp(ValueNoise2D.lerp(v00, v10, tx), ValueNoise2D.lerp(v01, v11, tx), tz);
    }
}

