/*
 * Decompiled with CFR 0.152.
 */
package com.example.globe.world;

import com.example.globe.client.LatitudeConfig;
import com.example.globe.util.ValueNoise2D;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Locale;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import net.minecraft.class_7924;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LatitudeBiomes {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"LatitudeBiomes");
    private static final String FALLBACK_EQUATOR = "minecraft:plains";
    private static final String FALLBACK_TEMPERATE = "minecraft:plains";
    private static final String FALLBACK_SUBPOLAR = "minecraft:snowy_plains";
    private static final String FALLBACK_POLAR = "minecraft:snowy_slopes";
    private static final String FALLBACK_ARID = "minecraft:desert";
    private static final String FALLBACK_TROPICAL = "minecraft:jungle";
    private static final class_6862<class_1959> LAT_EQUATOR = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60655((String)"globe", (String)"lat_equator"));
    private static final class_6862<class_1959> LAT_TROPICAL = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60655((String)"globe", (String)"lat_tropical"));
    private static final class_6862<class_1959> LAT_TEMPERATE = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60655((String)"globe", (String)"lat_temperate"));
    private static final class_6862<class_1959> LAT_SUBPOLAR = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60655((String)"globe", (String)"lat_subpolar"));
    private static final class_6862<class_1959> LAT_POLAR = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60655((String)"globe", (String)"lat_polar"));
    private static final class_6862<class_1959> LAT_ARID = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60655((String)"globe", (String)"lat_arid"));
    private static final class_6862<class_1959> LAT_TROPICS = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60655((String)"globe", (String)"lat_tropics"));
    private static final class_6862<class_1959> LAT_TRANS_ARID_TROPICS_1 = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60655((String)"globe", (String)"lat_trans_arid_tropics_1"));
    private static final class_6862<class_1959> LAT_TRANS_ARID_TROPICS_2 = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60655((String)"globe", (String)"lat_trans_arid_tropics_2"));
    private static final class_6862<class_1959> LAT_OCEAN_TROPICAL = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60655((String)"globe", (String)"lat_ocean_tropical"));
    private static final class_6862<class_1959> LAT_OCEAN_TEMPERATE = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60655((String)"globe", (String)"lat_ocean_temperate"));
    private static final class_6862<class_1959> LAT_OCEAN_SUBPOLAR = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60655((String)"globe", (String)"lat_ocean_subpolar"));
    private static final class_6862<class_1959> LAT_OCEAN_POLAR = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60655((String)"globe", (String)"lat_ocean_polar"));
    private static final class_6862<class_1959> OCEAN_WARM = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60655((String)"globe", (String)"ocean_warm"));
    private static final class_6862<class_1959> OCEAN_MID = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60655((String)"globe", (String)"ocean_mid"));
    private static final class_6862<class_1959> OCEAN_COLD = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60655((String)"globe", (String)"ocean_cold"));
    private static final class_6862<class_1959> OCEAN_FROZEN = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60655((String)"globe", (String)"ocean_frozen"));
    private static final class_6862<class_1959> OCEAN_DEEP_FROZEN = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60655((String)"globe", (String)"ocean_deep_frozen"));
    private static final int OCEAN_BAND_BLOCKS = 2500;
    private static final int VARIANT_CELL_SIZE_BLOCKS = 1024;

    private LatitudeBiomes() {
    }

    private static long mix64(long z) {
        z = (z ^ z >>> 33) * -49064778989728563L;
        z = (z ^ z >>> 33) * -4265267296055464877L;
        return z ^ z >>> 33;
    }

    private static double hash01(long seed, int x, int z, long salt) {
        long h = seed ^ salt;
        h ^= (long)x * -7046029254386353131L;
        h ^= (long)z * -4417276706812531889L;
        h = LatitudeBiomes.mix64(h);
        return (double)(h >>> 11) * (double)1.110223E-16f;
    }

    private static double smoothstep(double t) {
        t = Math.max(0.0, Math.min(1.0, t));
        return t * t * (3.0 - 2.0 * t);
    }

    private static double blobNoise01(long seed, int chunkX, int chunkZ, int patchSizeChunks, long salt) {
        int gx = Math.floorDiv(chunkX, patchSizeChunks);
        int gz = Math.floorDiv(chunkZ, patchSizeChunks);
        int x0 = gx * patchSizeChunks;
        int z0 = gz * patchSizeChunks;
        int x1 = x0 + patchSizeChunks;
        int z1 = z0 + patchSizeChunks;
        double fx = (double)(chunkX - x0) / (double)patchSizeChunks;
        double fz = (double)(chunkZ - z0) / (double)patchSizeChunks;
        double u = LatitudeBiomes.smoothstep(fx);
        double v = LatitudeBiomes.smoothstep(fz);
        double n00 = LatitudeBiomes.hash01(seed, x0, z0, salt);
        double n10 = LatitudeBiomes.hash01(seed, x1, z0, salt);
        double n01 = LatitudeBiomes.hash01(seed, x0, z1, salt);
        double n11 = LatitudeBiomes.hash01(seed, x1, z1, salt);
        double nx0 = n00 + (n10 - n00) * u;
        double nx1 = n01 + (n11 - n01) * u;
        return nx0 + (nx1 - nx0) * v;
    }

    public static class_6880<class_1959> pick(class_2378<class_1959> biomes, class_6880<class_1959> base, int blockX, int blockZ, int borderRadiusBlocks) {
        if (base.method_40220(class_6908.field_36510)) {
            return base;
        }
        if (borderRadiusBlocks <= 0) {
            return base;
        }
        int lat = Math.abs(blockZ);
        int absX = Math.abs(blockX);
        double t = (double)lat / (double)borderRadiusBlocks;
        int bandIndex = LatitudeBiomes.latitudeBandIndexWithBlend(blockX, blockZ, borderRadiusBlocks);
        if (base.method_40220(class_6908.field_36511)) {
            if (t >= 0.8) {
                try {
                    return LatitudeBiomes.biome(biomes, "minecraft:frozen_river");
                }
                catch (Throwable ignored) {
                    return base;
                }
            }
            try {
                return LatitudeBiomes.biome(biomes, "minecraft:river");
            }
            catch (Throwable ignored) {
                return base;
            }
        }
        if (base.method_40220(class_6908.field_36509)) {
            return LatitudeBiomes.oceanByLatitudeBandOrBase(biomes, base, blockX, blockZ, bandIndex);
        }
        if (absX >= borderRadiusBlocks - 2500 && t < 0.93) {
            return LatitudeBiomes.oceanByLatitude(biomes, blockX, blockZ, bandIndex, t);
        }
        return switch (bandIndex) {
            case 0 -> LatitudeBiomes.pickTropicalGradient(biomes, base, blockX, blockZ, t);
            case 1 -> LatitudeBiomes.pickFromLandTagOrFallback(biomes, LAT_EQUATOR, blockX, blockZ, 1, "minecraft:plains");
            case 2 -> LatitudeBiomes.pickFromLandTagOrFallback(biomes, LAT_TEMPERATE, blockX, blockZ, 2, "minecraft:plains");
            case 3 -> LatitudeBiomes.pickFromLandTagOrFallback(biomes, LAT_SUBPOLAR, blockX, blockZ, 3, FALLBACK_SUBPOLAR);
            default -> LatitudeBiomes.pickFromLandTagOrFallback(biomes, LAT_POLAR, blockX, blockZ, 4, FALLBACK_POLAR);
        };
    }

    private static class_6880<class_1959> pickTropicalGradient(class_2378<class_1959> biomes, class_6880<class_1959> base, int blockX, int blockZ, double t) {
        int chunkX = blockX >> 4;
        int chunkZ = blockZ >> 4;
        long seed = 0L;
        double u = LatitudeBiomes.clamp(t / 0.18, 0.0, 1.0);
        double ladderT = 1.0 - u;
        double jitterN = LatitudeBiomes.blobNoise01(seed, chunkX, chunkZ, 8, -4982089500409860083L) * 2.0 - 1.0;
        double tJitter = ladderT + jitterN * 0.12;
        tJitter = LatitudeBiomes.clamp(tJitter, 0.0, 1.0);
        tJitter = LatitudeBiomes.smoothstep(tJitter);
        int step = LatitudeBiomes.clampInt((int)Math.floor(tJitter * 4.0), 0, 3);
        class_6862<class_1959> chosen = switch (step) {
            case 1 -> LAT_TRANS_ARID_TROPICS_1;
            case 2 -> LAT_TRANS_ARID_TROPICS_2;
            case 3 -> LAT_TROPICS;
            default -> LAT_ARID;
        };
        String fallback = switch (step) {
            case 1, 2 -> "minecraft:savanna";
            case 3 -> FALLBACK_TROPICAL;
            default -> FALLBACK_ARID;
        };
        return LatitudeBiomes.pickFromTagNoiseOrFallback(biomes, chosen, blockX, blockZ, 100 + step, fallback);
    }

    private static class_6880<class_1959> oceanByLatitudeBandOrBase(class_2378<class_1959> biomes, class_6880<class_1959> base, int blockX, int blockZ, int bandIndex) {
        if (bandIndex == 0) {
            return LatitudeBiomes.pickFromTagNoiseOrFallback(biomes, LAT_OCEAN_TROPICAL, blockX, blockZ, 20, "minecraft:warm_ocean", "minecraft:lukewarm_ocean", "minecraft:deep_lukewarm_ocean");
        }
        if (bandIndex == 1 || bandIndex == 2) {
            return LatitudeBiomes.pickFromTagNoiseOrFallback(biomes, LAT_OCEAN_TEMPERATE, blockX, blockZ, 21, "minecraft:ocean", "minecraft:deep_ocean");
        }
        if (bandIndex == 3) {
            return LatitudeBiomes.pickFromTagNoiseOrFallback(biomes, LAT_OCEAN_SUBPOLAR, blockX, blockZ, 22, "minecraft:cold_ocean", "minecraft:deep_cold_ocean");
        }
        return LatitudeBiomes.pickFromTagNoiseOrFallback(biomes, LAT_OCEAN_POLAR, blockX, blockZ, 23, "minecraft:frozen_ocean", "minecraft:deep_frozen_ocean");
    }

    private static class_6880<class_1959> oceanByLatitude(class_2378<class_1959> biomes, int blockX, int blockZ, int bandIndex, double t) {
        if (bandIndex == 0) {
            return LatitudeBiomes.pickFromTagOrFallback(biomes, OCEAN_WARM, blockX, blockZ, 10, "minecraft:warm_ocean");
        }
        if (bandIndex == 1) {
            return LatitudeBiomes.pickFromTagOrFallback(biomes, OCEAN_MID, blockX, blockZ, 11, "minecraft:ocean");
        }
        if (bandIndex == 2) {
            return LatitudeBiomes.pickFromTagOrFallback(biomes, OCEAN_COLD, blockX, blockZ, 12, "minecraft:cold_ocean");
        }
        if (bandIndex == 3 && t < 0.93) {
            return LatitudeBiomes.pickFromTagOrFallback(biomes, OCEAN_FROZEN, blockX, blockZ, 13, "minecraft:frozen_ocean");
        }
        return LatitudeBiomes.pickFromTagOrFallback(biomes, OCEAN_DEEP_FROZEN, blockX, blockZ, 14, "minecraft:deep_frozen_ocean");
    }

    private static int latitudeBandIndexWithBlend(int blockX, int blockZ, int radius) {
        int chosenBandIndex;
        int boundary;
        int upperBandIndex;
        int lowerBandIndex;
        if (radius <= 0) {
            return 0;
        }
        int absZ = Math.abs(blockZ);
        double t = (double)absZ / (double)radius;
        double latDegAbs = t * 90.0;
        if (latDegAbs < 8.0) {
            return 0;
        }
        int bandIndex = LatitudeBiomes.crispBandIndex(t);
        if (!LatitudeConfig.latitudeBandBlendingEnabled) {
            return bandIndex;
        }
        double blendWidth = LatitudeBiomes.clamp((double)radius * LatitudeConfig.latitudeBandBlendWidthFrac, 120.0, 700.0);
        double warpMax = LatitudeBiomes.clamp((double)radius * LatitudeConfig.latitudeBandBoundaryWarpFrac, 0.0, blendWidth);
        if (blendWidth <= 0.0) {
            return bandIndex;
        }
        if (bandIndex <= 0) {
            lowerBandIndex = 0;
            upperBandIndex = 1;
            boundary = LatitudeBiomes.bandBoundaryBlocks(0, radius);
        } else if (bandIndex >= 4) {
            lowerBandIndex = 3;
            upperBandIndex = 4;
            boundary = LatitudeBiomes.bandBoundaryBlocks(3, radius);
        } else {
            int dHi;
            int loBoundary = LatitudeBiomes.bandBoundaryBlocks(bandIndex - 1, radius);
            int hiBoundary = LatitudeBiomes.bandBoundaryBlocks(bandIndex, radius);
            int dLo = Math.abs(absZ - loBoundary);
            if (dLo <= (dHi = Math.abs(absZ - hiBoundary))) {
                lowerBandIndex = bandIndex - 1;
                upperBandIndex = bandIndex;
                boundary = loBoundary;
            } else {
                lowerBandIndex = bandIndex;
                upperBandIndex = bandIndex + 1;
                boundary = hiBoundary;
            }
        }
        double signedDistToBoundary = (double)absZ - (double)boundary;
        if (Math.abs(signedDistToBoundary) > blendWidth) {
            return bandIndex;
        }
        int chunkX = blockX >> 4;
        int chunkZ = blockZ >> 4;
        int PATCH_SIZE_CHUNKS = 6;
        long SALT_BLEND = -6795153568590067944L;
        long SALT_WARP = 1161981756646125696L;
        long seed = 0L;
        double blendNoise01 = LatitudeBiomes.blobNoise01(seed, chunkX, chunkZ, 6, -6795153568590067944L);
        double warpNoise01 = LatitudeBiomes.blobNoise01(seed, chunkX, chunkZ, 8, 1161981756646125696L);
        double warpSigned = warpNoise01 * 2.0 - 1.0;
        double warp = LatitudeBiomes.clamp(warpSigned * warpMax, -blendWidth, blendWidth);
        double dist = signedDistToBoundary + warp;
        double tt = dist / blendWidth * 0.5 + 0.5;
        boolean chooseUpper = blendNoise01 < (tt = LatitudeBiomes.smoothstep(tt));
        int n = chosenBandIndex = chooseUpper ? upperBandIndex : lowerBandIndex;
        if (LatitudeConfig.debugLatitudeBlend && Math.abs(dist) <= blendWidth && (blockX & 0xF) == 0 && (blockZ & 0xF) == 0) {
            LOGGER.info("[LAT_BLEND] cx={} cz={} t={} noise={} pick={}", new Object[]{chunkX, chunkZ, String.format(Locale.ROOT, "%.2f", tt), String.format(Locale.ROOT, "%.2f", blendNoise01), chooseUpper ? "UPPER" : "LOWER"});
        }
        return chosenBandIndex;
    }

    private static int crispBandIndex(double t) {
        if (t < 0.18) {
            return 0;
        }
        if (t < 0.6) {
            return 1;
        }
        if (t < 0.8) {
            return 2;
        }
        if (t < 0.93) {
            return 3;
        }
        return 4;
    }

    private static int bandBoundaryBlocks(int boundaryIndex, int radius) {
        return switch (boundaryIndex) {
            case 0 -> (int)Math.round(0.18 * (double)radius);
            case 1 -> (int)Math.round(0.6 * (double)radius);
            case 2 -> (int)Math.round(0.8 * (double)radius);
            default -> (int)Math.round(0.93 * (double)radius);
        };
    }

    private static int clampInt(int v, int lo, int hi) {
        return Math.max(lo, Math.min(hi, v));
    }

    private static double clamp(double v, double lo, double hi) {
        return Math.max(lo, Math.min(hi, v));
    }

    private static class_6880<class_1959> biome(class_2378<class_1959> biomes, String id) {
        class_2960 ident = class_2960.method_60654((String)id);
        return (class_6880)biomes.method_10223(ident).orElseThrow();
    }

    private static class_6880<class_1959> pickFrom(class_2378<class_1959> biomes, int blockX, int blockZ, int bandIndex, String ... options) {
        int cellX = Math.floorDiv(blockX, 1024);
        int cellZ = Math.floorDiv(blockZ, 1024);
        int idx = (int)Long.remainderUnsigned(LatitudeBiomes.hash64(cellX, cellZ, bandIndex), options.length);
        return LatitudeBiomes.biome(biomes, options[idx]);
    }

    private static class_6880<class_1959> pickFromTagOrFallback(class_2378<class_1959> biomes, class_6862<class_1959> tag, int blockX, int blockZ, int bandIndex, String ... fallbackOptions) {
        ArrayList<class_6880> entries = new ArrayList<class_6880>();
        for (class_6880 entry2 : biomes.method_40286(tag)) {
            entries.add(entry2);
        }
        entries.sort(Comparator.comparing(entry -> entry.method_40230().map(key -> key.method_29177().toString()).orElse("")));
        int size = entries.size();
        if (size > 0) {
            int cellX = Math.floorDiv(blockX, 1024);
            int cellZ = Math.floorDiv(blockZ, 1024);
            int idx = (int)Long.remainderUnsigned(LatitudeBiomes.hash64(cellX, cellZ, bandIndex), size);
            return (class_6880)entries.get(idx);
        }
        if (fallbackOptions.length > 0) {
            LOGGER.warn("[Latitude] Biome tag {} is empty/not loaded. Falling back to {}", (Object)tag.comp_327(), (Object)fallbackOptions[0]);
        } else {
            LOGGER.warn("[Latitude] Biome tag {} is empty/not loaded. Falling back to <none>", (Object)tag.comp_327());
        }
        return LatitudeBiomes.pickFrom(biomes, blockX, blockZ, bandIndex, fallbackOptions);
    }

    private static class_6880<class_1959> pickFromLandTagOrFallback(class_2378<class_1959> biomes, class_6862<class_1959> tag, int blockX, int blockZ, int bandIndex, String fallbackBiomeId) {
        ArrayList<class_6880> entries = new ArrayList<class_6880>();
        for (class_6880 entry2 : biomes.method_40286(tag)) {
            entries.add(entry2);
        }
        entries.sort(Comparator.comparing(entry -> entry.method_40230().map(key -> key.method_29177().toString()).orElse("")));
        int size = entries.size();
        if (size <= 0) {
            LOGGER.warn("[Latitude] Biome tag {} is empty/not loaded. Falling back to {}", (Object)tag.comp_327(), (Object)fallbackBiomeId);
            return LatitudeBiomes.biome(biomes, fallbackBiomeId);
        }
        long seed = 0L;
        long salted = seed ^ -7046029254386353131L * (long)bandIndex;
        int scaleBlocks = 2048;
        double n = ValueNoise2D.sampleBlocks(salted, blockX, blockZ, scaleBlocks);
        int idx = (int)Math.floor(n * (double)size);
        if (idx >= size) {
            idx = size - 1;
        }
        return (class_6880)entries.get(idx);
    }

    private static class_6880<class_1959> pickFromTagNoiseOrFallback(class_2378<class_1959> biomes, class_6862<class_1959> tag, int blockX, int blockZ, int bandIndex, String ... fallbackOptions) {
        ArrayList<class_6880> entries = new ArrayList<class_6880>();
        for (class_6880 entry2 : biomes.method_40286(tag)) {
            entries.add(entry2);
        }
        entries.sort(Comparator.comparing(entry -> entry.method_40230().map(key -> key.method_29177().toString()).orElse("")));
        int size = entries.size();
        if (size <= 0) {
            if (fallbackOptions.length > 0) {
                LOGGER.warn("[Latitude] Biome tag {} is empty/not loaded. Falling back to {}", (Object)tag.comp_327(), (Object)fallbackOptions[0]);
            } else {
                LOGGER.warn("[Latitude] Biome tag {} is empty/not loaded. Falling back to <none>", (Object)tag.comp_327());
            }
            return LatitudeBiomes.pickFrom(biomes, blockX, blockZ, bandIndex, fallbackOptions);
        }
        long seed = 0L;
        long salted = seed ^ -7046029254386353131L * (long)bandIndex;
        int scaleBlocks = 2048;
        double n = ValueNoise2D.sampleBlocks(salted, blockX, blockZ, scaleBlocks);
        int idx = (int)Math.floor(n * (double)size);
        if (idx >= size) {
            idx = size - 1;
        }
        return (class_6880)entries.get(idx);
    }

    private static class_6880<class_1959> pickFromTagNoiseOrBase(class_2378<class_1959> biomes, class_6862<class_1959> tag, class_6880<class_1959> base, int blockX, int blockZ, int bandIndex) {
        ArrayList<class_6880> entries = new ArrayList<class_6880>();
        for (class_6880 entry2 : biomes.method_40286(tag)) {
            entries.add(entry2);
        }
        entries.sort(Comparator.comparing(entry -> entry.method_40230().map(key -> key.method_29177().toString()).orElse("")));
        int size = entries.size();
        if (size <= 0) {
            return base;
        }
        long seed = 0L;
        long salted = seed ^ -7046029254386353131L * (long)bandIndex;
        int scaleBlocks = 2048;
        double n = ValueNoise2D.sampleBlocks(salted, blockX, blockZ, scaleBlocks);
        int idx = (int)Math.floor(n * (double)size);
        if (idx >= size) {
            idx = size - 1;
        }
        return (class_6880)entries.get(idx);
    }

    private static long hash64(int x, int z, int bandIndex) {
        long h = -3750763034362895579L;
        h = LatitudeBiomes.fnv1a64(h, x);
        h = LatitudeBiomes.fnv1a64(h, z);
        h = LatitudeBiomes.fnv1a64(h, bandIndex);
        return LatitudeBiomes.mix64(h);
    }

    private static long fnv1a64(long h, long v) {
        h ^= v;
        return h *= 1099511628211L;
    }

    private static boolean isOcean(class_6880<class_1959> biome) {
        return biome.method_40230().map(key -> key.method_29177().method_12832().contains("ocean")).orElse(false);
    }

    private static boolean isRiver(class_6880<class_1959> biome) {
        return biome.method_40230().map(key -> key.method_29177().method_12832().contains("river")).orElse(false);
    }
}

