/*
 * Decompiled with CFR 0.152.
 */
package com.astralis.bundledarrows;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_1657;
import net.minecraft.class_1744;
import net.minecraft.class_1799;
import net.minecraft.class_9276;
import net.minecraft.class_9334;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundledArrowsMod
implements ModInitializer {
    public static final String MOD_ID = "bundledarrows";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"bundledarrows");
    private static final Map<UUID, BundleCache> bundleCacheMap = new HashMap<UUID, BundleCache>();

    public void onInitialize() {
        LOGGER.info("Bundle Arrows Mod inicializado!");
    }

    public static void invalidateCache(class_1657 player) {
        bundleCacheMap.remove(player.method_5667());
    }

    private static BundleCache getCache(class_1657 player) {
        return bundleCacheMap.computeIfAbsent(player.method_5667(), k -> new BundleCache());
    }

    public static class_1799 findArrowInBundle(class_1657 player) {
        BundleCache cache = BundledArrowsMod.getCache(player);
        if (cache.isValid()) {
            return cache.arrowStack.method_7972();
        }
        cache.invalidate();
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_9276 bundleContents;
            class_1799 stack = player.method_31548().method_5438(i);
            if (!stack.method_7909().toString().contains("bundle") || (bundleContents = (class_9276)stack.method_58695(class_9334.field_49650, (Object)class_9276.field_49289)).method_57429()) continue;
            for (class_1799 bundleItem : bundleContents.method_57421()) {
                if (!(bundleItem.method_7909() instanceof class_1744)) continue;
                cache.bundleSlot = i;
                cache.arrowStack = bundleItem.method_7972();
                cache.timestamp = System.currentTimeMillis();
                return cache.arrowStack.method_7972();
            }
        }
        return class_1799.field_8037;
    }

    public static boolean consumeArrowFromBundle(class_1657 player) {
        BundleCache cache = BundledArrowsMod.getCache(player);
        int startSlot = cache.isValid() ? cache.bundleSlot : 0;
        int endSlot = cache.isValid() ? cache.bundleSlot + 1 : player.method_31548().method_5439();
        for (int i = startSlot; i < endSlot; ++i) {
            class_9276 bundleContents;
            class_1799 stack = player.method_31548().method_5438(i);
            if (!stack.method_7909().toString().contains("bundle") || (bundleContents = (class_9276)stack.method_58695(class_9334.field_49650, (Object)class_9276.field_49289)).method_57429()) continue;
            for (class_1799 bundleItem : bundleContents.method_57421()) {
                if (!(bundleItem.method_7909() instanceof class_1744)) continue;
                class_9276 newContents = BundledArrowsMod.removeOneArrowFromBundle(bundleContents);
                stack.method_57379(class_9334.field_49650, (Object)newContents);
                cache.invalidate();
                return true;
            }
        }
        if (cache.isValid()) {
            cache.invalidate();
            return BundledArrowsMod.consumeArrowFromBundle(player);
        }
        return false;
    }

    public static int countArrowsInInventory(class_1657 player) {
        int count = 0;
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_1799 invStack = player.method_31548().method_5438(i);
            if (!(invStack.method_7909() instanceof class_1744)) continue;
            count += invStack.method_7947();
        }
        return count;
    }

    private static class_9276 removeOneArrowFromBundle(class_9276 original) {
        ArrayList<class_1799> items = new ArrayList<class_1799>();
        for (class_1799 item : original.method_57421()) {
            items.add(item.method_7972());
        }
        boolean arrowRemoved = false;
        for (int i = 0; i < items.size(); ++i) {
            class_1799 item = (class_1799)items.get(i);
            if (arrowRemoved || !(item.method_7909() instanceof class_1744)) continue;
            if (item.method_7947() > 1) {
                item.method_7934(1);
            } else {
                items.remove(i);
            }
            arrowRemoved = true;
            break;
        }
        Collections.reverse(items);
        class_9276.class_9277 builder = new class_9276.class_9277(class_9276.field_49289);
        for (class_1799 item : items) {
            if (item.method_7960()) continue;
            builder.method_57432(item);
        }
        return builder.method_57435();
    }

    private static class BundleCache {
        int bundleSlot = -1;
        class_1799 arrowStack = class_1799.field_8037;
        long timestamp = 0L;

        private BundleCache() {
        }

        boolean isValid() {
            return this.bundleSlot != -1 && System.currentTimeMillis() - this.timestamp < 50L;
        }

        void invalidate() {
            this.bundleSlot = -1;
            this.arrowStack = class_1799.field_8037;
            this.timestamp = 0L;
        }
    }
}

