/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.api.event.bestiary;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.VariantHolder;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.event.IModBusEvent;
import org.confluence.terraentity.api.entity.IVariant;

public class RegisterBestiaryKeyEvent
extends Event
implements IModBusEvent {
    private static final Map<EntityType<?>, Factory<?>> factories = Maps.newIdentityHashMap();

    public <T extends LivingEntity> void register(EntityType<T> type, Factory<T> factory) {
        if (!factories.containsKey(type)) {
            factories.put(type, factory);
        }
    }

    public static String getKey(LivingEntity living) {
        EntityType type = living.getType();
        Factory<?> factory = factories.get(type);
        if (factory == null) {
            return type.getDescriptionId();
        }
        return factory.get(type, living);
    }

    public static <V, T extends LivingEntity> Factory<T> vanillaVariant(Function<V, String> toString) {
        return (type, living) -> type.getDescriptionId() + "." + (String)toString.apply(((VariantHolder)living).getVariant());
    }

    public static <V, T extends LivingEntity> Factory<T> terraVariant(Function<V, String> toString) {
        return (type, living) -> type.getDescriptionId() + "." + (String)toString.apply(((IVariant)living).getTEVariant());
    }

    @FunctionalInterface
    public static interface Factory<T extends Entity> {
        public String get(EntityType<T> var1, T var2);
    }
}

