/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.api.lunar;

import java.util.List;
import org.confluence.mod.api.lunar.LunarYear;
import org.confluence.mod.api.lunar.NineStar;
import org.confluence.mod.api.lunar.Solar;
import org.confluence.mod.api.lunar.util.LunarUtil;

public class LunarMonth {
    private final int year;
    private final int month;
    private final int dayCount;
    private final double firstJulianDay;
    private final int index;
    private final int zhiIndex;

    public LunarMonth(int lunarYear, int lunarMonth, int dayCount, double firstJulianDay, int index) {
        this.year = lunarYear;
        this.month = lunarMonth;
        this.dayCount = dayCount;
        this.firstJulianDay = firstJulianDay;
        this.index = index;
        this.zhiIndex = (Math.abs(lunarMonth) - 1 + 2) % 12;
    }

    public static LunarMonth fromYm(int lunarYear, int lunarMonth) {
        return LunarYear.fromYear(lunarYear).getMonth(lunarMonth);
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public boolean isLeap() {
        return this.month < 0;
    }

    public int getDayCount() {
        return this.dayCount;
    }

    public int getIndex() {
        return this.index;
    }

    public int getZhiIndex() {
        return this.zhiIndex;
    }

    public int getGanIndex() {
        int offset = (LunarYear.fromYear(this.year).getGanIndex() + 1) % 5 * 2;
        return (Math.abs(this.month) - 1 + offset) % 10;
    }

    public String getGan() {
        return LunarUtil.GAN[this.getGanIndex() + 1];
    }

    public String getZhi() {
        return LunarUtil.ZHI[this.zhiIndex + 1];
    }

    public String getGanZhi() {
        return this.getGan() + this.getZhi();
    }

    public double getFirstJulianDay() {
        return this.firstJulianDay;
    }

    public String getPositionXi() {
        return LunarUtil.POSITION_XI[this.getGanIndex() + 1];
    }

    public String getPositionXiDesc() {
        return LunarUtil.POSITION_DESC.get(this.getPositionXi());
    }

    public String getPositionYangGui() {
        return LunarUtil.POSITION_YANG_GUI[this.getGanIndex() + 1];
    }

    public String getPositionYangGuiDesc() {
        return LunarUtil.POSITION_DESC.get(this.getPositionYangGui());
    }

    public String getPositionYinGui() {
        return LunarUtil.POSITION_YIN_GUI[this.getGanIndex() + 1];
    }

    public String getPositionYinGuiDesc() {
        return LunarUtil.POSITION_DESC.get(this.getPositionYinGui());
    }

    public String getPositionFu(int sect) {
        return (1 == sect ? LunarUtil.POSITION_FU : LunarUtil.POSITION_FU_2)[this.getGanIndex() + 1];
    }

    public String getPositionFuDesc(int sect) {
        return LunarUtil.POSITION_DESC.get(this.getPositionFu(sect));
    }

    public String getPositionCai() {
        return LunarUtil.POSITION_CAI[this.getGanIndex() + 1];
    }

    public String getPositionCaiDesc() {
        return LunarUtil.POSITION_DESC.get(this.getPositionCai());
    }

    public String getPositionTaiSui() {
        int m = Math.abs(this.month) % 4;
        return switch (m) {
            case 0 -> "\u5dfd";
            case 1 -> "\u826e";
            case 3 -> "\u5764";
            default -> LunarUtil.POSITION_GAN[Solar.fromJulianDay(this.getFirstJulianDay()).getLunar().getMonthGanIndex()];
        };
    }

    public String getPositionTaiSuiDesc() {
        return LunarUtil.POSITION_DESC.get(this.getPositionTaiSui());
    }

    public NineStar getNineStar() {
        int index = LunarYear.fromYear(this.year).getZhiIndex() % 3;
        int m = Math.abs(this.month);
        int monthZhiIndex = (13 + m) % 12;
        int n = 27 - index * 3;
        if (monthZhiIndex < 2) {
            n -= 3;
        }
        int offset = (n - monthZhiIndex) % 9;
        return NineStar.fromIndex(offset);
    }

    public String toString() {
        return this.year + "\u5e74" + (this.isLeap() ? "\u95f0" : "") + LunarUtil.MONTH[Math.abs(this.month)] + "\u6708(" + this.dayCount + "\u5929)";
    }

    public LunarMonth next(int n) {
        int ny;
        if (0 == n) {
            return LunarMonth.fromYm(this.year, this.month);
        }
        if (n > 0) {
            int ny2;
            int rest = n;
            int iy = ny2 = this.year;
            int im = this.month;
            int index = 0;
            List<LunarMonth> months = LunarYear.fromYear(ny2).getMonths();
            while (true) {
                int more;
                int size = months.size();
                for (int i = 0; i < size; ++i) {
                    LunarMonth m = months.get(i);
                    if (m.getYear() != iy || m.getMonth() != im) continue;
                    index = i;
                    break;
                }
                if (rest < (more = size - index - 1)) break;
                rest -= more;
                LunarMonth lastMonth = months.get(size - 1);
                iy = lastMonth.getYear();
                im = lastMonth.getMonth();
                months = LunarYear.fromYear(++ny2).getMonths();
            }
            return months.get(index + rest);
        }
        int rest = -n;
        int iy = ny = this.year;
        int im = this.month;
        int index = 0;
        List<LunarMonth> months = LunarYear.fromYear(ny).getMonths();
        while (true) {
            int size = months.size();
            for (int i = 0; i < size; ++i) {
                LunarMonth m = months.get(i);
                if (m.getYear() != iy || m.getMonth() != im) continue;
                index = i;
                break;
            }
            if (rest <= index) break;
            rest -= index;
            LunarMonth firstMonth = months.get(0);
            iy = firstMonth.getYear();
            im = firstMonth.getMonth();
            months = LunarYear.fromYear(--ny).getMonths();
        }
        return months.get(index - rest);
    }
}

