/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.api.lunar;

import java.util.List;
import java.util.Map;
import org.confluence.mod.api.lunar.Lunar;
import org.confluence.mod.api.lunar.NineStar;
import org.confluence.mod.api.lunar.Solar;
import org.confluence.mod.api.lunar.util.LunarUtil;

public class LunarTime {
    private final int ganIndex;
    private final int zhiIndex;
    private final Lunar lunar;

    public LunarTime(int lunarYear, int lunarMonth, int lunarDay, int hour, int minute, int second) {
        this.lunar = Lunar.fromYmdHms(lunarYear, lunarMonth, lunarDay, hour, minute, second);
        this.zhiIndex = LunarUtil.getTimeZhiIndex(String.format("%02d:%02d", hour, minute));
        this.ganIndex = (this.lunar.getDayGanIndexExact() % 5 * 2 + this.zhiIndex) % 10;
    }

    public static LunarTime fromYmdHms(int lunarYear, int lunarMonth, int lunarDay, int hour, int minute, int second) {
        return new LunarTime(lunarYear, lunarMonth, lunarDay, hour, minute, second);
    }

    public int getGanIndex() {
        return this.ganIndex;
    }

    public int getZhiIndex() {
        return this.zhiIndex;
    }

    public String getShengXiao() {
        return LunarUtil.SHENGXIAO[this.zhiIndex + 1];
    }

    public String getZhi() {
        return LunarUtil.ZHI[this.zhiIndex + 1];
    }

    public String getGan() {
        return LunarUtil.GAN[this.ganIndex + 1];
    }

    public String getGanZhi() {
        return this.getGan() + this.getZhi();
    }

    public String getPositionXi() {
        return LunarUtil.POSITION_XI[this.ganIndex + 1];
    }

    public String getPositionXiDesc() {
        return LunarUtil.POSITION_DESC.get(this.getPositionXi());
    }

    public String getPositionYangGui() {
        return LunarUtil.POSITION_YANG_GUI[this.ganIndex + 1];
    }

    public String getPositionYangGuiDesc() {
        return LunarUtil.POSITION_DESC.get(this.getPositionYangGui());
    }

    public String getPositionYinGui() {
        return LunarUtil.POSITION_YIN_GUI[this.ganIndex + 1];
    }

    public String getPositionYinGuiDesc() {
        return LunarUtil.POSITION_DESC.get(this.getPositionYinGui());
    }

    public String getPositionFu() {
        return this.getPositionFu(2);
    }

    public String getPositionFu(int sect) {
        return (1 == sect ? LunarUtil.POSITION_FU : LunarUtil.POSITION_FU_2)[this.ganIndex + 1];
    }

    public String getPositionFuDesc() {
        return this.getPositionFuDesc(2);
    }

    public String getPositionFuDesc(int sect) {
        return LunarUtil.POSITION_DESC.get(this.getPositionFu(sect));
    }

    public String getPositionCai() {
        return LunarUtil.POSITION_CAI[this.ganIndex + 1];
    }

    public String getPositionCaiDesc() {
        return LunarUtil.POSITION_DESC.get(this.getPositionCai());
    }

    public String getNaYin() {
        return LunarUtil.NAYIN.get(this.getGanZhi());
    }

    public String getTianShen() {
        return LunarUtil.TIAN_SHEN[(this.zhiIndex + LunarUtil.ZHI_TIAN_SHEN_OFFSET.get(this.lunar.getDayZhiExact())) % 12 + 1];
    }

    public String getTianShenType() {
        return LunarUtil.TIAN_SHEN_TYPE.get(this.getTianShen());
    }

    public String getTianShenLuck() {
        return LunarUtil.TIAN_SHEN_TYPE_LUCK.get(this.getTianShenType());
    }

    public String getChong() {
        return LunarUtil.CHONG[this.zhiIndex];
    }

    public String getSha() {
        return LunarUtil.SHA.get(this.getZhi());
    }

    public String getChongShengXiao() {
        String chong = this.getChong();
        int j = LunarUtil.ZHI.length;
        for (int i = 0; i < j; ++i) {
            if (!LunarUtil.ZHI[i].equals(chong)) continue;
            return LunarUtil.SHENGXIAO[i];
        }
        return "";
    }

    public String getChongDesc() {
        return "(" + this.getChongGan() + this.getChong() + ")" + this.getChongShengXiao();
    }

    public String getChongGan() {
        return LunarUtil.CHONG_GAN[this.ganIndex];
    }

    public String getChongGanTie() {
        return LunarUtil.CHONG_GAN_TIE[this.ganIndex];
    }

    public List<String> getYi() {
        return LunarUtil.getTimeYi(this.lunar.getDayInGanZhiExact(), this.getGanZhi());
    }

    public List<String> getJi() {
        return LunarUtil.getTimeJi(this.lunar.getDayInGanZhiExact(), this.getGanZhi());
    }

    public NineStar getNineStar() {
        int index;
        Map<String, Solar> jieQi;
        String solarYmd = this.lunar.getSolar().toYmd();
        boolean asc = solarYmd.compareTo((jieQi = this.lunar.getJieQiTable()).get("\u51ac\u81f3").toYmd()) >= 0 && solarYmd.compareTo(jieQi.get("\u590f\u81f3").toYmd()) < 0;
        int start = asc ? 7 : 3;
        String dayZhi = this.lunar.getDayZhi();
        if ("\u5b50\u5348\u536f\u9149".contains(dayZhi)) {
            start = asc ? 1 : 9;
        } else if ("\u8fb0\u620c\u4e11\u672a".contains(dayZhi)) {
            start = asc ? 4 : 6;
        }
        int n = index = asc ? start + this.zhiIndex - 1 : start - this.zhiIndex - 1;
        if (index > 8) {
            index -= 9;
        }
        if (index < 0) {
            index += 9;
        }
        return new NineStar(index);
    }

    public String getXun() {
        return LunarUtil.getXun(this.getGanZhi());
    }

    public String getXunKong() {
        return LunarUtil.getXunKong(this.getGanZhi());
    }

    public String getMinHm() {
        int hour = this.lunar.getHour();
        if (hour < 1) {
            return "00:00";
        }
        if (hour > 22) {
            return "23:00";
        }
        return String.format("%02d:00", hour % 2 == 0 ? hour - 1 : hour);
    }

    public String getMaxHm() {
        int hour = this.lunar.getHour();
        if (hour < 1) {
            return "00:59";
        }
        if (hour > 22) {
            return "23:59";
        }
        return String.format("%02d:59", hour % 2 == 0 ? hour : hour + 1);
    }

    public String toString() {
        return this.getGanZhi();
    }
}

