/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.api.lunar.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.confluence.mod.api.lunar.Solar;

public class SolarUtil {
    public static final String[] WEEK = new String[]{"\u65e5", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d"};
    public static final int[] DAYS_OF_MONTH = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    public static final String[] XINGZUO = new String[]{"\u767d\u7f8a", "\u91d1\u725b", "\u53cc\u5b50", "\u5de8\u87f9", "\u72ee\u5b50", "\u5904\u5973", "\u5929\u79e4", "\u5929\u874e", "\u5c04\u624b", "\u6469\u7faf", "\u6c34\u74f6", "\u53cc\u9c7c"};
    public static final Map<String, String> FESTIVAL = new HashMap<String, String>(){
        private static final long serialVersionUID = -1L;
        {
            this.put("1-1", "\u5143\u65e6\u8282");
            this.put("2-14", "\u60c5\u4eba\u8282");
            this.put("3-8", "\u5987\u5973\u8282");
            this.put("3-12", "\u690d\u6811\u8282");
            this.put("3-15", "\u6d88\u8d39\u8005\u6743\u76ca\u65e5");
            this.put("4-1", "\u611a\u4eba\u8282");
            this.put("5-1", "\u52b3\u52a8\u8282");
            this.put("5-4", "\u9752\u5e74\u8282");
            this.put("6-1", "\u513f\u7ae5\u8282");
            this.put("7-1", "\u5efa\u515a\u8282");
            this.put("8-1", "\u5efa\u519b\u8282");
            this.put("9-10", "\u6559\u5e08\u8282");
            this.put("10-1", "\u56fd\u5e86\u8282");
            this.put("10-31", "\u4e07\u5723\u8282\u524d\u591c");
            this.put("11-1", "\u4e07\u5723\u8282");
            this.put("12-24", "\u5e73\u5b89\u591c");
            this.put("12-25", "\u5723\u8bde\u8282");
        }
    };
    public static final Map<String, String> WEEK_FESTIVAL = new HashMap<String, String>(){
        private static final long serialVersionUID = -1L;
        {
            this.put("3-0-1", "\u5168\u56fd\u4e2d\u5c0f\u5b66\u751f\u5b89\u5168\u6559\u80b2\u65e5");
            this.put("5-2-0", "\u6bcd\u4eb2\u8282");
            this.put("6-3-0", "\u7236\u4eb2\u8282");
            this.put("11-4-4", "\u611f\u6069\u8282");
        }
    };
    public static final Map<String, List<String>> OTHER_FESTIVAL = new HashMap<String, List<String>>(){
        private static final long serialVersionUID = -1L;
        {
            this.put("1-8", Collections.nCopies(1, "\u5468\u6069\u6765\u901d\u4e16\u7eaa\u5ff5\u65e5"));
            this.put("1-10", Collections.nCopies(1, "\u4e2d\u56fd\u4eba\u6c11\u8b66\u5bdf\u8282"));
            this.put("1-14", Collections.nCopies(1, "\u65e5\u8bb0\u60c5\u4eba\u8282"));
            this.put("1-21", Collections.nCopies(1, "\u5217\u5b81\u901d\u4e16\u7eaa\u5ff5\u65e5"));
            this.put("1-26", Collections.nCopies(1, "\u56fd\u9645\u6d77\u5173\u65e5"));
            this.put("1-27", Collections.nCopies(1, "\u56fd\u9645\u5927\u5c60\u6740\u7eaa\u5ff5\u65e5"));
            this.put("2-2", Collections.nCopies(1, "\u4e16\u754c\u6e7f\u5730\u65e5"));
            this.put("2-4", Collections.nCopies(1, "\u4e16\u754c\u6297\u764c\u65e5"));
            this.put("2-7", Collections.nCopies(1, "\u4eac\u6c49\u94c1\u8def\u7f62\u5de5\u7eaa\u5ff5\u65e5"));
            this.put("2-10", Collections.nCopies(1, "\u56fd\u9645\u6c14\u8c61\u8282"));
            this.put("2-19", Collections.nCopies(1, "\u9093\u5c0f\u5e73\u901d\u4e16\u7eaa\u5ff5\u65e5"));
            this.put("2-20", Collections.nCopies(1, "\u4e16\u754c\u793e\u4f1a\u516c\u6b63\u65e5"));
            this.put("2-21", Collections.nCopies(1, "\u56fd\u9645\u6bcd\u8bed\u65e5"));
            this.put("2-24", Collections.nCopies(1, "\u7b2c\u4e09\u4e16\u754c\u9752\u5e74\u65e5"));
            this.put("3-1", Collections.nCopies(1, "\u56fd\u9645\u6d77\u8c79\u65e5"));
            this.put("3-3", Arrays.asList("\u4e16\u754c\u91ce\u751f\u52a8\u690d\u7269\u65e5", "\u5168\u56fd\u7231\u8033\u65e5"));
            this.put("3-5", Arrays.asList("\u5468\u6069\u6765\u8bde\u8fb0\u7eaa\u5ff5\u65e5", "\u4e2d\u56fd\u9752\u5e74\u5fd7\u613f\u8005\u670d\u52a1\u65e5"));
            this.put("3-6", Collections.nCopies(1, "\u4e16\u754c\u9752\u5149\u773c\u65e5"));
            this.put("3-7", Collections.nCopies(1, "\u5973\u751f\u8282"));
            this.put("3-12", Collections.nCopies(1, "\u5b59\u4e2d\u5c71\u901d\u4e16\u7eaa\u5ff5\u65e5"));
            this.put("3-14", Arrays.asList("\u9a6c\u514b\u601d\u901d\u4e16\u7eaa\u5ff5\u65e5", "\u767d\u8272\u60c5\u4eba\u8282"));
            this.put("3-17", Collections.nCopies(1, "\u56fd\u9645\u822a\u6d77\u65e5"));
            this.put("3-18", Arrays.asList("\u5168\u56fd\u79d1\u6280\u4eba\u624d\u6d3b\u52a8\u65e5", "\u5168\u56fd\u7231\u809d\u65e5"));
            this.put("3-20", Collections.nCopies(1, "\u56fd\u9645\u5e78\u798f\u65e5"));
            this.put("3-21", Arrays.asList("\u4e16\u754c\u68ee\u6797\u65e5", "\u4e16\u754c\u7761\u7720\u65e5", "\u56fd\u9645\u6d88\u9664\u79cd\u65cf\u6b67\u89c6\u65e5"));
            this.put("3-22", Collections.nCopies(1, "\u4e16\u754c\u6c34\u65e5"));
            this.put("3-23", Collections.nCopies(1, "\u4e16\u754c\u6c14\u8c61\u65e5"));
            this.put("3-24", Collections.nCopies(1, "\u4e16\u754c\u9632\u6cbb\u7ed3\u6838\u75c5\u65e5"));
            this.put("3-29", Collections.nCopies(1, "\u4e2d\u56fd\u9ec4\u82b1\u5c97\u4e03\u5341\u4e8c\u70c8\u58eb\u6b89\u96be\u7eaa\u5ff5\u65e5"));
            this.put("4-2", Arrays.asList("\u56fd\u9645\u513f\u7ae5\u56fe\u4e66\u65e5", "\u4e16\u754c\u81ea\u95ed\u75c7\u65e5"));
            this.put("4-4", Collections.nCopies(1, "\u56fd\u9645\u5730\u96f7\u884c\u52a8\u65e5"));
            this.put("4-7", Collections.nCopies(1, "\u4e16\u754c\u536b\u751f\u65e5"));
            this.put("4-8", Collections.nCopies(1, "\u56fd\u9645\u73cd\u7a00\u52a8\u7269\u4fdd\u62a4\u65e5"));
            this.put("4-12", Collections.nCopies(1, "\u4e16\u754c\u822a\u5929\u65e5"));
            this.put("4-14", Collections.nCopies(1, "\u9ed1\u8272\u60c5\u4eba\u8282"));
            this.put("4-15", Collections.nCopies(1, "\u5168\u6c11\u56fd\u5bb6\u5b89\u5168\u6559\u80b2\u65e5"));
            this.put("4-22", Arrays.asList("\u4e16\u754c\u5730\u7403\u65e5", "\u5217\u5b81\u8bde\u8fb0\u7eaa\u5ff5\u65e5"));
            this.put("4-23", Collections.nCopies(1, "\u4e16\u754c\u8bfb\u4e66\u65e5"));
            this.put("4-24", Collections.nCopies(1, "\u4e2d\u56fd\u822a\u5929\u65e5"));
            this.put("4-25", Collections.nCopies(1, "\u513f\u7ae5\u9884\u9632\u63a5\u79cd\u5ba3\u4f20\u65e5"));
            this.put("4-26", Arrays.asList("\u4e16\u754c\u77e5\u8bc6\u4ea7\u6743\u65e5", "\u5168\u56fd\u759f\u75be\u65e5"));
            this.put("4-28", Collections.nCopies(1, "\u4e16\u754c\u5b89\u5168\u751f\u4ea7\u4e0e\u5065\u5eb7\u65e5"));
            this.put("4-30", Collections.nCopies(1, "\u5168\u56fd\u4ea4\u901a\u5b89\u5168\u53cd\u601d\u65e5"));
            this.put("5-2", Collections.nCopies(1, "\u4e16\u754c\u91d1\u67aa\u9c7c\u65e5"));
            this.put("5-3", Collections.nCopies(1, "\u4e16\u754c\u65b0\u95fb\u81ea\u7531\u65e5"));
            this.put("5-5", Collections.nCopies(1, "\u9a6c\u514b\u601d\u8bde\u8fb0\u7eaa\u5ff5\u65e5"));
            this.put("5-8", Collections.nCopies(1, "\u4e16\u754c\u7ea2\u5341\u5b57\u65e5"));
            this.put("5-11", Collections.nCopies(1, "\u4e16\u754c\u80a5\u80d6\u65e5"));
            this.put("5-12", Arrays.asList("\u5168\u56fd\u9632\u707e\u51cf\u707e\u65e5", "\u62a4\u58eb\u8282"));
            this.put("5-14", Collections.nCopies(1, "\u73ab\u7470\u60c5\u4eba\u8282"));
            this.put("5-15", Collections.nCopies(1, "\u56fd\u9645\u5bb6\u5ead\u65e5"));
            this.put("5-19", Collections.nCopies(1, "\u4e2d\u56fd\u65c5\u6e38\u65e5"));
            this.put("5-20", Collections.nCopies(1, "\u7f51\u7edc\u60c5\u4eba\u8282"));
            this.put("5-22", Collections.nCopies(1, "\u56fd\u9645\u751f\u7269\u591a\u6837\u6027\u65e5"));
            this.put("5-25", Collections.nCopies(1, "525\u5fc3\u7406\u5065\u5eb7\u8282"));
            this.put("5-27", Collections.nCopies(1, "\u4e0a\u6d77\u89e3\u653e\u65e5"));
            this.put("5-29", Collections.nCopies(1, "\u56fd\u9645\u7ef4\u548c\u4eba\u5458\u65e5"));
            this.put("5-30", Collections.nCopies(1, "\u4e2d\u56fd\u4e94\u5345\u8fd0\u52a8\u7eaa\u5ff5\u65e5"));
            this.put("5-31", Collections.nCopies(1, "\u4e16\u754c\u65e0\u70df\u65e5"));
            this.put("6-3", Collections.nCopies(1, "\u4e16\u754c\u81ea\u884c\u8f66\u65e5"));
            this.put("6-5", Collections.nCopies(1, "\u4e16\u754c\u73af\u5883\u65e5"));
            this.put("6-6", Collections.nCopies(1, "\u5168\u56fd\u7231\u773c\u65e5"));
            this.put("6-8", Collections.nCopies(1, "\u4e16\u754c\u6d77\u6d0b\u65e5"));
            this.put("6-11", Collections.nCopies(1, "\u4e2d\u56fd\u4eba\u53e3\u65e5"));
            this.put("6-14", Arrays.asList("\u4e16\u754c\u732e\u8840\u65e5", "\u4eb2\u4eb2\u60c5\u4eba\u8282"));
            this.put("6-17", Collections.nCopies(1, "\u4e16\u754c\u9632\u6cbb\u8352\u6f20\u5316\u4e0e\u5e72\u65f1\u65e5"));
            this.put("6-20", Collections.nCopies(1, "\u4e16\u754c\u96be\u6c11\u65e5"));
            this.put("6-21", Collections.nCopies(1, "\u56fd\u9645\u745c\u4f3d\u65e5"));
            this.put("6-25", Collections.nCopies(1, "\u5168\u56fd\u571f\u5730\u65e5"));
            this.put("6-26", Arrays.asList("\u56fd\u9645\u7981\u6bd2\u65e5", "\u8054\u5408\u56fd\u5baa\u7ae0\u65e5"));
            this.put("7-1", Collections.nCopies(1, "\u9999\u6e2f\u56de\u5f52\u7eaa\u5ff5\u65e5"));
            this.put("7-6", Arrays.asList("\u56fd\u9645\u63a5\u543b\u65e5", "\u6731\u5fb7\u901d\u4e16\u7eaa\u5ff5\u65e5"));
            this.put("7-7", Collections.nCopies(1, "\u4e03\u4e03\u4e8b\u53d8\u7eaa\u5ff5\u65e5"));
            this.put("7-11", Arrays.asList("\u4e16\u754c\u4eba\u53e3\u65e5", "\u4e2d\u56fd\u822a\u6d77\u65e5"));
            this.put("7-14", Collections.nCopies(1, "\u94f6\u8272\u60c5\u4eba\u8282"));
            this.put("7-18", Collections.nCopies(1, "\u66fc\u5fb7\u62c9\u56fd\u9645\u65e5"));
            this.put("7-30", Collections.nCopies(1, "\u56fd\u9645\u53cb\u8c0a\u65e5"));
            this.put("8-3", Collections.nCopies(1, "\u7537\u4eba\u8282"));
            this.put("8-5", Collections.nCopies(1, "\u6069\u683c\u65af\u901d\u4e16\u7eaa\u5ff5\u65e5"));
            this.put("8-6", Collections.nCopies(1, "\u56fd\u9645\u7535\u5f71\u8282"));
            this.put("8-8", Collections.nCopies(1, "\u5168\u6c11\u5065\u8eab\u65e5"));
            this.put("8-9", Collections.nCopies(1, "\u56fd\u9645\u571f\u8457\u4eba\u65e5"));
            this.put("8-12", Collections.nCopies(1, "\u56fd\u9645\u9752\u5e74\u8282"));
            this.put("8-14", Collections.nCopies(1, "\u7eff\u8272\u60c5\u4eba\u8282"));
            this.put("8-19", Arrays.asList("\u4e16\u754c\u4eba\u9053\u4e3b\u4e49\u65e5", "\u4e2d\u56fd\u533b\u5e08\u8282"));
            this.put("8-22", Collections.nCopies(1, "\u9093\u5c0f\u5e73\u8bde\u8fb0\u7eaa\u5ff5\u65e5"));
            this.put("8-29", Collections.nCopies(1, "\u5168\u56fd\u6d4b\u7ed8\u6cd5\u5ba3\u4f20\u65e5"));
            this.put("9-3", Collections.nCopies(1, "\u4e2d\u56fd\u6297\u65e5\u6218\u4e89\u80dc\u5229\u7eaa\u5ff5\u65e5"));
            this.put("9-5", Collections.nCopies(1, "\u4e2d\u534e\u6148\u5584\u65e5"));
            this.put("9-8", Collections.nCopies(1, "\u4e16\u754c\u626b\u76f2\u65e5"));
            this.put("9-9", Arrays.asList("\u6bdb\u6cfd\u4e1c\u901d\u4e16\u7eaa\u5ff5\u65e5", "\u5168\u56fd\u62d2\u7edd\u9152\u9a7e\u65e5"));
            this.put("9-14", Arrays.asList("\u4e16\u754c\u6e05\u6d01\u5730\u7403\u65e5", "\u76f8\u7247\u60c5\u4eba\u8282"));
            this.put("9-15", Collections.nCopies(1, "\u56fd\u9645\u6c11\u4e3b\u65e5"));
            this.put("9-16", Collections.nCopies(1, "\u56fd\u9645\u81ed\u6c27\u5c42\u4fdd\u62a4\u65e5"));
            this.put("9-17", Collections.nCopies(1, "\u4e16\u754c\u9a91\u884c\u65e5"));
            this.put("9-18", Collections.nCopies(1, "\u4e5d\u4e00\u516b\u4e8b\u53d8\u7eaa\u5ff5\u65e5"));
            this.put("9-20", Collections.nCopies(1, "\u5168\u56fd\u7231\u7259\u65e5"));
            this.put("9-21", Collections.nCopies(1, "\u56fd\u9645\u548c\u5e73\u65e5"));
            this.put("9-27", Collections.nCopies(1, "\u4e16\u754c\u65c5\u6e38\u65e5"));
            this.put("9-30", Collections.nCopies(1, "\u4e2d\u56fd\u70c8\u58eb\u7eaa\u5ff5\u65e5"));
            this.put("10-1", Collections.nCopies(1, "\u56fd\u9645\u8001\u5e74\u4eba\u65e5"));
            this.put("10-2", Collections.nCopies(1, "\u56fd\u9645\u975e\u66b4\u529b\u65e5"));
            this.put("10-4", Collections.nCopies(1, "\u4e16\u754c\u52a8\u7269\u65e5"));
            this.put("10-11", Collections.nCopies(1, "\u56fd\u9645\u5973\u7ae5\u65e5"));
            this.put("10-10", Collections.nCopies(1, "\u8f9b\u4ea5\u9769\u547d\u7eaa\u5ff5\u65e5"));
            this.put("10-13", Arrays.asList("\u56fd\u9645\u51cf\u8f7b\u81ea\u7136\u707e\u5bb3\u65e5", "\u4e2d\u56fd\u5c11\u5e74\u5148\u950b\u961f\u8bde\u8fb0\u65e5"));
            this.put("10-14", Collections.nCopies(1, "\u8461\u8404\u9152\u60c5\u4eba\u8282"));
            this.put("10-16", Collections.nCopies(1, "\u4e16\u754c\u7cae\u98df\u65e5"));
            this.put("10-17", Collections.nCopies(1, "\u5168\u56fd\u6276\u8d2b\u65e5"));
            this.put("10-20", Collections.nCopies(1, "\u4e16\u754c\u7edf\u8ba1\u65e5"));
            this.put("10-24", Arrays.asList("\u4e16\u754c\u53d1\u5c55\u4fe1\u606f\u65e5", "\u7a0b\u5e8f\u5458\u8282"));
            this.put("10-25", Collections.nCopies(1, "\u6297\u7f8e\u63f4\u671d\u7eaa\u5ff5\u65e5"));
            this.put("11-5", Collections.nCopies(1, "\u4e16\u754c\u6d77\u5578\u65e5"));
            this.put("11-8", Collections.nCopies(1, "\u8bb0\u8005\u8282"));
            this.put("11-9", Collections.nCopies(1, "\u5168\u56fd\u6d88\u9632\u65e5"));
            this.put("11-11", Collections.nCopies(1, "\u5149\u68cd\u8282"));
            this.put("11-12", Collections.nCopies(1, "\u5b59\u4e2d\u5c71\u8bde\u8fb0\u7eaa\u5ff5\u65e5"));
            this.put("11-14", Collections.nCopies(1, "\u7535\u5f71\u60c5\u4eba\u8282"));
            this.put("11-16", Collections.nCopies(1, "\u56fd\u9645\u5bbd\u5bb9\u65e5"));
            this.put("11-17", Collections.nCopies(1, "\u56fd\u9645\u5927\u5b66\u751f\u8282"));
            this.put("11-19", Collections.nCopies(1, "\u4e16\u754c\u5395\u6240\u65e5"));
            this.put("11-28", Collections.nCopies(1, "\u6069\u683c\u65af\u8bde\u8fb0\u7eaa\u5ff5\u65e5"));
            this.put("11-29", Collections.nCopies(1, "\u56fd\u9645\u58f0\u63f4\u5df4\u52d2\u65af\u5766\u4eba\u6c11\u65e5"));
            this.put("12-1", Collections.nCopies(1, "\u4e16\u754c\u827e\u6ecb\u75c5\u65e5"));
            this.put("12-2", Collections.nCopies(1, "\u5168\u56fd\u4ea4\u901a\u5b89\u5168\u65e5"));
            this.put("12-3", Collections.nCopies(1, "\u4e16\u754c\u6b8b\u75be\u4eba\u65e5"));
            this.put("12-4", Collections.nCopies(1, "\u5168\u56fd\u6cd5\u5236\u5ba3\u4f20\u65e5"));
            this.put("12-5", Arrays.asList("\u4e16\u754c\u5f31\u80fd\u4eba\u58eb\u65e5", "\u56fd\u9645\u5fd7\u613f\u4eba\u5458\u65e5"));
            this.put("12-7", Collections.nCopies(1, "\u56fd\u9645\u6c11\u822a\u65e5"));
            this.put("12-9", Arrays.asList("\u4e16\u754c\u8db3\u7403\u65e5", "\u56fd\u9645\u53cd\u8150\u8d25\u65e5"));
            this.put("12-10", Collections.nCopies(1, "\u4e16\u754c\u4eba\u6743\u65e5"));
            this.put("12-11", Collections.nCopies(1, "\u56fd\u9645\u5c71\u5cb3\u65e5"));
            this.put("12-12", Collections.nCopies(1, "\u897f\u5b89\u4e8b\u53d8\u7eaa\u5ff5\u65e5"));
            this.put("12-13", Collections.nCopies(1, "\u56fd\u5bb6\u516c\u796d\u65e5"));
            this.put("12-14", Collections.nCopies(1, "\u62e5\u62b1\u60c5\u4eba\u8282"));
            this.put("12-18", Collections.nCopies(1, "\u56fd\u9645\u79fb\u5f99\u8005\u65e5"));
            this.put("12-26", Collections.nCopies(1, "\u6bdb\u6cfd\u4e1c\u8bde\u8fb0\u7eaa\u5ff5\u65e5"));
        }
    };

    protected SolarUtil() {
    }

    public static boolean isLeapYear(int year) {
        if (year < 1600) {
            return year % 4 == 0;
        }
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    public static int getDaysOfYear(int year) {
        if (1582 == year) {
            return 355;
        }
        return SolarUtil.isLeapYear(year) ? 366 : 365;
    }

    public static int getDaysOfMonth(int year, int month) {
        if (1582 == year && 10 == month) {
            return 21;
        }
        int m = month - 1;
        int d = DAYS_OF_MONTH[m];
        if (m == 1 && SolarUtil.isLeapYear(year)) {
            ++d;
        }
        return d;
    }

    public static int getDaysInYear(int year, int month, int day) {
        int days = 0;
        for (int i = 1; i < month; ++i) {
            days += SolarUtil.getDaysOfMonth(year, i);
        }
        int d = day;
        if (1582 == year && 10 == month) {
            if (day >= 15) {
                d -= 10;
            } else if (day > 4) {
                throw new IllegalArgumentException(String.format("wrong solar year %d month %d day %d", year, month, day));
            }
        }
        return days += d;
    }

    public static int getWeeksOfMonth(int year, int month, int start) {
        return (int)Math.ceil((double)(SolarUtil.getDaysOfMonth(year, month) + Solar.fromYmd(year, month, 1).getWeek() - start) * 1.0 / (double)WEEK.length);
    }

    public static int getDaysBetween(int ay, int am, int ad, int by, int bm, int bd) {
        int n;
        if (ay == by) {
            n = SolarUtil.getDaysInYear(by, bm, bd) - SolarUtil.getDaysInYear(ay, am, ad);
        } else if (ay > by) {
            int days = SolarUtil.getDaysOfYear(by) - SolarUtil.getDaysInYear(by, bm, bd);
            for (int i = by + 1; i < ay; ++i) {
                days += SolarUtil.getDaysOfYear(i);
            }
            n = -(days += SolarUtil.getDaysInYear(ay, am, ad));
        } else {
            int days = SolarUtil.getDaysOfYear(ay) - SolarUtil.getDaysInYear(ay, am, ad);
            for (int i = ay + 1; i < by; ++i) {
                days += SolarUtil.getDaysOfYear(i);
            }
            n = days += SolarUtil.getDaysInYear(by, bm, bd);
        }
        return n;
    }
}

