/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.effect;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Axis;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;
import nowebsite.makertechno.the_trackers.api.component.ComponentBuilder;
import nowebsite.makertechno.the_trackers.api.component.StaticComponent;
import nowebsite.makertechno.the_trackers.core.track.TrackersMonitor;
import nowebsite.makertechno.the_trackers.core.track.WorldSingletonTracker;
import org.confluence.mod.client.ModKeyBindings;
import org.confluence.mod.common.block.common.BaseChestBlock;
import org.confluence.mod.common.block.functional.BehaviourPressurePlateBlock;
import org.confluence.mod.common.block.functional.DartTrapBlock;
import org.confluence.mod.common.block.functional.InstantExplosionBlock;
import org.confluence.mod.common.block.functional.MechanicalFragileBlock;
import org.confluence.mod.common.block.functional.SculkTrapBlock;
import org.confluence.mod.common.block.functional.SignalPressurePlateBlock;
import org.confluence.mod.common.block.functional.SpikeBlock;
import org.confluence.mod.common.block.functional.StepOnTrapBlock;
import org.confluence.mod.common.block.functional.SwitchBlock;
import org.confluence.mod.common.block.functional.boulder.AbstractBoulderBlock;
import org.confluence.mod.common.init.ModEffects;
import org.confluence.mod.common.init.block.ChestBlocks;
import org.confluence.mod.common.init.block.FunctionalBlocks;
import org.confluence.mod.common.init.block.NatureBlocks;
import org.confluence.mod.common.init.block.OreBlocks;
import org.confluence.mod.common.init.item.MaterialItems;
import org.confluence.terraentity.client.buffer.AbstractBufferManager;
import org.confluence.terraentity.client.util.ShaderUtil;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;

public class SpelunkerHelper
extends AbstractBufferManager {
    public int range = 30;
    public int textRange = 30;
    public float maxAlpha = 0.8f;
    public int textRenderType = 0;
    public int centerInternal = 50;
    private final Map<Block, Entry> targets = new HashMap<Block, Entry>();
    public Map<BlockPos, BlockPos> centerCache = new HashMap<BlockPos, BlockPos>();
    public Map<BlockPos, Block> centerCacheFrame = new HashMap<BlockPos, Block>();
    public Map<BlockPos, StaticComponentLifeController> cachedPointers = new HashMap<BlockPos, StaticComponentLifeController>();
    public Map<Block, ArrayList<BlockPos>> centers = new LinkedHashMap<Block, ArrayList<BlockPos>>();
    public Map<Block, List<BlockPos>> blockMap = new HashMap<Block, List<BlockPos>>();
    private static SpelunkerHelper blockGen;
    private static WorldSingletonTracker tracker;
    public static volatile boolean lock;
    public static final ComponentBuilder COMPONENT_BUILDER;
    public static final ResourceLocation EMPTY;
    int buildCount = 10;

    protected boolean shouldRefresh() {
        return System.currentTimeMillis() - this.lastRefreshTime > 100L;
    }

    public static SpelunkerHelper getSingleton() {
        if (blockGen == null) {
            blockGen = new SpelunkerHelper(100);
        }
        return blockGen;
    }

    public SpelunkerHelper(int refreshTime) {
        super(refreshTime);
        tracker = TrackersMonitor.getTracker();
        this.refreshBlocks();
        this.defaultBlocks();
    }

    public void defaultBlocks() {
        this.putTargetWithTexture(Blocks.ANCIENT_DEBRIS, 6234112, true, ShowType.SPELUNKER, Items.NETHERITE_SCRAP);
        this.putTargetWithTexture(Blocks.DIAMOND_ORE, 12451583, true, ShowType.SPELUNKER, Items.DIAMOND);
        this.putTargetWithTexture(Blocks.DEEPSLATE_DIAMOND_ORE, 12451583, true, ShowType.SPELUNKER, Items.DIAMOND);
        this.putTargetWithTexture((Block)OreBlocks.CORRUPTION_DIAMOND_ORE.get(), 12451583, true, ShowType.SPELUNKER, Items.DIAMOND);
        this.putTargetWithTexture((Block)OreBlocks.SANCTIFICATION_DIAMOND_ORE.get(), 12451583, true, ShowType.SPELUNKER, Items.DIAMOND);
        this.putTargetWithTexture((Block)OreBlocks.FLESHIFICATION_DIAMOND_ORE.get(), 12451583, true, ShowType.SPELUNKER, Items.DIAMOND);
        this.putMaterialTarget((Block)OreBlocks.RUBY_ORE.get(), 0xA80000, true, ShowType.SPELUNKER, MaterialItems.RUBY);
        this.putMaterialTarget((Block)OreBlocks.DEEPSLATE_RUBY_ORE.get(), 0xA80000, true, ShowType.SPELUNKER, MaterialItems.RUBY);
        this.putMaterialTarget((Block)OreBlocks.CORRUPTION_RUBY_ORE.get(), 0xA80000, true, ShowType.SPELUNKER, MaterialItems.RUBY);
        this.putMaterialTarget((Block)OreBlocks.SANCTIFICATION_RUBY_ORE.get(), 0xA80000, true, ShowType.SPELUNKER, MaterialItems.RUBY);
        this.putMaterialTarget((Block)OreBlocks.FLESHIFICATION_RUBY_ORE.get(), 0xA80000, true, ShowType.SPELUNKER, MaterialItems.RUBY);
        this.putMaterialTarget((Block)OreBlocks.AMBER_ORE.get(), 11033600, true, ShowType.SPELUNKER, MaterialItems.AMBER);
        this.putMaterialTarget((Block)OreBlocks.CORRUPTION_AMBER_ORE.get(), 11033600, true, ShowType.SPELUNKER, MaterialItems.AMBER);
        this.putMaterialTarget((Block)OreBlocks.SANCTIFICATION_AMBER_ORE.get(), 11033600, true, ShowType.SPELUNKER, MaterialItems.AMBER);
        this.putMaterialTarget((Block)OreBlocks.FLESHIFICATION_AMBER_ORE.get(), 11033600, true, ShowType.SPELUNKER, MaterialItems.AMBER);
        this.putMaterialTarget((Block)OreBlocks.TOPAZ_ORE.get(), 11043584, true, ShowType.SPELUNKER, MaterialItems.TOPAZ);
        this.putMaterialTarget((Block)OreBlocks.DEEPSLATE_TOPAZ_ORE.get(), 11043584, true, ShowType.SPELUNKER, MaterialItems.TOPAZ);
        this.putMaterialTarget((Block)OreBlocks.CORRUPTION_TOPAZ_ORE.get(), 11043584, true, ShowType.SPELUNKER, MaterialItems.TOPAZ);
        this.putMaterialTarget((Block)OreBlocks.SANCTIFICATION_TOPAZ_ORE.get(), 11043584, true, ShowType.SPELUNKER, MaterialItems.TOPAZ);
        this.putMaterialTarget((Block)OreBlocks.FLESHIFICATION_TOPAZ_ORE.get(), 11043584, true, ShowType.SPELUNKER, MaterialItems.TOPAZ);
        this.putMaterialTarget((Block)OreBlocks.JADE_ORE.get(), 43131, true, ShowType.SPELUNKER, MaterialItems.JADE);
        this.putMaterialTarget((Block)OreBlocks.DEEPSLATE_JADE_ORE.get(), 43131, true, ShowType.SPELUNKER, MaterialItems.JADE);
        this.putMaterialTarget((Block)OreBlocks.CORRUPTION_JADE_ORE.get(), 43131, true, ShowType.SPELUNKER, MaterialItems.JADE);
        this.putMaterialTarget((Block)OreBlocks.SANCTIFICATION_JADE_ORE.get(), 43131, true, ShowType.SPELUNKER, MaterialItems.JADE);
        this.putMaterialTarget((Block)OreBlocks.FLESHIFICATION_JADE_ORE.get(), 43131, true, ShowType.SPELUNKER, MaterialItems.JADE);
        this.putMaterialTarget((Block)OreBlocks.SAPPHIRE_ORE.get(), 21160, true, ShowType.SPELUNKER, MaterialItems.SAPPHIRE);
        this.putMaterialTarget((Block)OreBlocks.DEEPSLATE_SAPPHIRE_ORE.get(), 21160, true, ShowType.SPELUNKER, MaterialItems.SAPPHIRE);
        this.putMaterialTarget((Block)OreBlocks.CORRUPTION_SAPPHIRE_ORE.get(), 21160, true, ShowType.SPELUNKER, MaterialItems.SAPPHIRE);
        this.putMaterialTarget((Block)OreBlocks.SANCTIFICATION_SAPPHIRE_ORE.get(), 21160, true, ShowType.SPELUNKER, MaterialItems.SAPPHIRE);
        this.putMaterialTarget((Block)OreBlocks.FLESHIFICATION_SAPPHIRE_ORE.get(), 21160, true, ShowType.SPELUNKER, MaterialItems.SAPPHIRE);
        this.putMaterialTarget((Block)OreBlocks.AMETHYST_ORE.get(), 8192168, true, ShowType.SPELUNKER, MaterialItems.AMETHYST);
        this.putMaterialTarget((Block)OreBlocks.DEEPSLATE_AMETHYST_ORE.get(), 8192168, true, ShowType.SPELUNKER, MaterialItems.AMETHYST);
        this.putMaterialTarget((Block)OreBlocks.CORRUPTION_AMETHYST_ORE.get(), 8192168, true, ShowType.SPELUNKER, MaterialItems.AMETHYST);
        this.putMaterialTarget((Block)OreBlocks.SANCTIFICATION_AMETHYST_ORE.get(), 8192168, true, ShowType.SPELUNKER, MaterialItems.AMETHYST);
        this.putMaterialTarget((Block)OreBlocks.FLESHIFICATION_AMETHYST_ORE.get(), 8192168, true, ShowType.SPELUNKER, MaterialItems.AMETHYST);
        this.putTargetWithTexture(Blocks.EMERALD_ORE, 10747765, true, ShowType.SPELUNKER, Items.EMERALD);
        this.putTargetWithTexture(Blocks.DEEPSLATE_EMERALD_ORE, 10747765, true, ShowType.SPELUNKER, Items.EMERALD);
        this.putTargetWithTexture((Block)OreBlocks.CORRUPTION_EMERALD_ORE.get(), 10747765, true, ShowType.SPELUNKER, Items.EMERALD);
        this.putTargetWithTexture((Block)OreBlocks.SANCTIFICATION_EMERALD_ORE.get(), 10747765, true, ShowType.SPELUNKER, Items.EMERALD);
        this.putTargetWithTexture((Block)OreBlocks.FLESHIFICATION_EMERALD_ORE.get(), 10747765, true, ShowType.SPELUNKER, Items.EMERALD);
        this.putTargetWithTexture(Blocks.IRON_ORE, 12562063, true, ShowType.SPELUNKER, Items.RAW_IRON);
        this.putTargetWithTexture(Blocks.DEEPSLATE_IRON_ORE, 12562063, true, ShowType.SPELUNKER, Items.RAW_IRON);
        this.putTargetWithTexture((Block)OreBlocks.CORRUPTION_IRON_ORE.get(), 12562063, true, ShowType.SPELUNKER, Items.RAW_IRON);
        this.putTargetWithTexture((Block)OreBlocks.SANCTIFICATION_IRON_ORE.get(), 12562063, true, ShowType.SPELUNKER, Items.RAW_IRON);
        this.putTargetWithTexture((Block)OreBlocks.FLESHIFICATION_IRON_ORE.get(), 12562063, true, ShowType.SPELUNKER, Items.RAW_IRON);
        this.putTargetWithTexture(Blocks.GOLD_ORE, 13418016, true, ShowType.SPELUNKER, Items.RAW_GOLD);
        this.putTargetWithTexture(Blocks.DEEPSLATE_GOLD_ORE, 13418016, true, ShowType.SPELUNKER, Items.RAW_GOLD);
        this.putTargetWithTexture((Block)OreBlocks.CORRUPTION_GOLD_ORE.get(), 13418016, true, ShowType.SPELUNKER, Items.RAW_GOLD);
        this.putTargetWithTexture((Block)OreBlocks.SANCTIFICATION_GOLD_ORE.get(), 13418016, true, ShowType.SPELUNKER, Items.RAW_GOLD);
        this.putTargetWithTexture((Block)OreBlocks.FLESHIFICATION_GOLD_ORE.get(), 13418016, true, ShowType.SPELUNKER, Items.RAW_GOLD);
        this.putTargetWithTexture(Blocks.GILDED_BLACKSTONE, 13418016, true, ShowType.SPELUNKER, Items.RAW_GOLD);
        this.putTargetWithTexture(Blocks.NETHER_GOLD_ORE, 13418016, true, ShowType.SPELUNKER, Items.RAW_GOLD);
        this.putTargetWithTexture(Blocks.COAL_ORE, 0x555555, false, ShowType.SPELUNKER, Items.COAL);
        this.putTargetWithTexture(Blocks.DEEPSLATE_COAL_ORE, 0x555555, false, ShowType.SPELUNKER, Items.COAL);
        this.putTargetWithTexture((Block)OreBlocks.CORRUPTION_COAL_ORE.get(), 0x555555, true, ShowType.SPELUNKER, Items.COAL);
        this.putTargetWithTexture((Block)OreBlocks.SANCTIFICATION_COAL_ORE.get(), 0x555555, true, ShowType.SPELUNKER, Items.COAL);
        this.putTargetWithTexture((Block)OreBlocks.FLESHIFICATION_COAL_ORE.get(), 0x555555, true, ShowType.SPELUNKER, Items.COAL);
        this.putTargetWithTexture(Blocks.COPPER_ORE, 9916461, false, ShowType.SPELUNKER, Items.RAW_COPPER);
        this.putTargetWithTexture(Blocks.DEEPSLATE_COPPER_ORE, 9916461, false, ShowType.SPELUNKER, Items.RAW_COPPER);
        this.putTargetWithTexture((Block)OreBlocks.CORRUPTION_COPPER_ORE.get(), 9916461, true, ShowType.SPELUNKER, Items.RAW_COPPER);
        this.putTargetWithTexture((Block)OreBlocks.SANCTIFICATION_COPPER_ORE.get(), 9916461, true, ShowType.SPELUNKER, Items.RAW_COPPER);
        this.putTargetWithTexture((Block)OreBlocks.FLESHIFICATION_COPPER_ORE.get(), 9916461, true, ShowType.SPELUNKER, Items.RAW_COPPER);
        this.putMaterialTarget((Block)OreBlocks.TIN_ORE.get(), 9867886, false, ShowType.SPELUNKER, MaterialItems.RAW_TIN);
        this.putMaterialTarget((Block)OreBlocks.DEEPSLATE_TIN_ORE.get(), 9867886, false, ShowType.SPELUNKER, MaterialItems.RAW_TIN);
        this.putMaterialTarget((Block)OreBlocks.CORRUPTION_TIN_ORE.get(), 9867886, true, ShowType.SPELUNKER, MaterialItems.RAW_TIN);
        this.putMaterialTarget((Block)OreBlocks.SANCTIFICATION_TIN_ORE.get(), 9867886, true, ShowType.SPELUNKER, MaterialItems.RAW_TIN);
        this.putMaterialTarget((Block)OreBlocks.FLESHIFICATION_TIN_ORE.get(), 9867886, true, ShowType.SPELUNKER, MaterialItems.RAW_TIN);
        this.putMaterialTarget((Block)OreBlocks.LEAD_ORE.get(), 3164515, false, ShowType.SPELUNKER, MaterialItems.RAW_LEAD);
        this.putMaterialTarget((Block)OreBlocks.DEEPSLATE_LEAD_ORE.get(), 3164515, false, ShowType.SPELUNKER, MaterialItems.RAW_LEAD);
        this.putMaterialTarget((Block)OreBlocks.CORRUPTION_LEAD_ORE.get(), 3164515, true, ShowType.SPELUNKER, MaterialItems.RAW_LEAD);
        this.putMaterialTarget((Block)OreBlocks.SANCTIFICATION_LEAD_ORE.get(), 3164515, true, ShowType.SPELUNKER, MaterialItems.RAW_LEAD);
        this.putMaterialTarget((Block)OreBlocks.FLESHIFICATION_LEAD_ORE.get(), 3164515, true, ShowType.SPELUNKER, MaterialItems.RAW_LEAD);
        this.putMaterialTarget((Block)OreBlocks.SILVER_ORE.get(), 6976380, false, ShowType.SPELUNKER, MaterialItems.RAW_SILVER);
        this.putMaterialTarget((Block)OreBlocks.DEEPSLATE_SILVER_ORE.get(), 6976380, false, ShowType.SPELUNKER, MaterialItems.RAW_SILVER);
        this.putMaterialTarget((Block)OreBlocks.CORRUPTION_SILVER_ORE.get(), 6976380, true, ShowType.SPELUNKER, MaterialItems.RAW_SILVER);
        this.putMaterialTarget((Block)OreBlocks.SANCTIFICATION_SILVER_ORE.get(), 6976380, true, ShowType.SPELUNKER, MaterialItems.RAW_SILVER);
        this.putMaterialTarget((Block)OreBlocks.FLESHIFICATION_SILVER_ORE.get(), 6976380, true, ShowType.SPELUNKER, MaterialItems.RAW_SILVER);
        this.putMaterialTarget((Block)OreBlocks.TUNGSTEN_ORE.get(), 8830620, true, ShowType.SPELUNKER, MaterialItems.RAW_TUNGSTEN);
        this.putMaterialTarget((Block)OreBlocks.DEEPSLATE_TUNGSTEN_ORE.get(), 8830620, true, ShowType.SPELUNKER, MaterialItems.RAW_TUNGSTEN);
        this.putMaterialTarget((Block)OreBlocks.CORRUPTION_TUNGSTEN_ORE.get(), 8830620, true, ShowType.SPELUNKER, MaterialItems.RAW_TUNGSTEN);
        this.putMaterialTarget((Block)OreBlocks.SANCTIFICATION_TUNGSTEN_ORE.get(), 8830620, true, ShowType.SPELUNKER, MaterialItems.RAW_TUNGSTEN);
        this.putMaterialTarget((Block)OreBlocks.FLESHIFICATION_TUNGSTEN_ORE.get(), 8830620, true, ShowType.SPELUNKER, MaterialItems.RAW_TUNGSTEN);
        this.putMaterialTarget((Block)OreBlocks.PLATINUM_ORE.get(), 8501725, true, ShowType.SPELUNKER, MaterialItems.RAW_PLATINUM);
        this.putMaterialTarget((Block)OreBlocks.DEEPSLATE_PLATINUM_ORE.get(), 8501725, true, ShowType.SPELUNKER, MaterialItems.RAW_PLATINUM);
        this.putMaterialTarget((Block)OreBlocks.CORRUPTION_PLATINUM_ORE.get(), 8501725, true, ShowType.SPELUNKER, MaterialItems.RAW_PLATINUM);
        this.putMaterialTarget((Block)OreBlocks.SANCTIFICATION_PLATINUM_ORE.get(), 8501725, true, ShowType.SPELUNKER, MaterialItems.RAW_PLATINUM);
        this.putMaterialTarget((Block)OreBlocks.FLESHIFICATION_PLATINUM_ORE.get(), 8501725, true, ShowType.SPELUNKER, MaterialItems.RAW_PLATINUM);
        this.putWithSpecialIconTarget((Block)NatureBlocks.LIFE_CRYSTAL_BLOCK.get(), 15472446, true, ShowType.SPELUNKER, "life_crystal");
        for (DeferredBlock<BaseChestBlock> normalChest : ChestBlocks.NORMAL_CHESTS) {
            this.putTargetWithItemRender((Block)normalChest.get(), 15254292, true, ShowType.SPELUNKER, Items.CHEST);
        }
        this.putTargetWithItemRender(Blocks.CHEST, 15254292, true, ShowType.SPELUNKER, Items.CHEST);
        this.putTargetWithTexture(Blocks.LAPIS_ORE, 6847487, false, ShowType.SPELUNKER, Items.LAPIS_LAZULI);
        this.putTargetWithTexture(Blocks.DEEPSLATE_LAPIS_ORE, 6847487, false, ShowType.SPELUNKER, Items.LAPIS_LAZULI);
        this.putTargetWithTexture((Block)OreBlocks.CORRUPTION_LAPIS_ORE.get(), 6847487, true, ShowType.SPELUNKER, Items.LAPIS_LAZULI);
        this.putTargetWithTexture((Block)OreBlocks.SANCTIFICATION_LAPIS_ORE.get(), 6847487, true, ShowType.SPELUNKER, Items.LAPIS_LAZULI);
        this.putTargetWithTexture((Block)OreBlocks.FLESHIFICATION_LAPIS_ORE.get(), 6847487, true, ShowType.SPELUNKER, Items.LAPIS_LAZULI);
        this.putTargetWithTexture(Blocks.REDSTONE_ORE, 0x7D0000, false, ShowType.SPELUNKER, Items.REDSTONE);
        this.putTargetWithTexture(Blocks.DEEPSLATE_REDSTONE_ORE, 0x7D0000, false, ShowType.SPELUNKER, Items.REDSTONE);
        this.putTargetWithTexture((Block)OreBlocks.CORRUPTION_REDSTONE_ORE.get(), 0x7D0000, true, ShowType.SPELUNKER, Items.REDSTONE);
        this.putTargetWithTexture((Block)OreBlocks.SANCTIFICATION_REDSTONE_ORE.get(), 0x7D0000, true, ShowType.SPELUNKER, Items.REDSTONE);
        this.putTargetWithTexture((Block)OreBlocks.FLESHIFICATION_REDSTONE_ORE.get(), 0x7D0000, true, ShowType.SPELUNKER, Items.REDSTONE);
        this.putMaterialTarget((Block)OreBlocks.COLD_CRYSTAL_ORE.get(), 4044720, true, ShowType.SPELUNKER, MaterialItems.COLD_CRYSTAL);
        this.putMaterialTarget((Block)OreBlocks.GELSTONE_ORE.get(), 6469437, true, ShowType.SPELUNKER, MaterialItems.GELSTONE);
        this.putMaterialTarget((Block)OreBlocks.OPAL_ORE.get(), 4963583, true, ShowType.SPELUNKER, MaterialItems.OPAL);
        this.putMaterialTarget((Block)OreBlocks.HELLSTONE.get(), 15361294, true, ShowType.SPELUNKER, MaterialItems.RAW_HELLSTONE);
        this.putMaterialTarget((Block)OreBlocks.ASH_HELLSTONE.get(), 15361294, true, ShowType.SPELUNKER, MaterialItems.RAW_HELLSTONE);
        this.putTargetWithTexture(Blocks.NETHER_QUARTZ_ORE, 14863548, true, ShowType.SPELUNKER, Items.QUARTZ);
        this.putMaterialTarget((Block)OreBlocks.DEEPSLATE_COBALT_ORE.get(), 24809, true, ShowType.SPELUNKER, MaterialItems.RAW_COBALT);
        this.putMaterialTarget((Block)OreBlocks.DEEPSLATE_PALLADIUM_ORE.get(), 15299840, true, ShowType.SPELUNKER, MaterialItems.RAW_PALLADIUM);
        this.putMaterialTarget((Block)OreBlocks.DEEPSLATE_MYTHRIL_ORE.get(), 59822, true, ShowType.SPELUNKER, MaterialItems.RAW_MYTHRIL);
        this.putMaterialTarget((Block)OreBlocks.DEEPSLATE_ORICHALCUM_ORE.get(), 14876905, true, ShowType.SPELUNKER, MaterialItems.RAW_ORICHALCUM);
        this.putMaterialTarget((Block)OreBlocks.DEEPSLATE_ADAMANTITE_ORE.get(), 15269974, true, ShowType.SPELUNKER, MaterialItems.RAW_ADAMANTITE);
        this.putMaterialTarget((Block)OreBlocks.DEEPSLATE_TITANIUM_ORE.get(), 16112895, true, ShowType.SPELUNKER, MaterialItems.RAW_TITANIUM);
        this.putMaterialTarget((Block)OreBlocks.CHLOROPHYTE_ORE.get(), 42011, true, ShowType.SPELUNKER, MaterialItems.RAW_CHLOROPHYTE);
        this.putTargetWithItemRender(Blocks.POLISHED_BLACKSTONE_PRESSURE_PLATE, 16729600, true, ShowType.DANGER, Items.POLISHED_BLACKSTONE_PRESSURE_PLATE);
        this.putTargetWithItemRender(Blocks.STONE_PRESSURE_PLATE, 16729600, true, ShowType.DANGER, Items.STONE_PRESSURE_PLATE);
        this.putTargetWithItemRender((Block)FunctionalBlocks.STONE_PRESSURE_PLATE.get(), 16729600, true, ShowType.DANGER, ((SignalPressurePlateBlock)FunctionalBlocks.STONE_PRESSURE_PLATE.get()).asItem());
        this.putTargetWithItemRender((Block)FunctionalBlocks.INSTANTANEOUS_EXPLOSION_TNT.get(), 16729600, true, ShowType.DANGER, ((InstantExplosionBlock)FunctionalBlocks.INSTANTANEOUS_EXPLOSION_TNT.get()).asItem());
        this.putTargetWithItemRender((Block)FunctionalBlocks.SWITCH.get(), 16729600, true, ShowType.DANGER, ((SwitchBlock)FunctionalBlocks.SWITCH.get()).asItem());
        this.putTargetWithItemRender((Block)FunctionalBlocks.DART_TRAP.get(), 16729600, true, ShowType.DANGER, ((DartTrapBlock)FunctionalBlocks.DART_TRAP.get()).asItem());
        this.putTargetWithItemRender((Block)FunctionalBlocks.STONE_DART_TRAP.get(), 16729600, true, ShowType.DANGER, ((DartTrapBlock)FunctionalBlocks.STONE_DART_TRAP.get()).asItem());
        this.putTargetWithItemRender((Block)FunctionalBlocks.DEEPSLATE_DART_TRAP.get(), 16729600, true, ShowType.DANGER, ((DartTrapBlock)FunctionalBlocks.DEEPSLATE_DART_TRAP.get()).asItem());
        this.putTargetWithItemRender((Block)FunctionalBlocks.DEEPSLATE_PRESSURE_PLATE.get(), 16729600, true, ShowType.DANGER, ((SignalPressurePlateBlock)FunctionalBlocks.DEEPSLATE_PRESSURE_PLATE.get()).asItem());
        this.putTargetWithItemRender(Blocks.TNT, 16729600, true, ShowType.DANGER, Items.TNT);
        this.putTargetWithItemRender(Blocks.TRIPWIRE, 16729600, true, ShowType.DANGER, Items.TRIPWIRE_HOOK);
        this.putTargetWithItemRender(Blocks.SCULK_SHRIEKER, 16729600, true, ShowType.DANGER, Items.SCULK_SHRIEKER);
        this.putTargetWithItemRender(Blocks.SCULK_SENSOR, 16729600, true, ShowType.DANGER, Items.SCULK_SENSOR);
        this.putTargetWithItemRender(Blocks.DETECTOR_RAIL, 16729600, true, ShowType.DANGER, Items.DETECTOR_RAIL);
        this.putTargetWithItemRender(Blocks.ACTIVATOR_RAIL, 16729600, true, ShowType.DANGER, Items.ACTIVATOR_RAIL);
        this.putTargetWithItemRender(Blocks.ACACIA_PRESSURE_PLATE, 16729600, true, ShowType.DANGER, Items.ACACIA_PRESSURE_PLATE);
        this.putTargetWithItemRender(Blocks.BAMBOO_PRESSURE_PLATE, 16729600, true, ShowType.DANGER, Items.BAMBOO_PRESSURE_PLATE);
        this.putTargetWithItemRender(Blocks.HEAVY_WEIGHTED_PRESSURE_PLATE, 16729600, true, ShowType.DANGER, Items.HEAVY_WEIGHTED_PRESSURE_PLATE);
        this.putTargetWithItemRender(Blocks.BIRCH_PRESSURE_PLATE, 16729600, true, ShowType.DANGER, Items.BIRCH_PRESSURE_PLATE);
        this.putTargetWithItemRender(Blocks.CRIMSON_PRESSURE_PLATE, 16729600, true, ShowType.DANGER, Items.CRIMSON_PRESSURE_PLATE);
        this.putTargetWithItemRender(Blocks.CHERRY_PRESSURE_PLATE, 16729600, true, ShowType.DANGER, Items.CHERRY_PRESSURE_PLATE);
        this.putTargetWithItemRender(Blocks.WARPED_PRESSURE_PLATE, 16729600, true, ShowType.DANGER, Items.WARPED_PRESSURE_PLATE);
        this.putTargetWithItemRender(Blocks.SPRUCE_PRESSURE_PLATE, 16729600, true, ShowType.DANGER, Items.SPRUCE_PRESSURE_PLATE);
        this.putTargetWithItemRender(Blocks.DARK_OAK_PRESSURE_PLATE, 16729600, true, ShowType.DANGER, Items.DARK_OAK_PRESSURE_PLATE);
        this.putTargetWithItemRender(Blocks.OAK_PRESSURE_PLATE, 16729600, true, ShowType.DANGER, Items.OAK_PRESSURE_PLATE);
        this.putTargetWithItemRender(Blocks.JUNGLE_PRESSURE_PLATE, 16729600, true, ShowType.DANGER, Items.JUNGLE_PRESSURE_PLATE);
        this.putTargetWithItemRender(Blocks.LIGHT_WEIGHTED_PRESSURE_PLATE, 16729600, true, ShowType.DANGER, Items.LIGHT_WEIGHTED_PRESSURE_PLATE);
        this.putTargetWithItemRender(Blocks.MANGROVE_PRESSURE_PLATE, 16729600, true, ShowType.DANGER, Items.MANGROVE_PRESSURE_PLATE);
        this.putTargetWithItemRender(Blocks.POLISHED_BLACKSTONE_PRESSURE_PLATE, 16729600, true, ShowType.DANGER, Items.POLISHED_BLACKSTONE_PRESSURE_PLATE);
        this.putTargetWithItemRender(Blocks.COBWEB, 16729600, true, ShowType.DANGER, Items.COBWEB);
        this.putTargetWithItemRender(Blocks.DISPENSER, 16729600, true, ShowType.DANGER, Items.DISPENSER);
        this.putTargetWithItemRender((Block)FunctionalBlocks.PLAYER_PRESSURE_PLATE.get(), 16729600, true, ShowType.DANGER, ((BehaviourPressurePlateBlock)FunctionalBlocks.PLAYER_PRESSURE_PLATE.get()).asItem());
        this.putTargetWithItemRender((Block)FunctionalBlocks.NORMAL_BOULDER.get(), 16729600, true, ShowType.DANGER, ((AbstractBoulderBlock)FunctionalBlocks.NORMAL_BOULDER.get()).asItem());
        this.putTargetWithItemRender((Block)FunctionalBlocks.OAK_LOG_BOULDER.get(), 16729600, true, ShowType.DANGER, ((AbstractBoulderBlock)FunctionalBlocks.OAK_LOG_BOULDER.get()).asItem());
        this.putTargetWithItemRender((Block)FunctionalBlocks.FOLLOWER_BOULDER.get(), 16729600, true, ShowType.DANGER, ((AbstractBoulderBlock)FunctionalBlocks.FOLLOWER_BOULDER.get()).asItem());
        this.putTargetWithItemRender((Block)FunctionalBlocks.EXPLODE_BOULDER.get(), 16729600, true, ShowType.DANGER, ((AbstractBoulderBlock)FunctionalBlocks.EXPLODE_BOULDER.get()).asItem());
        this.putTargetWithItemRender((Block)FunctionalBlocks.ROLLING_CACTUS_BOULDER.get(), 16729600, true, ShowType.DANGER, ((AbstractBoulderBlock)FunctionalBlocks.ROLLING_CACTUS_BOULDER.get()).asItem());
        this.putTargetWithItemRender((Block)FunctionalBlocks.MECHANICAL_FRAGILE_SANDSTONE.get(), 16729600, true, ShowType.DANGER, ((MechanicalFragileBlock)FunctionalBlocks.MECHANICAL_FRAGILE_SANDSTONE.get()).asItem());
        this.putTargetWithItemRender((Block)FunctionalBlocks.MECHANICAL_FRAGILE_OBSIDIAN_BRICKS.get(), 16729600, true, ShowType.DANGER, ((MechanicalFragileBlock)FunctionalBlocks.MECHANICAL_FRAGILE_OBSIDIAN_BRICKS.get()).asItem());
        this.putTargetWithItemRender((Block)FunctionalBlocks.SCULK_TRAP.get(), 16729600, true, ShowType.DANGER, ((SculkTrapBlock)((Object)FunctionalBlocks.SCULK_TRAP.get())).asItem());
        this.putTargetWithItemRender((Block)FunctionalBlocks.SHIMMER_TRAP.get(), 16729600, true, ShowType.DANGER, ((StepOnTrapBlock)((Object)FunctionalBlocks.SHIMMER_TRAP.get())).asItem());
        this.putTargetWithItemRender((Block)FunctionalBlocks.GRAVITATION_TRAP.get(), 16729600, true, ShowType.DANGER, ((StepOnTrapBlock)((Object)FunctionalBlocks.GRAVITATION_TRAP.get())).asItem());
        this.putTargetWithItemRender((Block)FunctionalBlocks.PNEUMATIC_TRAP.get(), 16729600, true, ShowType.DANGER, ((StepOnTrapBlock)((Object)FunctionalBlocks.PNEUMATIC_TRAP.get())).asItem());
        this.putTargetWithItemRender((Block)FunctionalBlocks.SPIKE.get(), 16729600, true, ShowType.DANGER, ((SpikeBlock)((Object)FunctionalBlocks.SPIKE.get())).asItem());
        this.putTargetWithItemRender((Block)ChestBlocks.DEATH_GOLDEN_CHEST.get(), 16729600, true, ShowType.DANGER, ChestBlocks.DEATH_GOLDEN_CHEST.asItem());
        this.putTargetWithItemRender((Block)ChestBlocks.DEATH_WOODEN_CHEST.get(), 16729600, true, ShowType.DANGER, ChestBlocks.DEATH_WOODEN_CHEST.asItem());
    }

    @Deprecated
    private void putTarget(Block block, Color color, boolean always, ShowType showType) {
        this.putTarget(block, color.getRGB(), always, showType);
    }

    private void putTarget(Block block, int rgb, boolean always, ShowType showType) {
        this.putTargetWithTexture(block, rgb, always, showType, Items.AIR);
    }

    private void putTargetWithItemRender(Block block, int rgb, boolean always, ShowType showType, Item showItem) {
        this.targets.put(block, new Entry(rgb, always, showType, showItem.getDefaultInstance(), EMPTY, false));
    }

    private void putTargetWithTexture(Block block, int rgb, boolean always, ShowType showType, Item showItem) {
        this.targets.put(block, new Entry(rgb, always, showType, ItemStack.EMPTY, SpelunkerHelper.getResource(showItem, "item/"), true));
    }

    private void putMaterialTarget(Block block, int rgb, boolean always, ShowType showType, DeferredItem<?> item) {
        this.targets.put(block, new Entry(rgb, always, showType, ItemStack.EMPTY, SpelunkerHelper.getResource((Item)item.get(), "item/materials/"), true));
    }

    private static ResourceLocation getResource(Item item, String prefixAfterTexture) {
        ResourceLocation resourcelocation = BuiltInRegistries.ITEM.getKey((Object)item);
        return resourcelocation.withPrefix("textures/" + prefixAfterTexture);
    }

    private void putWithSpecialIconTarget(Block block, int rgb, boolean always, ShowType showType, String iconName) {
        this.targets.put(block, new Entry(rgb, always, showType, ItemStack.EMPTY, ResourceLocation.fromNamespaceAndPath((String)"confluence", (String)("textures/item/icon/" + iconName)), true));
    }

    private void refreshBlocks() {
        if (tracker == null || tracker.isClosed()) {
            tracker = TrackersMonitor.getTracker();
        }
        for (Map.Entry<Block, List<BlockPos>> n : this.blockMap.entrySet()) {
            n.getValue().clear();
        }
        this.blockMap.clear();
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        Level level = player.level();
        BlockPos center = player.blockPosition();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int i = -this.range; i <= this.range; ++i) {
            pos.setX(center.getX() + i);
            for (int j = -this.range; j < this.range; ++j) {
                pos.setY(center.getY() + j);
                for (int k = -this.range; k < this.range; ++k) {
                    Block block;
                    pos.setZ(center.getZ() + k);
                    BlockState blockState = level.getBlockState((BlockPos)pos);
                    if (blockState.isAir() || !(this.targets.containsKey(block = blockState.getBlock()) && (this.targets.get((Object)block).showType == ShowType.SPELUNKER && player.hasEffect(ModEffects.SPELUNKER) || this.targets.get((Object)block).showType == ShowType.DANGER && player.hasEffect(ModEffects.DANGER_SENSE))) && (!blockState.is(Tags.Blocks.ORES) || !player.hasEffect(ModEffects.SPELUNKER))) continue;
                    this.blockMap.computeIfAbsent(block, k1 -> new ArrayList()).add(pos.immutable());
                }
            }
        }
    }

    protected void buildBuffer(BufferBuilder buffer) {
        LocalPlayer player;
        this.centers.clear();
        this.centerCacheFrame.clear();
        if (!this.cachedPointers.isEmpty()) {
            this.cachedPointers.values().forEach(lc -> {
                lc.isAlive = false;
            });
        }
        if ((player = Minecraft.getInstance().player) == null) {
            return;
        }
        if (--this.buildCount <= 0) {
            this.buildCount = 10;
            this.refreshBlocks();
        }
        for (Map.Entry<Block, List<BlockPos>> n : this.blockMap.entrySet()) {
            this.centers.put(n.getKey(), new ArrayList());
            Entry target = SpelunkerHelper.blockGen.targets.get(n.getKey());
            int rgb = target != null ? target.color() : n.getKey().defaultBlockState().getMapColor((BlockGetter)player.level(), n.getValue().getFirst()).calculateRGBColor(MapColor.Brightness.HIGH);
            if (n.getValue() == null) {
                return;
            }
            int r = rgb >> 16 & 0xFF;
            int g = rgb >> 8 & 0xFF;
            int b = rgb & 0xFF;
            for (BlockPos blockPos : n.getValue()) {
                int a;
                if (blockPos == null) {
                    return;
                }
                float size = 1.0f;
                boolean ifNear = false;
                if (player.level().getBlockState(blockPos).is(Blocks.AIR)) {
                    this.centerCache.remove(blockPos);
                    ArrayList<BlockPos> list = this.centers.get(n.getKey());
                    if (list != null && !list.isEmpty()) {
                        list.removeIf(centerPos -> centerPos.distSqr((Vec3i)blockPos) < 25.0);
                    }
                }
                if (target != null && target.showType == ShowType.SPELUNKER || n.getKey().defaultBlockState().is(Tags.Blocks.ORES)) {
                    if (!player.hasEffect(ModEffects.SPELUNKER)) continue;
                    for (BlockPos centerPos2 : this.centers.get(n.getKey())) {
                        double distance = centerPos2.distSqr((Vec3i)blockPos);
                        if (!(distance < (double)SpelunkerHelper.blockGen.centerInternal)) continue;
                        this.centerCache.put(blockPos, centerPos2);
                        ifNear = true;
                        break;
                    }
                    if (ifNear) {
                        if (!((KeyMapping)ModKeyBindings.SHOW_DETAIL_SPECULAR.get()).isDown()) {
                            continue;
                        }
                    } else {
                        this.centers.get(n.getKey()).add(blockPos);
                        this.centerCacheFrame.put(blockPos, n.getKey());
                    }
                } else if (target != null && target.showType == ShowType.DANGER) {
                    if (!player.hasEffect(ModEffects.DANGER_SENSE)) continue;
                    this.centerCacheFrame.put(blockPos, n.getKey());
                }
                if ((a = (int)((255.0 - Math.min(player.distanceToSqr((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ()) / (double)(SpelunkerHelper.blockGen.range * SpelunkerHelper.blockGen.range) * 255.0, 255.0)) * (double)SpelunkerHelper.blockGen.maxAlpha)) <= 0) continue;
                if (((KeyMapping)ModKeyBindings.SHOW_DETAIL_SPECULAR.get()).isDown()) {
                    boolean west;
                    this.cachedPointers.values().forEach(controller -> controller.component.setVisible(true));
                    Block self = player.level().getBlockState(blockPos).getBlock();
                    boolean up = player.level().getBlockState(blockPos.above()).getBlock() != self;
                    boolean down = player.level().getBlockState(blockPos.below()).getBlock() != self;
                    boolean north = player.level().getBlockState(blockPos.north()).getBlock() != self;
                    boolean south = player.level().getBlockState(blockPos.south()).getBlock() != self;
                    boolean east = player.level().getBlockState(blockPos.east()).getBlock() != self;
                    boolean bl = west = player.level().getBlockState(blockPos.west()).getBlock() != self;
                    if (!up && !down && !north && !south && !east && !west) continue;
                    ShaderUtil.renderDebugBlock((BufferBuilder)buffer, (BlockPos)blockPos, (float)1.0f, (int)r, (int)g, (int)b, (int)a, (boolean)up, (boolean)down, (boolean)north, (boolean)south, (boolean)east, (boolean)west);
                    continue;
                }
                this.cachedPointers.values().forEach(controller -> controller.component.setVisible(false));
                ShaderUtil.renderDebugBlock((BufferBuilder)buffer, (BlockPos)blockPos, (float)1.0f, (int)r, (int)g, (int)b, (int)a);
            }
            this.centerCacheFrame.keySet().forEach(pos -> this.tryComputePointers((BlockPos)pos, target));
        }
        this.cachedPointers.values().removeIf(controller -> {
            if (!controller.isAlive) {
                controller.component.close();
                return true;
            }
            return false;
        });
    }

    private void tryComputePointers(BlockPos blockPos, Entry target) {
        if (tracker != null) {
            if (target != null && !target.isLocation) {
                COMPONENT_BUILDER.setIcon1(target.showItem);
            } else {
                COMPONENT_BUILDER.setIcon1(target != null ? target.showIcon : EMPTY);
            }
            this.cachedPointers.compute(blockPos, (pos, controller) -> {
                if (controller == null) {
                    StaticComponent component = tracker.addStaticPosComponent("confluence", "oreTrack", COMPONENT_BUILDER.build(), false);
                    Vec3 pos1 = blockPos.getCenter();
                    component.posUpdater(pos2 -> pos1);
                    return new StaticComponentLifeController(component);
                }
                controller.isAlive = true;
                return controller;
            });
        }
    }

    protected void beforeRender() {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)2848);
        GL11.glDisable((int)2929);
    }

    protected void afterRender(PoseStack poseStack) {
    }

    public static void renderLevel(RenderLevelStageEvent event, LocalPlayer player) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        SpelunkerHelper blockGen = SpelunkerHelper.getSingleton();
        if (!player.hasEffect(ModEffects.SPELUNKER) && !player.hasEffect(ModEffects.DANGER_SENSE)) {
            blockGen.centerCache.clear();
            blockGen.centers.clear();
            blockGen.blockMap.clear();
            blockGen.centerCacheFrame.clear();
            blockGen.cachedPointers.values().forEach(controller -> controller.component.close());
            blockGen.cachedPointers.clear();
            return;
        }
        lock = true;
        blockGen.render(event);
        lock = false;
    }

    private void reverseBobView(PoseStack poseStack, float partialTicks) {
        if (Minecraft.getInstance().player != null) {
            LocalPlayer player = Minecraft.getInstance().player;
            float f = player.walkDist - player.walkDistO;
            float f1 = -(player.walkDist + f * partialTicks);
            float f2 = Mth.lerp((float)partialTicks, (float)player.oBob, (float)player.bob);
            poseStack.mulPose(Axis.XP.rotationDegrees(-Math.abs(Mth.cos((float)(f1 * (float)Math.PI - 0.2f)) * f2) * 5.0f));
            poseStack.mulPose(Axis.ZP.rotationDegrees(-Mth.sin((float)(f1 * (float)Math.PI)) * f2 * 3.0f));
            poseStack.translate(-Mth.sin((float)(f1 * (float)Math.PI)) * f2 * 0.5f, Math.abs(Mth.cos((float)(f1 * (float)Math.PI)) * f2), 0.0f);
        }
    }

    static {
        lock = true;
        COMPONENT_BUILDER = new ComponentBuilder().setComponentType(ComponentBuilder.ComponentType.DIRECT).setAffectedByPlayerSettingsScale(false).defineRescale(scale -> Float.valueOf(scale.floatValue() * 0.8f)).defineAlphaTransformer((distance, alpha) -> {
            if (distance.floatValue() <= 15.0f) {
                return Float.valueOf(1.0f);
            }
            return Float.valueOf((float)Math.exp(-(distance.floatValue() - 15.0f) / 20.0f));
        });
        EMPTY = TextureMapping.getItemTexture((Item)Items.AIR);
    }

    private static enum ShowType implements StringRepresentable
    {
        SPELUNKER,
        DANGER;

        private static final Codec<ShowType> CODEC;

        @NotNull
        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromEnum(ShowType::values);
        }
    }

    private record Entry(int color, boolean showText, ShowType showType, ItemStack showItem, ResourceLocation showIcon, boolean isLocation) {
        private static final Codec<Entry> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("color").forGetter(Entry::color), (App)Codec.BOOL.fieldOf("showText").forGetter(Entry::showText), (App)ShowType.CODEC.fieldOf("showType").forGetter(Entry::showType), (App)ItemStack.CODEC.fieldOf("showItem").forGetter(Entry::showItem), (App)ResourceLocation.CODEC.fieldOf("showIcon").forGetter(Entry::showIcon), (App)Codec.BOOL.fieldOf("isLocation").forGetter(Entry::isLocation)).apply((Applicative)builder, Entry::new));
        private static final MapCodec<Map<Block, Entry>> BLOCK_MAP_CODEC = Codec.unboundedMap((Codec)BuiltInRegistries.BLOCK.byNameCodec(), CODEC).fieldOf("targets").fieldOf("values");
    }

    public static final class StaticComponentLifeController {
        public final StaticComponent component;
        public boolean isAlive;

        public StaticComponentLifeController(StaticComponent component) {
            this.component = component;
        }
    }
}

