/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.effect.connected;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import org.confluence.mod.client.effect.connected.ModConnectives;
import org.confluence.mod.client.effect.connected.NonNullBiConsumer;
import org.confluence.mod.client.effect.connected.NonNullFunction;

public class CustomBlockModels {
    private final Multimap<ResourceLocation, NonNullFunction<BakedModel, ? extends BakedModel>> modelFuncs = MultimapBuilder.hashKeys().arrayListValues().build();
    private final Set<Block> registered = new HashSet<Block>();
    private final Map<Block, NonNullFunction<BakedModel, ? extends BakedModel>> finalModelFuncs = new IdentityHashMap<Block, NonNullFunction<BakedModel, ? extends BakedModel>>();
    private boolean funcsLoaded = false;

    public void register(Block block, NonNullFunction<BakedModel, ? extends BakedModel> func) {
        this.modelFuncs.put((Object)BuiltInRegistries.BLOCK.getKey((Object)block), func);
        this.registered.add(block);
    }

    public void forEach(NonNullBiConsumer<Block, NonNullFunction<BakedModel, ? extends BakedModel>> consumer) {
        this.loadEntriesIfMissing();
        this.finalModelFuncs.forEach(consumer);
    }

    private void loadEntriesIfMissing() {
        if (!this.funcsLoaded) {
            ModConnectives.register();
            this.loadEntries();
            this.funcsLoaded = true;
        }
    }

    private void loadEntries() {
        this.finalModelFuncs.clear();
        this.modelFuncs.asMap().forEach((? super K location, ? super V funcList) -> {
            Block block = (Block)BuiltInRegistries.BLOCK.get(location);
            NonNullFunction finalFunc = null;
            for (NonNullFunction func : funcList) {
                if (finalFunc == null) {
                    finalFunc = func;
                    continue;
                }
                finalFunc = finalFunc.andThen(func);
            }
            this.finalModelFuncs.put(block, finalFunc);
        });
    }

    public boolean containsBlock(Block block) {
        return this.registered.contains(block);
    }
}

