/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.effect.connected.custom;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.confluence.mod.client.effect.connected.BakedQuadHelper;
import org.confluence.mod.client.effect.connected.CTModel;
import org.confluence.mod.client.effect.connected.CTSpriteShiftEntry;
import org.confluence.mod.client.effect.connected.behaviour.ConnectedTextureBehaviour;
import org.jetbrains.annotations.NotNull;

public class RandomizeCTModel
extends CTModel {
    private final int width;

    public RandomizeCTModel(BakedModel originalModel, ConnectedTextureBehaviour behaviour, int width) {
        super(originalModel, behaviour);
        this.width = width;
    }

    @Override
    @NotNull
    public List<BakedQuad> getQuads(BlockState state, Direction side, RandomSource rand, ModelData extraData, RenderType renderType) {
        ArrayList<BakedQuad> quads = this.originalModel.getQuads(state, side, rand, extraData, renderType);
        CTModel.CTData data = (CTModel.CTData)extraData.get(CT_PROPERTY);
        if (data == null) {
            return quads;
        }
        int selected = rand.nextInt(this.width);
        quads = new ArrayList<BakedQuad>(quads);
        for (int i = 0; i < quads.size(); ++i) {
            CTSpriteShiftEntry spriteShift;
            BakedQuad quad = (BakedQuad)quads.get(i);
            int index = data.get(quad.getDirection());
            if (index == -1 || (spriteShift = this.behaviour.getShift(state, quad.getDirection(), quad.getSprite())) == null || quad.getSprite() != spriteShift.getOriginal()) continue;
            BakedQuad newQuad = BakedQuadHelper.clone(quad);
            int[] vertexData = newQuad.getVertices();
            for (int vertex = 0; vertex < 4; ++vertex) {
                float u = BakedQuadHelper.getU(vertexData, vertex);
                float v = BakedQuadHelper.getV(vertexData, vertex);
                BakedQuadHelper.setU(vertexData, vertex, spriteShift.getSelectedTargetU(u, index, selected, this.width));
                BakedQuadHelper.setV(vertexData, vertex, spriteShift.getTargetV(v, index));
            }
            quads.set(i, newQuad);
        }
        return quads;
    }
}

