/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.effect.textures;

import it.unimi.dsi.fastutil.longs.Long2ObjectFunction;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.common.data.saved.BrushData;
import org.confluence.mod.network.s2c.BrushingColorPacketS2C;
import org.jetbrains.annotations.Nullable;

public final class LocalBrushData {
    private static final Long2ObjectMap<int[]> DATA = new Long2ObjectOpenHashMap();

    public static void putData(BlockPos pos, Direction facing, int color) {
        try {
            ((int[])LocalBrushData.DATA.computeIfAbsent((long)pos.asLong(), (Long2ObjectFunction)(Long2ObjectFunction)LambdaMetafactory.metafactory(null, null, null, (J)Ljava/lang/Object;, lambda$putData$0(long ), (J)[I)()))[facing.get3DDataValue()] = color;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int @Nullable [] getColors(BlockPos pos) {
        try {
            return (int[])DATA.get(pos.asLong());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean hasEcho(BlockPos pos) {
        return LocalBrushData.hasEcho(pos.asLong());
    }

    public static boolean hasEcho(long pos) {
        try {
            int[] colors = (int[])DATA.get(pos);
            return colors != null && colors[0] == -5;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static int getColor(BlockPos pos, @Nullable Direction facing) {
        if (facing == null) {
            return -1;
        }
        try {
            int[] colors = (int[])DATA.get(pos.asLong());
            return colors == null ? -1 : colors[facing.get3DDataValue()];
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static void removeData(BlockPos pos, Direction facing) {
        try {
            int[] colors = (int[])DATA.get(pos.asLong());
            if (colors != null) {
                colors[facing.get3DDataValue()] = -1;
                if (Arrays.stream(colors).allMatch(i -> i == -1)) {
                    DATA.remove(pos.asLong());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void reset() {
        DATA.clear();
    }

    public static void handlePacket(BrushingColorPacketS2C packet) {
        HashSet<SectionPos> sectionPoses = new HashSet<SectionPos>();
        for (Map.Entry<BlockPos, int[]> entry : packet.data().colors().entrySet()) {
            BlockPos pos = entry.getKey();
            int[] colors = entry.getValue();
            for (int i = 0; i < 6; ++i) {
                int color = colors[i];
                Direction facing = LibUtils.DIRECTIONS[i];
                if (color == -2) {
                    LocalBrushData.removeData(pos, facing);
                    continue;
                }
                if (color == -1) continue;
                LocalBrushData.putData(pos, facing, color);
            }
            sectionPoses.add(SectionPos.of((BlockPos)pos));
        }
        for (SectionPos sectionPos : sectionPoses) {
            Minecraft.getInstance().levelRenderer.setSectionDirty(sectionPos.x(), sectionPos.y(), sectionPos.z());
        }
    }

    private static /* synthetic */ int[] lambda$putData$0(long l) {
        return BrushData.createColor(-1);
    }
}

