/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.event;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.stats.StatsCounter;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.AddAttributeTooltipsEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.GatherEffectScreenTooltipsEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.MovementInputUpdateEvent;
import net.neoforged.neoforge.client.event.RenderArmEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.event.RenderLivingEvent;
import net.neoforged.neoforge.client.event.RenderNameTagEvent;
import net.neoforged.neoforge.client.event.RenderPlayerEvent;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.confluence.lib.client.animate.ExpertColorAnimation;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.api.event.AfterFlushArmorSetBonusEvent;
import org.confluence.mod.client.ClientConfigs;
import org.confluence.mod.client.effect.EctoMistHelper;
import org.confluence.mod.client.effect.SpelunkerHelper;
import org.confluence.mod.client.effect.textures.LocalBrushData;
import org.confluence.mod.client.event.ModClientSetups;
import org.confluence.mod.client.gameevent.ClientGameEventSystem;
import org.confluence.mod.client.gui.container.ExtraInventoryScreen;
import org.confluence.mod.client.gui.hud.HouseSelectHUD;
import org.confluence.mod.client.handler.ClientPacketHandler;
import org.confluence.mod.client.handler.CompatibilityHandler;
import org.confluence.mod.client.handler.DropletsHandler;
import org.confluence.mod.client.handler.HookThrowingHandler;
import org.confluence.mod.client.handler.KeyRequestHandler;
import org.confluence.mod.client.handler.LucyTheAxeHandler;
import org.confluence.mod.client.handler.MeteorLandingHandler;
import org.confluence.mod.client.handler.StarPhaseHandler;
import org.confluence.mod.client.handler.WeatherHandler;
import org.confluence.mod.client.handler.bestiary.ClientBestiary;
import org.confluence.mod.client.renderer.item.DungeonCompassRenderer;
import org.confluence.mod.client.renderer.item.LucyTheAxeDialogRenderer;
import org.confluence.mod.client.renderer.item.ZombieArmRenderer;
import org.confluence.mod.common.component.ValueComponent;
import org.confluence.mod.common.component.prefix.PrefixComponent;
import org.confluence.mod.common.component.prefix.PrefixType;
import org.confluence.mod.common.data.map.DiggingPower;
import org.confluence.mod.common.init.ModEffects;
import org.confluence.mod.common.init.ModTags;
import org.confluence.mod.common.init.armor.ModArmorBonus;
import org.confluence.mod.common.init.block.NatureBlocks;
import org.confluence.mod.common.init.item.SwordItems;
import org.confluence.mod.common.item.spear.AbstractSpearItem;
import org.confluence.mod.common.item.sword.BaseSwordItem;
import org.confluence.mod.integration.ars_nouveau.ArsNouveauHelper;
import org.confluence.mod.integration.irons_spell.IronSpellHelper;
import org.confluence.mod.integration.prism_lib.PrismLibHelper;
import org.confluence.mod.mixed.IClientLivingEntity;
import org.confluence.mod.mixed.ILocalPlayer;
import org.confluence.mod.mixed.IMobEffectInstance;
import org.confluence.mod.network.c2s.EmptyTargetSweepPacketC2S;
import org.confluence.mod.network.c2s.SpearAttackPacketC2S;
import org.confluence.mod.network.c2s.SwordProjectilePacketC2S;
import org.confluence.mod.util.DeathAnimUtils;
import org.confluence.mod.util.ModAttributeUtils;
import org.confluence.mod.util.ModUtils;
import org.confluence.mod.util.PlayerUtils;
import org.confluence.mod.util.PrefixUtils;
import org.confluence.terra_curio.api.event.PlayerEmptyAutoAttackEvent;
import org.confluence.terraentity.api.event.NPCEvent;
import org.confluence.terraentity.init.entity.TENpcEntities;
import software.bernie.geckolib.event.GeoRenderEvent;

@EventBusSubscriber(value={Dist.CLIENT}, modid="confluence")
public final class GameClientEvents {
    @SubscribeEvent
    public static void clientTick$Pre(ClientTickEvent.Pre event) {
        Item item;
        ItemStack itemStack;
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        if (player == null) {
            return;
        }
        if (minecraft.gameMode != null && !minecraft.gameMode.isDestroying() && minecraft.options.keyAttack.isDown() && !(itemStack = player.getMainHandItem()).isEmpty() && (item = itemStack.getItem()) instanceof AbstractSpearItem) {
            AbstractSpearItem spearItem = (AbstractSpearItem)item;
            CompoundTag tag = LibUtils.getItemStackNbtIfPresent((ItemStack)itemStack);
            if (tag != null && player.level().getGameTime() - tag.getLong("confluence:last_attack_time") > (long)spearItem.getAttackDuration()) {
                SpearAttackPacketC2S.sendToServer();
            }
        }
        EctoMistHelper.tick(minecraft, player);
        ModClientSetups.GLINT_RAINBOW.setGlintColor(ExpertColorAnimation.INSTANCE.getRed(), ExpertColorAnimation.INSTANCE.getGreen(), ExpertColorAnimation.INSTANCE.getBlue());
    }

    @SubscribeEvent
    public static void clientTick$Post(ClientTickEvent.Post event) {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        if (player != null) {
            Item item;
            WeatherHandler.handle();
            MeteorLandingHandler.handle(minecraft, (Player)player);
            HookThrowingHandler.handle(player);
            KeyRequestHandler.handle();
            DropletsHandler.handle(minecraft, player);
            DeathAnimUtils.handle(player.clientLevel);
            LucyTheAxeHandler.handle(player.getId());
            if (minecraft.options.keyAttack.isDown() && (item = player.getMainHandItem().getItem()) instanceof BaseSwordItem) {
                BaseSwordItem sword = (BaseSwordItem)item;
                if (!player.getCooldowns().isOnCooldown((Item)sword)) {
                    SwordProjectilePacketC2S.sendToServer();
                }
            }
            HouseSelectHUD.updatePlayerRegionAt(player);
            ClientGameEventSystem.handle(player);
        }
        DeathAnimUtils.clear();
    }

    @SubscribeEvent
    public static void clientPlayerNetwork$LoggingIn(ClientPlayerNetworkEvent.LoggingIn event) {
        WeatherHandler.initialize((Player)event.getPlayer());
    }

    @SubscribeEvent
    public static void clientPlayerNetwork$LoggingOut(ClientPlayerNetworkEvent.LoggingOut event) {
        WeatherHandler.reset();
        MeteorLandingHandler.reset();
        LocalBrushData.reset();
        ClientPacketHandler.reset();
        CompatibilityHandler.reset();
        DropletsHandler.reset();
        EctoMistHelper.reset();
        ClientBestiary.reset();
        LucyTheAxeHandler.reset();
        ClientGameEventSystem.reset();
    }

    @SubscribeEvent
    public static void input$InteractionKeyMappingTriggered(InputEvent.InteractionKeyMappingTriggered event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if ((event.isUseItem() || event.isAttack() || event.isPickBlock()) && (!ILocalPlayer.of(player).confluence$isCanMove() || player.hasEffect(ModEffects.CURSED))) {
            event.setCanceled(true);
            event.setSwingHand(false);
        }
        if (event.getHand() == InteractionHand.MAIN_HAND) {
            if (HouseSelectHUD.inSelectHUD) {
                if (event.isUseItem()) {
                    HouseSelectHUD.selectHouse((Player)player);
                    player.swing(InteractionHand.MAIN_HAND);
                } else if (event.isAttack()) {
                    event.setCanceled(true);
                    event.setSwingHand(false);
                }
            } else if (player.getMainHandItem().is(ModTags.Items.SPEAR)) {
                if (event.isAttack()) {
                    event.setCanceled(true);
                }
                event.setSwingHand(false);
            }
        }
    }

    @SubscribeEvent
    public static void renderGuiOverlay$Pre(RenderGuiLayerEvent.Pre event) {
        ResourceLocation name = event.getName();
        if (ClientConfigs.terraStyleHealth && VanillaGuiLayers.PLAYER_HEALTH.equals((Object)name) || ClientConfigs.terraStyleFood && VanillaGuiLayers.FOOD_LEVEL.equals((Object)name) || ClientConfigs.terraStyleArmor && VanillaGuiLayers.ARMOR_LEVEL.equals((Object)name) || ArsNouveauHelper.cancelRenderManaBar(name) || IronSpellHelper.cancelRenderManaOverlay(name) || HouseSelectHUD.inSelectHUD && VanillaGuiLayers.CROSSHAIR.equals((Object)name)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void gatherComponents(RenderTooltipEvent.GatherComponents event) {
        Object t;
        ItemStack itemStack = event.getItemStack();
        if (itemStack.isEmpty()) {
            return;
        }
        List tooltipElements = event.getTooltipElements();
        if (PrismLibHelper.shouldSkipOriginalPrefixGather(itemStack, tooltipElements) || tooltipElements.isEmpty()) {
            return;
        }
        Optional displayName = ((Either)tooltipElements.getFirst()).left();
        if (displayName.isPresent() && (t = displayName.get()) instanceof Component) {
            Component component = (Component)t;
            PrefixComponent prefix = PrefixUtils.getPrefix(itemStack);
            if (prefix != null && prefix.type() != PrefixType.UNKNOWN) {
                tooltipElements.set(0, Either.left((Object)prefix.getName().setStyle(component.getStyle()).append((Component)Component.translatable((String)"confluence.prefix_separator")).append(component)));
            }
        }
    }

    @SubscribeEvent
    public static void itemToolTip(ItemTooltipEvent event) {
        int price;
        List toolTip = event.getToolTip();
        ItemStack itemStack = event.getItemStack();
        if (ClientConfigs.sellPriceDisplay.test() && (price = ValueComponent.getValue(itemStack, 0)) > 0) {
            toolTip.add(Component.translatable((String)"tooltip.price.sell").withStyle(ChatFormatting.GRAY).append(ModUtils.formatPrice(price)));
        }
        ModArmorBonus.addBonusTooltip(event.getEntity(), itemStack, toolTip);
        int power = DiggingPower.getPower(itemStack);
        if (power > 0) {
            if (itemStack.is(ItemTags.PICKAXES) || itemStack.is(ModTags.Items.TOOLS_DRILL)) {
                toolTip.add(Component.translatable((String)"tooltip.confluence.pickaxe_power", (Object[])new Object[]{power}).withStyle(ChatFormatting.GRAY));
            } else if (itemStack.is(ModTags.Items.TOOLS_HAMMER)) {
                toolTip.add(Component.translatable((String)"tooltip.confluence.hammer_power", (Object[])new Object[]{power}).withStyle(ChatFormatting.GRAY));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void addAttributeTooltips(AddAttributeTooltipsEvent event) {
        ModAttributeUtils.addPrefixTooltips(event);
    }

    @SubscribeEvent
    public static void movementInputUpdate(MovementInputUpdateEvent event) {
        Input input = event.getInput();
        LocalPlayer player = (LocalPlayer)event.getEntity();
        boolean cannotMove = player.hasEffect(ModEffects.STONED) || player.hasEffect(ModEffects.FROZEN);
        ILocalPlayer.of(player).confluence$setCanMove(!cannotMove);
        if (!player.hasInfiniteMaterials() && (cannotMove || player.hasEffect(ModEffects.SHIMMER) || player.getInBlockState().is((Block)NatureBlocks.CRIMSON_VENUS_FLYTRAP_BLOCK.get()))) {
            input.jumping = false;
            input.forwardImpulse = 0.0f;
            input.leftImpulse = 0.0f;
        }
    }

    @SubscribeEvent
    public static void renderLevelStage(RenderLevelStageEvent event) {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        if (player == null) {
            return;
        }
        SpelunkerHelper.renderLevel(event, player);
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_SKY) {
            StarPhaseHandler.render(event);
            MeteorLandingHandler.render(event);
            ClientGameEventSystem.afterRenderSky(event, player);
        } else if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            PoseStack poseStack = event.getPoseStack();
            DungeonCompassRenderer.renderInWorld(poseStack, player, minecraft);
            LucyTheAxeDialogRenderer.renderInWorld(minecraft, poseStack);
            HouseSelectHUD.renderRegionInWorld(minecraft);
        }
    }

    @SubscribeEvent
    public static void screen$Render$Post(ScreenEvent.Render.Post event) {
        LucyTheAxeDialogRenderer.renderDelayed(event.getGuiGraphics());
    }

    @SubscribeEvent
    public static void renderGui$Post(RenderGuiEvent.Post event) {
        if (Minecraft.getInstance().screen == null) {
            LucyTheAxeDialogRenderer.renderDelayed(event.getGuiGraphics());
        }
    }

    @SubscribeEvent
    public static void screen$Init$Post(ScreenEvent.Init.Post event) {
        Screen screen = event.getScreen();
        boolean isInventoryScreen = screen instanceof InventoryScreen;
        if (isInventoryScreen || screen instanceof CreativeModeInventoryScreen) {
            event.addListener((GuiEventListener)ExtraInventoryScreen.getExtraInventoryButton((EffectRenderingInventoryScreen)screen, isInventoryScreen));
        }
    }

    @SubscribeEvent
    public static void renderLiving$Post(RenderLivingEvent.Post<?, ?> event) {
        LivingEntity living = event.getEntity();
        if (ClientConfigs.goreEffect == ClientConfigs.GoreEffect.CONFLUENCE_VANILLA && !"minecraft".equals(BuiltInRegistries.ENTITY_TYPE.getKey((Object)living.getType()).getNamespace())) {
            return;
        }
        boolean dead = living.isDeadOrDying();
        if (dead != IClientLivingEntity.of(living).confluence$deadO(new boolean[0])) {
            living.level().getProfiler().push("entity_dismemberment");
            DeathAnimUtils.livingDeath(living);
            living.level().getProfiler().pop();
        }
        IClientLivingEntity.of(living).confluence$deadO(dead);
    }

    @SubscribeEvent
    public static void geoRender$Entity$Post(GeoRenderEvent.Entity.Post event) {
        if (ClientConfigs.goreEffect == ClientConfigs.GoreEffect.OFF) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(ClientConfigs.goreEffect != ClientConfigs.GoreEffect.CONFLUENCE && ClientConfigs.goreEffect != ClientConfigs.GoreEffect.CONFLUENCE_VANILLA || ModUtils.isFromConfluence(BuiltInRegistries.ENTITY_TYPE, entity.getType()))) {
            return;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            boolean dead = living.isDeadOrDying();
            if (dead != IClientLivingEntity.of(living).confluence$deadO(new boolean[0])) {
                living.level().getProfiler().push("geo_dismemberment");
                DeathAnimUtils.livingDeath(living);
                living.level().getProfiler().pop();
            }
            IClientLivingEntity.of(living).confluence$deadO(dead);
        }
    }

    @SubscribeEvent
    public static void renderPlayer$Pre(RenderPlayerEvent.Pre event) {
        ZombieArmRenderer.getInstance().render(event.getRenderer(), event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight(), event.getEntity(), event.getPartialTick());
    }

    @SubscribeEvent
    public static void renderArm(RenderArmEvent event) {
        AbstractClientPlayer player = event.getPlayer();
        PlayerRenderer playerRenderer = (PlayerRenderer)Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)player);
        boolean b = ZombieArmRenderer.getInstance().renderHand(playerRenderer, event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight(), player, event.getArm());
        if (b) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void npc$Dialog(NPCEvent.NPCDialogEvent event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        EntityType type = event.getNPC().getType();
        if (!ModClientSetups.guideCheckedJEI && type == TENpcEntities.GUIDE.get()) {
            event.setNeoDialog((Component)Component.translatable((String)"dialogs.terra_entity.guide.jei_check"));
            ModClientSetups.guideCheckedJEI = true;
        } else if (type == TENpcEntities.NURSE.get() && event.getNPC().getRandom().nextInt(25) == 0) {
            StatsCounter stats = player.getStats();
            for (Stat stat : Stats.ENTITY_KILLED_BY) {
                int value = stats.getValue(stat);
                if (value < 50) continue;
                event.setNeoDialog((Component)Component.translatable((String)"dialogs.terra_entity.nurse.player_killed_by", (Object[])new Object[]{((EntityType)stat.getValue()).getDescription(), value}));
                break;
            }
        }
    }

    @SubscribeEvent
    public static void gatherEffectScreenTooltips(GatherEffectScreenTooltipsEvent event) {
        String key;
        Optional optional = event.getEffectInstance().getEffect().unwrapKey();
        if (optional.isPresent() && I18n.exists((String)(key = Util.makeDescriptionId((String)"tooltip.effect", (ResourceLocation)((ResourceKey)optional.get()).location()) + ".0"))) {
            event.getTooltip().add(Component.translatable((String)key).withStyle(ChatFormatting.GRAY));
        }
        if (!IMobEffectInstance.of(event.getEffectInstance()).confluence$isEnabled()) {
            event.getTooltip().add(Component.translatable((String)"tooltip.confluence.disabled").withStyle(ChatFormatting.DARK_GRAY));
        }
    }

    @SubscribeEvent
    public static void renderNameTag(RenderNameTagEvent event) {
        TranslatableContents contents;
        ComponentContents componentContents;
        if (!event.canRender().isDefault()) {
            return;
        }
        Entity entity = event.getEntity();
        if ((entity.getType() == EntityType.ZOMBIE || entity.getType() == EntityType.SKELETON) && entity.hasCustomName() && (componentContents = event.getContent().getContents()) instanceof TranslatableContents && (contents = (TranslatableContents)componentContents).getKey().contains("confluence")) {
            if (entity == Minecraft.getInstance().getEntityRenderDispatcher().crosshairPickEntity) {
                event.setCanRender(TriState.TRUE);
            } else {
                event.setCanRender(TriState.FALSE);
            }
        }
    }

    @SubscribeEvent
    public static void playerInteract$LeftClickEmpty(PlayerInteractEvent.LeftClickEmpty event) {
        Player player = event.getEntity();
        if (!player.getMainHandItem().is(ModTags.Items.AUTO_ATTACK_WHITELIST) && PlayerUtils.couldPerformEmptyTargetSweep(player)) {
            EmptyTargetSweepPacketC2S.send2Server();
        }
    }

    @SubscribeEvent
    public static void playerInteract$LeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        Player player = event.getEntity();
        if (!player.getMainHandItem().is(ModTags.Items.AUTO_ATTACK_WHITELIST) && PlayerUtils.couldPerformEmptyTargetSweep(player)) {
            EmptyTargetSweepPacketC2S.send2Server();
        }
    }

    @SubscribeEvent
    public static void playerEmptyAutoAttack(PlayerEmptyAutoAttackEvent event) {
        Player player = event.getEntity();
        ItemStack itemStack = event.getItemStack();
        if (itemStack.is(SwordItems.NIGHTS_EDGE)) {
            if (!player.getCooldowns().isOnCooldown(itemStack.getItem())) {
                player.swing(InteractionHand.MAIN_HAND);
                player.resetAttackStrengthTicker();
            }
            event.setCanceled(true);
        } else if (PlayerUtils.couldPerformEmptyTargetSweep(player)) {
            EmptyTargetSweepPacketC2S.send2Server();
        }
    }

    @SubscribeEvent
    public static void afterFlushArmorSetBonus(AfterFlushArmorSetBonusEvent event) {
        ClientPacketHandler.setLuminance(event.getEntity(), event.getData());
    }
}

