/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.gameevent;

import com.google.common.collect.EvictingQueue;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.Queue;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.confluence.mod.Confluence;
import org.confluence.mod.client.gameevent.ClientGameEventSystem;
import org.confluence.mod.util.OverworldUtils;
import org.joml.Matrix4f;

final class SlimeRainSprite {
    static final ResourceLocation[] SLIME_RAIN_TEXTURES = new ResourceLocation[]{Confluence.asResource("textures/environment/slime_rain_blue.png"), Confluence.asResource("textures/environment/slime_rain_green.png"), Confluence.asResource("textures/environment/slime_rain_purple.png")};
    static final Queue<SlimeRainSprite> SPRITES = EvictingQueue.create((int)32);
    static boolean started;
    final float initialY = 88.0f + 2.0f * ClientGameEventSystem.random();
    final float yaw = (float)Math.PI * 2 * ClientGameEventSystem.random();
    final ResourceLocation texture = SLIME_RAIN_TEXTURES[(int)(ClientGameEventSystem.random() * 3.0f)];
    final float dist;
    final float alpha;
    final float radius;
    float v0;
    float v1 = 0.25f;
    int tick;
    float y;
    float yo;

    SlimeRainSprite() {
        int i = (int)(ClientGameEventSystem.random() * 75.0f);
        this.dist = i + 25;
        float j = Mth.clamp((float)((float)i / 75.0f - 0.25f), (float)0.0f, (float)1.0f);
        this.alpha = 1.0f - j;
        this.radius = 1.0f + j;
        this.y = this.yo = this.initialY;
    }

    void render(float partialTick, float a) {
        ClientGameEventSystem.poseStack.pushPose();
        ClientGameEventSystem.poseStack.mulPose(Axis.YP.rotation(this.yaw).rotateX(-1.5707964f));
        ClientGameEventSystem.poseStack.translate(0.0f, 0.0f, Mth.lerp((float)partialTick, (float)this.yo, (float)this.y));
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(this.alpha * a));
        Matrix4f matrix4f = ClientGameEventSystem.poseStack.last().pose();
        BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        builder.addVertex(matrix4f, -this.radius, this.dist, -this.radius).setUv(0.0f, this.v1);
        builder.addVertex(matrix4f, this.radius, this.dist, -this.radius).setUv(1.0f, this.v1);
        builder.addVertex(matrix4f, this.radius, this.dist, this.radius).setUv(1.0f, this.v0);
        builder.addVertex(matrix4f, -this.radius, this.dist, this.radius).setUv(0.0f, this.v0);
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
        ClientGameEventSystem.poseStack.popPose();
    }

    static void renderSlimeRain(LocalPlayer player, RenderLevelStageEvent event) {
        if (player.level().dimension() != OverworldUtils.dimension()) {
            return;
        }
        float partialTick = event.getPartialTick().getGameTimeDeltaPartialTick(false);
        float rainLevel = player.level().getRainLevel(partialTick);
        if (rainLevel > 0.99999f) {
            return;
        }
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        float a = (1.0f - rainLevel) * 0.5f;
        ClientGameEventSystem.poseStack.pushPose();
        ClientGameEventSystem.poseStack.mulPose(event.getModelViewMatrix());
        for (SlimeRainSprite sprite : SPRITES) {
            sprite.render(partialTick, a);
        }
        ClientGameEventSystem.poseStack.popPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
    }

    static void tick(long gameTime) {
        if (!started) {
            return;
        }
        if (gameTime % 10L == 0L) {
            SPRITES.add(new SlimeRainSprite());
        }
        for (SlimeRainSprite sprite : SPRITES) {
            ++sprite.tick;
            sprite.v0 = 0.25f * (float)((sprite.tick >> 1) % 4);
            sprite.v1 = sprite.v0 + 0.25f;
            sprite.yo = sprite.y;
            sprite.y = sprite.initialY - 180.0f * (float)sprite.tick / 320.0f;
        }
    }

    static void handle(Player player, boolean start) {
        started = start;
        if (!start) {
            SPRITES.clear();
        }
    }

    static void reset() {
        started = false;
        SPRITES.clear();
    }
}

