/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.gui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class GuiSprite {
    private final ResourceLocation path;
    private final int textureW;
    private final int textureH;
    private final int u;
    private final int v;
    private final int w;
    private final int h;
    private int x;
    private int y;
    @Nullable
    private GuiSprite hovered;

    public GuiSprite(ResourceLocation path, int width, int height) {
        this(path, width, height, 0, 0, width, height);
    }

    public GuiSprite(ResourceLocation path, int textureW, int textureH, int u, int v, int w, int h) {
        this.path = path;
        this.textureW = textureW;
        this.textureH = textureH;
        this.u = u;
        this.v = v;
        this.w = w;
        this.h = h;
    }

    public int getTextureW() {
        return this.textureW;
    }

    public int getTextureH() {
        return this.textureH;
    }

    public int getU() {
        return this.u;
    }

    public int getV() {
        return this.v;
    }

    public int getW() {
        return this.w;
    }

    public int getH() {
        return this.h;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getEndX() {
        return this.x + this.w;
    }

    public int getEndY() {
        return this.y + this.h;
    }

    public GuiSprite setPos(int x, int y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public GuiSprite setX(int x) {
        this.x = x;
        return this;
    }

    public GuiSprite setY(int y) {
        this.y = y;
        return this;
    }

    public GuiSprite setHovered(GuiSprite hovered) {
        this.hovered = hovered;
        return this;
    }

    @Nullable
    public GuiSprite getHovered() {
        return this.hovered;
    }

    public void render(GuiGraphics guiGraphics) {
        guiGraphics.blitSprite(this.path, this.textureW, this.textureH, this.u, this.v, this.x, this.y, 0, this.w, this.h);
    }

    public boolean isHovered(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX < (double)this.getEndX() && mouseY >= (double)this.y && mouseY < (double)this.getEndY();
    }

    public void renderSelfAndHovered(GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.render(guiGraphics);
        if (this.hovered != null && this.hovered.isHovered(mouseX, mouseY)) {
            this.hovered.render(guiGraphics);
        }
    }

    public void renderAligned(GuiGraphics guiGraphics, int alignX, int alignY) {
        guiGraphics.blitSprite(this.path, this.textureW, this.textureH, this.u, this.v, this.x + (alignX - this.w) / 2, this.y + (alignY - this.h) / 2, this.w, this.h);
    }
}

