/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.gui.container;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import org.confluence.lib.common.menu.IToggleSlot;
import org.confluence.mod.Confluence;
import org.confluence.mod.client.ClientConfigs;
import org.confluence.mod.client.event.ModClientSetups;
import org.confluence.mod.client.gui.BestiaryScreen;
import org.confluence.mod.client.gui.hud.HouseSelectHUD;
import org.confluence.mod.client.handler.bestiary.ClientBestiary;
import org.confluence.mod.common.attachment.ExtraInventory;
import org.confluence.mod.common.menu.ExtraInventoryMenu;
import org.confluence.mod.integration.mine_team.ExtraTeamRender;
import org.confluence.mod.mixed.IInventoryScreen;
import org.confluence.mod.network.c2s.OpenMenuPacketC2S;
import org.confluence.terra_curio.TerraCurio;
import org.confluence.terra_curio.api.primitive.TooltipComponentsValue;
import org.confluence.terra_curio.client.handler.InformationHandler;
import org.confluence.terra_curio.client.renderer.tooltip.MultiFunctionTooltip;
import org.confluence.terra_curio.common.init.TCItems;
import org.confluence.terra_curio.network.InfoDisablePacket;
import top.theillusivec4.curios.common.network.client.CPacketOpenVanilla;

public class ExtraInventoryScreen
extends AbstractContainerScreen<ExtraInventoryMenu> {
    private static final ResourceLocation BACKGROUND = Confluence.asResource("textures/gui/container/extra_inventory.png");
    private static final ResourceLocation ACCESSORY = TerraCurio.asResource((String)"textures/slot/accessory.png");
    private static final WidgetSprites BESTIARY_BUTTON = new WidgetSprites(Confluence.asResource("widget/bestiary_button"), Confluence.asResource("widget/bestiary_button_highlighted"));
    private static final WidgetSprites HOUSE_BUTTON = new WidgetSprites(Confluence.asResource("widget/house_button"), Confluence.asResource("widget/house_button_highlighted"));
    private static final TooltipComponentsValue.Storage MECHANICAL$LENS = new TooltipComponentsValue.Storage(Confluence.asResource("textures/gui/information/mechanical_lens.png"), (Component)Component.translatable((String)"tooltip.confluence.mechanical_lens"));
    private boolean dyeButtonPressed = false;
    private final ExtraTeamRender teamRender = new ExtraTeamRender(this);
    private ImageButton bestiaryButton;

    public ExtraInventoryScreen(ExtraInventoryMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
    }

    public void render(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.teamRender.renderTeamIcon(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        super.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.renderTooltip(pGuiGraphics, pMouseX, pMouseY);
    }

    protected void init() {
        super.init();
        this.teamRender.initButton();
        this.addRenderableWidget(new ImageButton(this.leftPos + 109, this.topPos + 166, 16, 16, HOUSE_BUTTON, button -> {
            if (((ExtraInventoryMenu)this.menu).getCarried().isEmpty()) {
                this.getMinecraft().setScreen(null);
                HouseSelectHUD.inSelectHUD = true;
            }
        }));
        this.bestiaryButton = new ImageButton(this.leftPos + 125, this.topPos + 166, 16, 16, BESTIARY_BUTTON, button -> {
            if (((ExtraInventoryMenu)this.menu).getCarried().isEmpty()) {
                this.getMinecraft().pushGuiLayer((Screen)this);
                this.getMinecraft().setScreen((Screen)new BestiaryScreen());
            }
        });
        this.addRenderableWidget(this.bestiaryButton);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int i;
        int x;
        guiGraphics.blit(BACKGROUND, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight + 24);
        ExtraInventory extraInventory = ((ExtraInventoryMenu)this.menu).extraInventory;
        int containerSize = extraInventory.getContainerSize();
        int sizeAccessoryDye = extraInventory.getSizeAccessoryDye();
        int size = containerSize - sizeAccessoryDye;
        for (int i2 = 0; i2 < size; ++i2) {
            Slot slot = ((ExtraInventoryMenu)this.menu).getSlot(i2);
            if (!slot.isActive() || slot.hasItem()) continue;
            if (i2 < 8) {
                this.renderVanityArmor(guiGraphics, i2);
                continue;
            }
            if (i2 < 12) {
                guiGraphics.blit(BACKGROUND, this.leftPos + 81, this.topPos + (i2 - 8) * 18 + 8, 177, 153, 16, 16);
                continue;
            }
            if (i2 < 16) {
                guiGraphics.blit(BACKGROUND, this.leftPos + 99, this.topPos + (i2 - 12) * 18 + 8, 177, 136, 16, 16);
                continue;
            }
            if (i2 < 26) {
                this.renderEquipment(guiGraphics, i2 - 16);
                continue;
            }
            if (i2 >= 27) continue;
            guiGraphics.blit(BACKGROUND, this.leftPos + 152, this.topPos + 166, 177, 170, 16, 16);
        }
        if (sizeAccessoryDye > 0) {
            x = this.leftPos - 33;
            int y = this.topPos + 7;
            guiGraphics.blit(BACKGROUND, x, this.topPos, 224, 0, 32, 7);
            for (i = 0; i < sizeAccessoryDye; ++i) {
                guiGraphics.blit(BACKGROUND, x, y, 224, 8, 32, 18);
                if (this.dyeButtonPressed ? ((ExtraInventoryMenu)this.menu).getSlot(27 + i).getItem().isEmpty() : ((ExtraInventoryMenu)this.menu).getSlot(containerSize + i).getItem().isEmpty()) {
                    guiGraphics.blit(ACCESSORY, x + 8, y, 0.0f, 0.0f, 16, 16, 16, 16);
                }
                y += 18;
            }
            guiGraphics.blit(BACKGROUND, x, y, 224, 27, 32, 7);
        }
        if (this.dyeButtonPressed) {
            guiGraphics.blit(BACKGROUND, this.leftPos + 147, this.topPos + 33, 194, 0, 18, 20);
        }
        InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)guiGraphics, (int)(this.leftPos + 26), (int)(this.topPos + 8), (int)(this.leftPos + 75), (int)(this.topPos + 78), (int)30, (float)0.0625f, (float)mouseX, (float)mouseY, (LivingEntity)this.minecraft.player);
        RenderSystem.enableBlend();
        x = this.leftPos + 196;
        int y = this.topPos + 1;
        for (i = 0; i < 12; ++i) {
            if (!InformationHandler.hasInfoData((int)i)) continue;
            TooltipComponentsValue.Storage storage = (TooltipComponentsValue.Storage)TCItems.FULL_INFO.get(i);
            boolean disable = InformationHandler.DISABLE[i];
            if (disable) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            }
            guiGraphics.blit(storage.texture(), x, y, 0.0f, 0.0f, 7, 7, 7, 7);
            if (disable) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            if (mouseX >= x && mouseX < x + 7 && mouseY >= y && mouseY < y + 7) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                guiGraphics.blit(MultiFunctionTooltip.HIGHLIGHT, x - 1, y - 1, 0.0f, 0.0f, 9, 9, 9, 9);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                guiGraphics.renderTooltip(this.font, storage.text(), mouseX, mouseY);
            }
            y += 8;
        }
        RenderSystem.disableBlend();
        if (this.bestiaryButton.isHovered()) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"bestiary.unlocked_count", (Object[])new Object[]{ClientBestiary.getInstance().getUnlockedCount()}), mouseX, mouseY);
        }
    }

    private void renderEquipment(GuiGraphics guiGraphics, int i) {
        if (i >= 5) {
            i -= 5;
        }
        boolean isMount = i == 4;
        guiGraphics.blit(BACKGROUND, this.leftPos + (isMount ? 148 : 121), this.topPos + (isMount ? 8 : i * 18 + 8), isMount ? 194 : 177, isMount ? 68 : 68 + i * 17, 16, 16);
    }

    private void renderVanityArmor(GuiGraphics guiGraphics, int i) {
        if (i >= 4) {
            i -= 4;
        }
        guiGraphics.blit(BACKGROUND, this.leftPos + 8, this.topPos + i * 18 + 8, 177, i * 17, 16, 16);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (mouseX >= (double)(this.leftPos + 147) && mouseX <= (double)(this.leftPos + 165) && mouseY >= (double)(this.topPos + 33) && mouseY <= (double)(this.topPos + 53)) {
            this.dyeButtonPressed = !this.dyeButtonPressed;
            this.toggleAllSlot();
            this.getMinecraft().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)(this.dyeButtonPressed ? 1.0f : 0.8f)));
            return true;
        }
        int x = this.leftPos + 196;
        int y = this.topPos + 1;
        boolean[] disable = InformationHandler.DISABLE;
        for (int i = 0; i < disable.length; ++i) {
            if (!InformationHandler.hasInfoData((int)i)) continue;
            if (mouseX >= (double)x && mouseX < (double)(x + 7) && mouseY >= (double)y && mouseY < (double)(y + 7)) {
                disable[i] = !disable[i];
                InfoDisablePacket.sendToServer((boolean[])disable);
                return true;
            }
            y += 8;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private void toggleAllSlot() {
        ExtraInventory extraInventory = ((ExtraInventoryMenu)this.menu).extraInventory;
        int size = extraInventory.getContainerSize() + extraInventory.getSizeAccessoryDye();
        for (int i = 0; i < size; ++i) {
            IToggleSlot toggleSlot;
            Slot slot = ((ExtraInventoryMenu)this.menu).getSlot(i);
            if (!(slot instanceof IToggleSlot)) continue;
            toggleSlot.setEnable(!(toggleSlot = (IToggleSlot)slot).isEnabled());
        }
    }

    public void onClose() {
        super.onClose();
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        if (player == null) {
            return;
        }
        ItemStack stack = player.containerMenu.getCarried();
        player.containerMenu.setCarried(ItemStack.EMPTY);
        InventoryScreen inventory = new InventoryScreen((Player)player);
        minecraft.setScreen((Screen)inventory);
        player.containerMenu.setCarried(stack);
        PacketDistributor.sendToServer((CustomPacketPayload)new CPacketOpenVanilla(stack), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public <T extends GuiEventListener & Renderable> T addRenderableWidget(T widget) {
        return (T)super.addRenderableWidget(widget);
    }

    public static ImageButton getExtraInventoryButton(EffectRenderingInventoryScreen<?> screen, boolean isInventoryScreen) {
        int x = screen.getGuiLeft() - 16 + ClientConfigs.extraInventoryButtonOffsetX;
        if (!isInventoryScreen && ClientConfigs.extraInventoryButtonOffsetX >= 192) {
            x += 19;
        }
        int y = screen.getGuiTop() + 2 + ClientConfigs.extraInventoryButtonOffsetY;
        ImageButton extraInventoryButton = new ImageButton(x, y, 16, 16, ModClientSetups.EXTRA_INVENTORY_BUTTON, button -> {
            LocalPlayer player = Minecraft.getInstance().player;
            if (player != null) {
                ItemStack stack = player.containerMenu.getCarried();
                player.containerMenu.setCarried(ItemStack.EMPTY);
                OpenMenuPacketC2S.sendToServer((byte)0, stack);
            }
        });
        if (isInventoryScreen) {
            IInventoryScreen.of((InventoryScreen)screen).confluence$setExtraButton((Button)extraInventoryButton);
        }
        return extraInventoryButton;
    }
}

